/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ncm.mvaestado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ModalidadeDeterminacaoBcIcmsSt;
import br.intelidata.commons.domain.pojo.NcmMVAEstado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.NcmMVAEstadoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ncms-mva-estados"})
public class NcmMvaEstadoCrudController
extends CrudController<NcmMVAEstado, NcmMVAEstadoRN> {
    @Autowired
    public NcmMvaEstadoCrudController() {
        super((AbstractRegraNegocio)NcmMVAEstadoRN.getInstance(), NcmMVAEstado::new);
        this.dependsOn("idNcm");
    }

    public GridBuilder<NcmMVAEstadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idNcm", "ID ncm", 0, false));
        colunas.add(new ColunaSQL("idEstadoDestino", "idEstadoDestino", 0, false));
        colunas.add(new ColunaSQL("idIncentivoFiscalDestino", "idIncentivoFiscalDestino", 0, false));
        colunas.add(new ColunaSQL("idEstadoOrigem", "idEstadoOrigem", 0, false));
        colunas.add(new ColunaSQL("idIncentivoFiscalOrigem", "idIncentivoFiscalOrigem", 0, false));
        colunas.add(new ColunaSQL("idTipoEntidade", "idTipoEntidade", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoEstadoOrigem", "UF origem", 30, true, new String[]{"fk_ncmmvaestado_estadoo"}));
        colunas.add(new ColunaSQL("nome", "nomeIncentivoFiscalOrigem", "Incentivo origem", 30, true, new String[]{"fk_ncmmvaestado_ifiscal_o"}));
        colunas.add(new ColunaSQL("codigo", "codigoEstadoDestino", "UF destino", 30, true, new String[]{"fk_ncmmvaestado_estadod"}));
        colunas.add(new ColunaSQL("nome", "nomeIncentivoFiscalDestino", "Incentivo destino", 30, true, new String[]{"fk_ncmmvaestado_ifiscal_d"}));
        colunas.add(new ColunaSQL("descricao", "descricaoTipoEntidade", "Tipo cliente/fornecedor", 30, true, new String[]{"fk_ncmmvaestado_tpentidade"}));
        colunas.add(new ColunaSQL("modalidadeBcIcmsSt", "Mod. BC do ICMS ST", 0, true, ModalidadeDeterminacaoBcIcmsSt.class));
        colunas.add(new ColunaSQL("percMva", "% MVA/Pauta", 0, true));
        colunas.add(new ColunaSQL("percRedMva", "% Red. MVA", 0, true));
        return new GridBuilder(NcmMVAEstadoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(NcmMVAEstado produtoMva, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)produtoMva.getIdNcm())) {
            throw new UnicoMensagemUsuarioException("WWW81", "Ncm n\u00e3o informado");
        }
        List mvaEstados = NcmMVAEstadoRN.getInstance().buscarPorNcm(produtoMva.getIdNcm());
        NcmMVAEstadoRN.getInstance().validarListaMvaEstado(produtoMva, mvaEstados);
    }

    protected String getCacheId() {
        return "ncms-mva-estados";
    }
}

