/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.nfcesat;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscalPDF;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.ParametroNfceSat;
import br.intelidata.commons.domain.pojo.Serie;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.pafecf.InutilizacaoNfce;
import br.intelidata.commons.domain.pojo.pafecf.XmlNfceOriginal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SerieRN;
import br.intelidata.commons.modulo.pdv.patches.CorrigiNfceEmDuplicidade;
import br.intelidata.commons.modulo.pdv.patches.ReconstroiXmlNfce;
import br.intelidata.commons.modulo.pdv.regranegocio.InutilizacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.XmlNfceOriginalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.NfceUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.nfce.DownloadXML;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.sat.SatCrudController;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import unipaf.nfce.GeraDanfeNfce;
import unipaf.nfce.ImpressaoDanfePDF;
import unipaf.pojo.nfce.DanfeNfce;

public abstract class NfceSatCrudController
extends CrudController<Operacao, OperacaoRN> {
    private ResponseEntityService responseEntityService;

    public NfceSatCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)OperacaoRN.getInstance(), Operacao::new, true, true);
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/inutilizar"})
    @DBTransaction
    public void inutlizarNfceSat(@RequestParam String serie, @RequestParam(value="numeroInicial") int numeroInicial, @RequestParam(value="numeroFinal") int numeroFinal, @RequestParam(value="justificativa") String justificativa) throws UnicoMensagemUsuarioException {
        if (numeroInicial > numeroFinal) {
            throw new UnicoMensagemUsuarioException("WPDV510", "Numero inicial deve ser maior que numero final");
        }
        if (justificativa.length() < 15) {
            throw new UnicoMensagemUsuarioException("WPDV511", "Informe no m\u00ednimo 15 caracteres para justificativa");
        }
        OperacaoNfceRN.getInstance().inutilizarNumeracoes(SessaoUtil.getSessao(), serie, numeroInicial, numeroFinal, justificativa, null, null);
    }

    @RequestMapping(value={"/reconstruir-xml"}, method={RequestMethod.POST})
    @DBTransaction
    public void reconstruirXML(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty(ids)) {
            throw new UnicoMensagemUsuarioException("WPDV452", "Selecione somente notas que estiverem como Contingencia rejeitada");
        }
        ReconstroiXmlNfce recontroiXml = new ReconstroiXmlNfce();
        for (Long id : ids) {
            recontroiXml.recontruir(id);
        }
    }

    @RequestMapping(value={"/corrigir-inutilizacao-duplicidade"})
    @DBTransaction
    public void corrigirInutilizacoesEmDuplicidade() throws UnicoMensagemUsuarioException {
        new CorrigiNfceEmDuplicidade().corrigirInutilizacoes();
    }

    @RequestMapping(value={"/corrigir-contigencia-duplicidade"})
    @DBTransaction
    public void corrigirContigenciaEmDuplicidade(@RequestParam(value="novaSerie") Long novaSerie) throws UnicoMensagemUsuarioException {
        Serie serie = (Serie)SerieRN.getInstance().buscarPorId(novaSerie);
        new CorrigiNfceEmDuplicidade().corrigirContigencias(serie.getModelo());
    }

    @RequestMapping(value={"/upload-xml"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public void uploadXml(@RequestPart(value="file") MultipartFile file, @RequestPart(value="idOperacao") Long idOperacao) throws UnicoMensagemUsuarioException, IOException {
        byte[] bFile = file.getBytes();
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        if (operacao != null) {
            if (operacao.getStatusNfce() != StatusNfce.CONTIGENCIA_REJEITADA) {
                throw new UnicoMensagemUsuarioException("WPDV294", "Upload do XML s\u00f3 \u00e9 permitido quando o status da NFC-e for Conting\u00eancia rejeitada");
            }
            StringBuilder sb = new StringBuilder(new String(bFile, StandardCharsets.UTF_8));
            int index = sb.indexOf("Id=");
            if (index == -1) {
                throw new UnicoMensagemUsuarioException("PDV295", "Chave de acesso n\u00e3o encontrada no XML");
            }
            String chave = sb.substring(index + 3, index + 3 + 49);
            if (!(chave = chave.substring(4, chave.length() - 1)).equals(operacao.getChaveAcessoNfce())) {
                throw new UnicoMensagemUsuarioException("WPDV296", "A Chave de acesso do XML \u00e9 diferente da NFC-e:\n   Chave XML: " + chave + "\nChave NFC-e: " + operacao.getChaveAcessoNfce());
            }
            int indIni = sb.indexOf("<Signature");
            int indFim = sb.indexOf("</Signature>");
            if (indIni > -1 && indFim > -1) {
                sb.delete(indIni, indFim + 12);
            }
            String xml = sb.toString();
            XmlNfceOriginal xmlOriginal = XmlNfceOriginalRN.getInstance().buscarPorIdOperacaoNfce(operacao.getId());
            if (xmlOriginal != null) {
                xmlOriginal = null;
            } else {
                xmlOriginal = new XmlNfceOriginal();
                xmlOriginal.setIdOperacaoNfce(operacao.getId());
                xmlOriginal.setXml(operacao.getXmlNfceAutorizado());
            }
            operacao.setXmlNfceAutorizado((byte[])xml.getBytes(StandardCharsets.UTF_8).clone());
            operacao.setStatusRetornoNfce(Integer.valueOf(0));
            operacao.setMensagemRetornoNfce("");
            operacao.setStatusProtocoloNfce(Integer.valueOf(0));
            operacao.setMensagemProtocoloNfce("");
            operacao.setStatusNfce(StatusNfce.EMITIDA_EM_CONTIGENCIA);
            OperacaoRN.getInstance().gravaXml(operacao, xmlOriginal, SessaoUtil.getSessao());
        }
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public DownloadXML downloadXML(@RequestBody Long idOperacao, @RequestParam(required=false, defaultValue="false") boolean substituido) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        if (!substituido) {
            return this.getXMLOperacaoSelecionada(operacao.getChaveAcessoNfce(), operacao.getXmlNfceAutorizado(), operacao.getXmlNfceCancelamento(), () -> this.getInutilizacao(operacao));
        }
        return this.getXMLOperacaoSelecionada(operacao.getChaveAcessoNfcePendente(), operacao.getXmlNfceAutorizadoPendente(), operacao.getXmlNfceCancelamentoPendente(), () -> this.getInutilizacaoPendente(operacao));
    }

    private DownloadXML getXMLOperacaoSelecionada(String nome, byte[] xml, byte[] xmlCancelamento, Supplier<InutilizacaoNfce> supplierInut) throws UnicoMensagemUsuarioException {
        String encode = null;
        if (this instanceof SatCrudController) {
            encode = SessaoUtil.getSessao().getFilial().getParametroNfceSat().getEncodeXmlSat();
        }
        DownloadXML downloadXML = new DownloadXML();
        if (xml != null) {
            downloadXML.setXmlOriginal(OperacaoNfceRN.getInstance().corrigeAssinaturaXml(xml, encode));
        }
        downloadXML.setNome(nome);
        InutilizacaoNfce inut = supplierInut.get();
        if (xmlCancelamento != null) {
            downloadXML.setXmlCancelamento(xmlCancelamento);
        } else if (inut != null) {
            downloadXML.setXmlRet(OperacaoNfceRN.getInstance().corrigeAssinaturaXml(inut.getXmlAutorizado(), encode));
        }
        return downloadXML;
    }

    private InutilizacaoNfce getInutilizacao(Operacao operacao) {
        if (operacao.getStatusNfce() == StatusNfce.NUMERACAO_INUTILIZADA) {
            return InutilizacaoNfceRN.getInstance().buscarPorNumero(operacao);
        }
        return null;
    }

    private InutilizacaoNfce getInutilizacaoPendente(Operacao operacao) {
        if (operacao.getStatusNfcePendente() == StatusNfce.NUMERACAO_INUTILIZADA) {
            return InutilizacaoNfceRN.getInstance().buscarPorNumero(operacao.getFilial(), operacao.getSerieNfcePendente(), operacao.getNumeroNfcePendente(), operacao.getTipoAmbienteNfce());
        }
        return null;
    }

    @RequestMapping(value={"/imprimir-danfe"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirDanfeNFCE(@RequestBody Long idOperacao) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        Filial filial = (Filial)FilialRN.getInstance().buscarPorCodigo(operacao.getFilial());
        ImpressoraNaoFiscalPDF pdf = new ImpressoraNaoFiscalPDF();
        pdf.setCabecalho(ImpressaoDanfePDF.getCabecalhoPadrao((Filial)filial));
        pdf.setLogoTipo(NfceUtil.getLogoTipo((ParametroNfceSat)filial.getParametroNfceSat()));
        DanfeNfce danfe = new GeraDanfeNfce().getDanfe(idOperacao);
        ImpressaoDanfePDF danfePdf = new ImpressaoDanfePDF(danfe, pdf.getColunas());
        return this.responseEntityService.createPDFResponse(pdf.getBytesImpressao(danfePdf.getDanfe().toString()), danfe.getChaveAcesso());
    }

    @RequestMapping(value={"/compiar-xml"})
    @DBAutoCommit
    public String copiarXMl(@RequestParam Long idOperacao, @RequestParam boolean isSat) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        byte[] xml = operacao.getXmlNfceAutorizado();
        if (xml == null) {
            throw new UnicoMensagemUsuarioException("WPDV297", "Documento n\u00e3o possui xml");
        }
        String encode = null;
        if (isSat) {
            encode = SessaoUtil.getSessao().getFilial().getParametroNfceSat().getEncodeXmlSat();
        }
        xml = OperacaoNfceRN.getInstance().corrigeAssinaturaXml(xml, encode);
        return StringUtil.byteArrayToString((byte[])xml);
    }

    @RequestMapping(value={"/mensagem-rodape"})
    @DBAutoCommit
    public String buscaMensagemRodape(@RequestParam Long idOperacao) {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        String mensagemAdicional = operacao.getMsgAdicional();
        return mensagemAdicional == null ? "" : mensagemAdicional.replaceAll(";", "\n");
    }

    protected void beforeRead(Operacao operacao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (operacao != null && "0".equalsIgnoreCase(operacao.getCliente())) {
            operacao.setCliente("");
        }
        List itens = ItemRN.getInstance().buscarListaPorIdOperacao(operacao.getId());
        itens.sort((o1, o2) -> Util.compararObjetos((Comparable)o1.getContador(), (Comparable)o2.getContador()));
        operacao.setItens(itens);
        super.beforeRead((AbstractPojo)operacao, modo, parentId);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Operacao operacao, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        OperacaoRN.getInstance().incluirOperacaoCompleta(operacao, SessaoUtil.getSessao());
        this.gravarAuditoriaRegistro(null, (AbstractPojo)operacao, 0);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return operacao.getId();
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Operacao operacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)operacao);
        this.gravarAuditoriaRegistro(operacao.getId(), (AbstractPojo)operacao, 1);
        OperacaoRN.getInstance().alterarOperacaoCompleta(operacao, SessaoUtil.getSessao());
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return operacao.getId();
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        this.gravarAuditoriaRegistro(id, null, 2);
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(id);
        OperacaoRN.getInstance().excluir(operacao, SessaoUtil.getSessao());
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
    }

    public List<Coluna> getColunasCustomizaveis() {
        return OperacaoNfceRN.getInstance().getColunaCustomizavelOperacaoNFCe();
    }
}

