/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.saida;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.RegistroProducaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalTratamentoImposto;
import java.math.BigDecimal;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Component(value="notas-fiscais-saida")
@RestController
@RequestMapping(value={"/api/notas-fiscais-saida"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Notas fiscais de sa\u00edda", ICONE="icon-nota-fiscal-saida", ROTA="/notas-fiscais/notas-fiscais-saida", PROGRAMA=202)
public class NotaFiscalSaidaCrudController
extends NotaFiscalCrudController {
    @Autowired
    public NotaFiscalSaidaCrudController(NotaFiscalTratamentoImposto tratamentoImposto, CalculoImpostoService<NotaFiscalItem> calculoImpostoService, FuncionalidadeService funcionalidadeService, ArquivoFiscalWeb arquivoFiscal, ModuloService moduloService) {
        super(tratamentoImposto, calculoImpostoService, funcionalidadeService, TipoNotaFiscal.SAIDA, arquivoFiscal, moduloService);
    }

    protected String getCacheId() {
        return "notas-fiscais-saida".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString()).concat("_FAT_POR_VEND_").concat(String.valueOf(SessaoUtil.getSessao().getUsuario().getPreferenciaUsuario().isFiltrarFatVendedorUsuario()));
    }

    @RequestMapping(value={"notas-fiscais-saida-quantidade-volume"})
    @DBAutoCommit
    public BigDecimal quantidadeVolume(@RequestParam Long idNotaFiscal) {
        return ((NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal)).getQuantidade();
    }

    @DBAutoCommit
    protected void afterSave(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String codigoRegistroProducao;
        if (ModuloManager.getInstance().isAtivo(Modulo.PRODUCAO) && !Util.stringNullOrEmpty((String)(codigoRegistroProducao = RegistroProducaoRN.getInstance().buscaCodigoRegistroProducaoAbertoNotaFiscal(notaFiscal.getId())))) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.SUCCESS, "A nota fiscal gerou o registro de produ\u00e7\u00e3o " + codigoRegistroProducao + " com status em Aberto. Verifique neste registro de produ\u00e7\u00e3o, os insumos que possuem lote!");
        }
    }
}

