/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.cartacorrecao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.util.CCE;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.CartaCorrecao;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CartaCorrecaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/cartas-correcoes"})
public class CartaCorrecaoCrudController
extends CrudController<CartaCorrecao, CartaCorrecaoRN> {
    @Autowired
    public CartaCorrecaoCrudController() {
        super((AbstractRegraNegocio)CartaCorrecaoRN.getInstance(), CartaCorrecao::new);
        this.dependsOn("idNotaFiscal");
    }

    @RequestMapping(value={"/recuperar"})
    @DBAutoCommit
    public void recuperarCartas(@RequestParam Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WWW261", "Nota fiscal n\u00e3o encontrada.");
        }
        new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyNfeNow(mensagem)).buscarCartasCorrecao(notaFiscal);
    }

    @RequestMapping(value={"/transmitir"})
    @DBAutoCommit
    public void transmitir(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        new NfeManagerWeb(SessaoUtil.getSessao(), null).enviarCartaCorrecao(id);
    }

    @RequestMapping(value={"/importar-xml"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarXMLWeb(@RequestPart(value="idNotaFiscal") Long idNotaFiscal, @RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            CartaCorrecaoRN.getInstance().importarXMLWeb(SessaoUtil.getSessao(), idNotaFiscal, file.getBytes());
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW262", "N\u00e3o foi poss\u00edvel ler o arquivo");
        }
    }

    @RequestMapping(value={"/imprimir"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarCCe(@RequestBody Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WWW264", "Nota fiscal n\u00e3o encontrada.");
        }
        return this.responseEntityService.createPDFResponse(CCE.getInstance().geraCCEWeb(notaFiscal.getId()), "CCE-".concat(notaFiscal.getChaveNfe()));
    }

    protected String getCacheId() {
        return "cartas-correcoes";
    }

    protected GridBuilder<CartaCorrecaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("sequencia", "Sequ\u00eancia", 100, true));
        colunas.add(new ColunaSQL("dataHora", "Data", 130, true));
        colunas.add(new ColunaSQL("descricao", "Texto", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 130, true));
        colunas.add(new ColunaSQL("mensagemRetorno", "Mensagem de retorno da transmiss\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(((CartaCorrecaoRN)this.rn).getTabela(), colunas);
        grid.setReferenciaDefault(new Referencia("idNotaFiscal"));
        return grid;
    }

    protected void beforeCreate(CartaCorrecao cartaCorrecao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (CartaCorrecaoRN.getInstance().getQuantidadeCartasPorIdNotaFiscal(cartaCorrecao.getIdNotaFiscal()) >= CartaCorrecaoRN.getInstance().getQuantidadeMaximaCartasPorNotaFiscal()) {
            throw new UnicoMensagemUsuarioException("WNTF358", "N\u00e3o \u00e9 permitido cadastrar mais que " + CartaCorrecaoRN.getInstance().getQuantidadeMaximaCartasPorNotaFiscal() + " cartas de corre\u00e7\u00e3o para cada nota fiscal");
        }
        if (CartaCorrecaoRN.getInstance().getQuantidadeCartasAbertasPorIdNotaFiscal(cartaCorrecao.getIdNotaFiscal()) >= 1) {
            throw new UnicoMensagemUsuarioException("WNTF359", "N\u00e3o \u00e9 permitido mais que uma carta de corre\u00e7\u00e3o em aberto para cada nota fiscal");
        }
    }

    protected void beforeSave(CartaCorrecao cartaCorrecao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)cartaCorrecao.getIdNotaFiscal())) {
            throw new UnicoMensagemUsuarioException("WWW265", "Nota fiscal n\u00e3o informada.");
        }
    }
}

