/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.domain.pojo.DocumentoDestinado;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroConsultaDocumentoDestinatario;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoDestinadoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DocumentoDestinadoCrudController
extends CrudController<DocumentoDestinado, DocumentoDestinadoRN> {
    private final TipoRegistroConsultaDocumentoDestinatario tipoConsulta;

    public DocumentoDestinadoCrudController(TipoRegistroConsultaDocumentoDestinatario tipoConsulta) {
        super((AbstractRegraNegocio)DocumentoDestinadoRN.getInstance(), DocumentoDestinado::new, true, true);
        this.tipoConsulta = tipoConsulta;
    }

    @RequestMapping(value={"/consultar-documentos"})
    @DBTransaction
    public void consultarDocumentos(@RequestParam boolean consultarTodos) throws UnicoMensagemUsuarioException {
        NfeManagerWeb nfeManager;
        String mensagemCertificado;
        Long nsu = ((Filial)FilialRN.getInstance().buscarPorId(SessaoUtil.getSessao().getIdFilial())).getUltimoNsuConsultaNfe();
        if (consultarTodos || nsu == null) {
            nsu = 0L;
        }
        if (!StringUtil.stringNullOrEmpty((String)(mensagemCertificado = (nfeManager = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyNfeNow(mensagem))).getValidadeCertificado()))) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, mensagemCertificado);
        }
        nfeManager.consultarDocumentosFiscais(nsu.longValue());
    }

    protected GridBuilder<DocumentoDestinadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        boolean ordernarEmissao = false;
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("chaveAcesso", "chaveAcessoGrid", "Chave de acesso", 0, false, new String[0]));
        colunas.add(new ColunaSQL("chaveAcesso", "Chave de acesso", 0, true));
        if (this.tipoConsulta.equals((Object)TipoRegistroConsultaDocumentoDestinatario.NFE)) {
            ordernarEmissao = true;
            colunas.add(new ColunaSQL("razaoSocial", "Raz\u00e3o social", 250, true));
            colunas.add(new ColunaSQL("cnpj", "CNPJ", 120, true));
            colunas.add(new ColunaSQL("tipoOperacao", "Tipo", 100, true));
            colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 100, true));
            colunas.add(new ColunaSQL("autorizacao", "Autoriza\u00e7\u00e3o", 130, true));
            ColunaSQL colunaValor = new ColunaSQL("valor", "Valor", 100, true);
            colunaValor.setTotalizar(true);
            colunas.add(colunaValor);
            colunas.add(new ColunaSQL("situacaoNfe", "Situa\u00e7\u00e3o NF-e", 130, true));
            colunas.add(new ColunaSQL("situacaomanifestacaodest", "Situa\u00e7\u00e3o manifesta\u00e7\u00e3o", 130, true));
        } else if (this.tipoConsulta.equals((Object)TipoRegistroConsultaDocumentoDestinatario.CARTA_CORRECAO) || this.tipoConsulta.equals((Object)TipoRegistroConsultaDocumentoDestinatario.CANCELADO) || this.tipoConsulta.equals((Object)TipoRegistroConsultaDocumentoDestinatario.OUTRO)) {
            colunas.add(new ColunaSQL("dataHora", "Data", 130, true));
            colunas.add(new ColunaSQL("sequencia", "Sequencia", 100, true));
            colunas.add(new ColunaSQL("correcao", "Corre\u00e7\u00e3o", 300, true));
            if (this.tipoConsulta.equals((Object)TipoRegistroConsultaDocumentoDestinatario.OUTRO)) {
                colunas.add(new ColunaSQL("tipoEvento", "Evento", 100, true));
                colunas.add(new ColunaSQL("descricaoEvento", "Descri\u00e7\u00e3o do evento", 300, true));
            }
        }
        GridBuilder grid = new GridBuilder(((DocumentoDestinadoRN)this.rn).getTabela(), colunas, "documentos_destinados_" + this.tipoConsulta.name());
        grid.addReferenciaDefault(new Referencia("tipo"));
        grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, this.tipoConsulta.getId().intValue()));
        grid.addReferenciaDefault(new Referencia("idFilial"));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IS_NULL));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, Long.valueOf(0L)));
        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        if (ordernarEmissao) {
            grid.addReferenciaDefault(new Referencia("emissao"));
            grid.addOrdemDefault(new Ordem("emissao", true));
        } else {
            grid.addReferenciaDefault(new Referencia("dataHora"));
            grid.addOrdemDefault(new Ordem("dataHora", true));
        }
        return grid;
    }
}

