/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.inutilizacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.InutilizacaoNfe;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.InutilizacaoNfeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/inutilizacoes-nfe"})
public class InutilizacaoNfeCrudController
extends CrudController<InutilizacaoNfe, InutilizacaoNfeRN> {
    @Autowired
    public InutilizacaoNfeCrudController() {
        super((AbstractRegraNegocio)InutilizacaoNfeRN.getInstance(), InutilizacaoNfe::new, true, true);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        InutilizacaoNfe inutilizaNfe = (InutilizacaoNfe)InutilizacaoNfeRN.getInstance().buscarPorId(id);
        if (inutilizaNfe == null) {
            throw new UnicoMensagemUsuarioException("WNTF36", "Inutiliza\u00e7\u00e3o n\u00e3o encontrada.");
        }
        if (inutilizaNfe.getArquivoXml() == null) {
            throw new UnicoMensagemUsuarioException("WNTF35", "Nenhum arquivo xml foi encontrado para essa nota fiscal.");
        }
        return this.responseEntityService.createXMLResponse(inutilizaNfe.getArquivoXml(), inutilizaNfe.getProtocolo() + "-inut.xml");
    }

    protected String getCacheId() {
        return "inutilizacoes-nfe";
    }

    protected GridBuilder<InutilizacaoNfeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 0, true));
        colunas.add(new ColunaSQL("sequenciaInicial", "Sequencia inicial", 0, true));
        colunas.add(new ColunaSQL("sequenciaFinal", "Sequencia final", 0, true));
        colunas.add(new ColunaSQL("mensagemRetorno", "Mensagem", 320, true));
        colunas.add(new ColunaSQL("protocolo", "Protocolo", 0, true));
        GridBuilder grid = new GridBuilder(((InutilizacaoNfeRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idFilial"));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.setOrdemDefault(new Ordem("data", true));
        return grid;
    }
}

