/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.inutilizacao;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.domain.pojo.InutilizacaoNfe;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.notafiscal.regranegocio.InutilizacaoNfeRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/inutilizacoes-nfe"})
public class InutilizacaoNfeJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public InutilizacaoNfeJobController(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setMsg(compartilhamento.getMensagem());
        InutilizacaoNfe inutilizacaoNfe = (InutilizacaoNfe)InutilizacaoNfeRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (inutilizacaoNfe == null) {
            throw new UnicoMensagemUsuarioException("CTE160", "Inutiliza\u00e7\u00e3o n\u00e3o encontrada.");
        }
        String assunto = "Inutiliza\u00e7\u00e3o de numera\u00e7\u00e3o de NF-e da empresa " + sessao.getFilial().getRazaoSocialCompleta();
        notificacao.setAssunto(assunto);
        Malote malote = new Malote();
        InputStreamDataSource source = null;
        if (inutilizacaoNfe.getArquivoXml() != null) {
            String arquivo = inutilizacaoNfe.getProtocolo() + "-inut.xml";
            source = new InputStreamDataSource(arquivo, "text/xml", (InputStream)new ByteArrayInputStream(inutilizacaoNfe.getArquivoXml()));
            malote.inclui(arquivo, inutilizacaoNfe.getArquivoXml());
        }
        notificacao.setDataSources(new DataSource[]{source});
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Inutiliza\u00e7\u00e3o de numera\u00e7\u00e3o");
        taskEmail.createTask((Object)parametrosEmail, compartilhamento.getAssunto());
    }
}

