/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscalobslancamentofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.domain.pojo.enuns.nfe.TipoBaseCalculoObservacoesFiscais;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalObsLancamentoFiscal;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalObsLancamentoFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.ObsLancamentoFiscalComplementarRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class NotaFiscalObsLancamentoFiscalSimpleControler
extends SimpleCrudController<NotaFiscalObsLancamentoFiscal, NotaFiscalObsLancamentoFiscalRN> {
    public NotaFiscalObsLancamentoFiscal get(Long parentId) throws UnicoMensagemUsuarioException {
        return new NotaFiscalObsLancamentoFiscal();
    }

    @RequestMapping(value={"/carregar-obs"})
    @DBAutoCommit
    public List<NotaFiscalObsLancamentoFiscal> buscarLista(@RequestParam Long idNotaFiscal) {
        List observacoes = NotaFiscalObsLancamentoFiscalRN.getInstance().buscarPorIdNotaFiscal(idNotaFiscal);
        if (observacoes != null) {
            for (NotaFiscalObsLancamentoFiscal observacao : observacoes) {
                observacao.setComplementos(ObsLancamentoFiscalComplementarRN.getInstance().buscarPorIdObsLancamentoFiscal(observacao.getId()));
            }
        }
        return observacoes;
    }

    @RequestMapping(value={"/carregar-itens"})
    @DBAutoCommit
    public List<MapResultSet> carregarItensNotaFiscal(@RequestParam Long idNotaFiscal) {
        return NotaFiscalItemRN.getInstance().buscarMapItensParaImportarC197(idNotaFiscal, TipoBaseCalculoObservacoesFiscais.NF);
    }

    @RequestMapping(value={"/carregar-produtos"})
    @DBAutoCommit
    public List<MapResultSet> carregarProdutosNotaFiscal(@RequestParam Long idNotaFiscal) {
        return NotaFiscalItemRN.getInstance().getComboPorNotaFiscalC197Web(idNotaFiscal);
    }

    @RequestMapping(value={"/carregar-base"})
    @DBAutoCommit
    public BigDecimal carregarBaseIcms(@RequestParam Long idProduto, @RequestParam Long idNotaFiscal) {
        BigDecimal baseValorIcms = BigDecimal.ZERO;
        List notaFiscalItems = NotaFiscalItemRN.getInstance().buscarListaByIdNotaFiscal(idNotaFiscal);
        for (NotaFiscalItem notaFiscalItem : notaFiscalItems) {
            if (!notaFiscalItem.getIdProduto().equals(idProduto)) continue;
            baseValorIcms = baseValorIcms.add(notaFiscalItem.getBaseIcms());
        }
        return baseValorIcms;
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravar(@RequestBody List<NotaFiscalObsLancamentoFiscal> obsLancamentoFiscals, @RequestParam Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscalObsLancamentoFiscalRN.getInstance().atualizarObservacoesPorNotaFiscal(SessaoUtil.getSessao(), idNotaFiscal, obsLancamentoFiscals);
    }
}

