/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.operacao.item;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/item"})
public class ItemCrudController
extends CrudController<Item, ItemRN> {
    public ItemCrudController() {
        super((AbstractRegraNegocio)ItemRN.getInstance(), Item::new);
    }

    @RequestMapping(value={"busca-por-idoperacao"})
    @DBAutoCommit
    public List<Item> buscarPorIdOperacao(@RequestParam(value="idOperacao") Long idOperacao) {
        return ItemRN.getInstance().buscarListaPorIdOperacao(idOperacao, false);
    }

    protected GridBuilder<ItemRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("produto", "Produto", 0, true));
        return new GridBuilder(ItemRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "item";
    }
}

