/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.operacao.recebimento;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Recebimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.RecebimentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/recebimento"})
public class RecebimentoCrudController
extends CrudController<Recebimento, RecebimentoRN> {
    public RecebimentoCrudController() {
        super((AbstractRegraNegocio)RecebimentoRN.getInstance(), Recebimento::new);
    }

    @RequestMapping(value={"busca-por-idoperacao"})
    @DBAutoCommit
    public List<Recebimento> buscarPorIdOperacao(@RequestParam(value="idOperacao") Long idOperacao) {
        return RecebimentoRN.getInstance().buscarListaPorOperacao(idOperacao);
    }

    protected GridBuilder<RecebimentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        return new GridBuilder(RecebimentoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "recebimento";
    }
}

