/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.operacaofiscal;

import br.intelidata.commons.core.sistema.ItemComboBox;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.OperacaoFiscal;
import br.intelidata.commons.domain.pojo.enuns.FinalidadeEmissaoNfeCFOP;
import br.intelidata.commons.domain.pojo.enuns.TipoCfopConsignacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.OperacaoFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/operacoes-fiscais"})
public class OperacaoFiscalCrudController
extends CrudController<OperacaoFiscal, OperacaoFiscalRN> {
    public OperacaoFiscalCrudController() {
        super((AbstractRegraNegocio)OperacaoFiscalRN.getInstance(), OperacaoFiscal::new);
    }

    @RequestMapping(value={"/combo-propriedades"})
    @DBAutoCommit
    public List<ItemComboBox> getComboPropriedade() {
        return this.getCombo().stream().map(o -> new ItemComboBox((Object)o.getId(), o.getNome())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<OperacaoFiscal> getCombo() {
        return OperacaoFiscalRN.getInstance().getComboWeb();
    }

    @RequestMapping(value={"/filtrar-por-finalidade"})
    @DBAutoCommit
    public List<OperacaoFiscal> filtarPorFinalidade(@RequestParam FinalidadeEmissaoNfeCFOP finalidade, @RequestParam(required=false) String query, @RequestParam(defaultValue="6", required=false) int limit) {
        return OperacaoFiscalRN.getInstance().getDadosAutoCompleteFinalidadeWeb(finalidade, query, limit);
    }

    @RequestMapping(value={"/filtrar-por-consignacao"})
    @DBAutoCommit
    public List<OperacaoFiscal> filtarPorConsignacao(@RequestParam TipoCfopConsignacao consignacao, @RequestParam(required=false) String query, @RequestParam(defaultValue="6", required=false) int limit) {
        return OperacaoFiscalRN.getInstance().getDadosAutoCompletePorTipoConsignacaoWeb(consignacao, query, limit);
    }

    protected GridBuilder<OperacaoFiscalRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 100, true));
        GridBuilder gridBuilder = new GridBuilder(OperacaoFiscalRN.getInstance().getTabela(), colunas);
        gridBuilder.setOrdemDefault(new Ordem("nome"));
        return gridBuilder;
    }

    protected String getCacheId() {
        return "operacoes-fiscais";
    }
}

