/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.ordemservicofaturamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.ConfiguracaoOrdemServico;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.OrcamentoFaturamento;
import br.intelidata.commons.domain.pojo.OrdemServico;
import br.intelidata.commons.domain.pojo.OrdemServicoDadosFinanceiroFaturamento;
import br.intelidata.commons.domain.pojo.OrdemServicoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.OrdemServicoItem;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.EscopoCondicaoPagamento;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimento;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.NaturezaOperacaoCommonRN;
import br.intelidata.commons.domain.regranegocio.OrdemServicoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.ConfiguracaoOrdemServicoRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.FaturadorOrdemServico;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoItemRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.ordemservicofaturamento.FaturamentoOSWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.ordemservicofaturamento.FaturamentoOsRetornoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ordem-servico-faturamento"})
public class OrdemServicoFaturamentoCrudController
extends SimpleCrudController {
    @RequestMapping(value={"/gerar-parcelas"})
    @DBAutoCommit
    public List<OrdemServicoDocumentoFinanceiro> gerarParcelas(@RequestParam Long idCondicaoPagamento, @RequestParam BigDecimal total, @RequestParam(required=false) boolean isSaida, @RequestParam Long idEntidade, @RequestParam Long idTipoDocumentoFinanceiro, @RequestParam(required=false) String dataPedido, @RequestParam String dataEmissao, @RequestParam(required=false, defaultValue="0") int diaFaturamentoContrato, @RequestParam(required=false) String dataVencimentoContrato) throws UnicoMensagemUsuarioException {
        total = total.setScale(2, RoundingMode.HALF_EVEN);
        return OrdemServicoDocumentoFinanceiroRN.getInstance().gerarParcelas(idCondicaoPagamento, total, isSaida, idEntidade, idTipoDocumentoFinanceiro, !StringUtil.stringNullOrEmpty((String)dataPedido) ? DataHoraFactory.string2LocalDate((String)dataPedido, (String)"dd/MM/yyyy") : null, DataHoraFactory.string2LocalDate((String)dataEmissao, (String)"dd/MM/yyyy"), diaFaturamentoContrato, !StringUtil.stringNullOrEmpty((String)dataVencimentoContrato) ? DataHoraFactory.string2LocalDate((String)dataVencimentoContrato, (String)"dd/MM/yyyy") : null, SessaoUtil.getSessao().getFilial());
    }

    @RequestMapping(value={"/ordem-servico-faturar"}, method={RequestMethod.POST})
    @DBTransaction
    public FaturamentoOsRetornoWrapper faturarOrdemServico(@RequestBody FaturamentoOSWrapper faturamentoOSWrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List listaOS = OrdemServicoRN.getInstance().buscarListaPorIds(faturamentoOSWrapper.getIds());
        OrdemServicoRN.getInstance().validarListaIdsOrdensServico(faturamentoOSWrapper.getIds(), true);
        OrdemServicoDadosFinanceiroFaturamento dadosFinanceiro = faturamentoOSWrapper.getDadosFina();
        this.validarCliente(sessao, dadosFinanceiro.getIdCondicaoPagamento(), (OrdemServico)listaOS.get(0));
        this.validarTimeMillisOS(faturamentoOSWrapper.getMapMillis(), listaOS);
        if (this.validarCamposFinanceiro(sessao, (Long)faturamentoOSWrapper.getIds().get(0), ((OrdemServico)listaOS.get(0)).getIdCliente(), listaOS) && dadosFinanceiro.getIdCondicaoPagamento() == null) {
            throw new UnicoMensagemUsuarioException("WORS56", "Informe a condi\u00e7\u00e3o de pagamento");
        }
        if (LimiteCreditoRN.getInstance().isVerificarLimiteCredito(sessao, dadosFinanceiro)) {
            try {
                LimiteCreditoRN.getInstance().validarLimiteCredito(sessao, dadosFinanceiro, listaOS);
            }
            catch (UnicoPerguntaUsuarioException e) {
                throw new UnicoMensagemUsuarioException("WORS156", "Gera\u00e7\u00e3o da nota fiscal n\u00e3o confirmada!" + e.getMensagemSemCodigoDeErro());
            }
        }
        OrdemServicoRN.getInstance().atualizarInfoFaturamentoListaOS(sessao, listaOS, dadosFinanceiro.getIdTipoDocumento(), dadosFinanceiro.getIdCondicaoPagamento(), ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(sessao), dadosFinanceiro.isRecalcularPrecoAoTrocarCondicaoPagto());
        List notasGeradas = FaturadorOrdemServico.getInstance().faturarParaNotaFiscal(sessao, listaOS, dadosFinanceiro, Long.valueOf(0L));
        FaturamentoOsRetornoWrapper retorno = new FaturamentoOsRetornoWrapper();
        String msg = " gerada com sucesso";
        for (NotaFiscal nota : notasGeradas) {
            for (NotaFiscalItem item : nota.getNotaFiscalItens()) {
                item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null));
            }
        }
        if (notasGeradas.size() > 1) {
            String numeros = notasGeradas.stream().map(NotaFiscal::getNumeroNotaFiscal).collect(Collectors.joining(","));
            msg = "NF-es " + numeros + " geradas com sucesso";
        } else {
            NotaFiscal notaFiscal = (NotaFiscal)notasGeradas.get(0);
            boolean nfe = notaFiscal.getSerie().equalsIgnoreCase("55");
            msg = nfe ? "NF-e " + notaFiscal.getNumeroNotaFiscal() + msg : "NFS-e " + notaFiscal.getNumeroNotaFiscal() + msg;
            if (NumberUtil.longNullOuZero((Long)notaFiscal.getId())) {
                retorno.setNotaFiscal(notaFiscal);
            }
        }
        retorno.setMsg(msg);
        return retorno;
    }

    @RequestMapping(value={"/ordem-servico-condicao-pag-default"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Long carregarCondPagtoFormaPagtoDefault(@RequestBody Long idOrdemServico) {
        OrdemServico ordemServico = null;
        Long idCondicaoPagamento = null;
        if (idOrdemServico != null) {
            ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(idOrdemServico);
            idCondicaoPagamento = ordemServico.getIdCondicaoPagamento();
        }
        if (ordemServico != null) {
            Entidade entidade;
            OrcamentoFaturamento orcamentoFaturamento;
            if (NumberUtil.longNullOuZero(idCondicaoPagamento) && !NumberUtil.longNullOuZero((Long)ordemServico.getIdOrcamentoFaturamento()) && (orcamentoFaturamento = (OrcamentoFaturamento)OrcamentoFaturamentoRN.getInstance().buscarPorId(ordemServico.getIdOrcamentoFaturamento())) != null) {
                idCondicaoPagamento = orcamentoFaturamento.getIdcondicaopagamento();
            }
            if (NumberUtil.longNullOuZero(idCondicaoPagamento) && (entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(ordemServico.getIdCliente())) != null) {
                idCondicaoPagamento = entidade.getIdCondicaoPagamento();
            }
        }
        if (!NumberUtil.longNullOuZero(idCondicaoPagamento)) {
            return idCondicaoPagamento;
        }
        List condicoes = CondicaoPagamentoRN.getInstance().buscarLista();
        if (!condicoes.isEmpty()) {
            Supplier<Stream> condicoesVenda = () -> condicoes.stream().filter(cond -> EscopoCondicaoPagamento.VENDA.equals((Object)cond.getEscopo()) || EscopoCondicaoPagamento.COMPRA_VENDA.equals((Object)cond.getEscopo()));
            List condAVista = condicoesVenda.get().filter(cond -> cond.getPrazos().equals("0") || cond.getPrazos().equals("1")).collect(Collectors.toList());
            if (condAVista.isEmpty()) {
                condAVista = condicoesVenda.get().filter(cond -> cond.getPrazoMedio() == 0).collect(Collectors.toList());
                if (!condAVista.isEmpty()) {
                    condAVista.sort(Comparator.comparing(CondicaoPagamento::getFator));
                    return ((CondicaoPagamento)condAVista.get(0)).getId();
                }
            } else {
                condAVista.sort(Comparator.comparing(CondicaoPagamento::getFator));
                return ((CondicaoPagamento)condAVista.get(0)).getId();
            }
        }
        return 0L;
    }

    @RequestMapping(value={"/ordem-servico-validar-descontos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void validarDescontosSubtotalOS(@RequestBody List<Long> idsOrdemServico) throws UnicoMensagemUsuarioException {
        for (Long idOrdemServico : idsOrdemServico) {
            OrdemServico ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(idOrdemServico);
            if (!OrdemServicoRN.getInstance().descontoSubtotalItensDiferenteDoCabecalho(ordemServico)) continue;
            throw new UnicoMensagemUsuarioException("WORS57", "Inconsist\u00eancia nos descontos: a soma dos descontos dos itens n\u00e3o corresponde ao valor informado no subtotal da OS: " + ordemServico.getCodigo() + ". Regrave a OS e tente novamente.");
        }
    }

    @RequestMapping(value={"/ordem-servico-calc-cond-pagamento"})
    @DBAutoCommit
    public FaturamentoOsRetornoWrapper calcularPorCndicaoPagamentoFaturamento(@RequestParam List<Long> ids, @RequestParam Long idCondicaoPagamento, @RequestParam boolean alterouPagamento) throws UnicoMensagemUsuarioException {
        List listOs = OrdemServicoCommonRN.getInstance().buscarListaPorIds(ids);
        this.validarCliente(SessaoUtil.getSessao(), idCondicaoPagamento, (OrdemServico)listOs.get(0));
        ArrayList<OrdemServicoItem> itens = new ArrayList<OrdemServicoItem>();
        for (OrdemServico os2 : listOs) {
            OrdemServicoRN.getInstance().buscarFilhos(os2);
            List itensOS = os2.getItens();
            if (Util.listNullOrEmpty((List)itensOS)) {
                itensOS = OrdemServicoItemRN.getInstance().buscarListaPorIdOrdemServico(os2.getId());
            }
            for (OrdemServicoItem ordemServicoItem : itensOS) {
                if (ordemServicoItem.getBrinde() == 1 || os2.isFaturouParaCupom() && TipoRegistroProduto.PRODUTO.equals((Object)ordemServicoItem.getTipoProduto())) continue;
                itens.add(ordemServicoItem);
            }
        }
        ConfiguracaoOrdemServico configuracaoOS = ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao());
        Map<TipoRegistroProduto, List<OrdemServicoItem>> mapProdServOs = itens.stream().collect(Collectors.groupingBy(OrdemServicoItem::getTipoProduto));
        if (alterouPagamento) {
            boolean isPautaPorItem = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_ITEM);
            for (Map.Entry entry : mapProdServOs.entrySet()) {
                for (OrdemServicoItem osItem : (List)entry.getValue()) {
                    BigDecimal preco;
                    OrdemServico ordemServico = listOs.stream().filter(os -> os.getId().equals(osItem.getIdOrdemServico())).findFirst().orElse(null);
                    if (ordemServico == null) continue;
                    boolean recalcularPreco = OrdemServicoItemRN.getInstance().isRecalcarPrecoItemFaturamento(SessaoUtil.getSessao(), osItem, ordemServico, configuracaoOS);
                    if (NumberUtil.longNullOuZero((Long)ordemServico.getIdCondicaoPagamento())) {
                        preco = osItem.getPrecoInformado();
                    } else {
                        ProdutoPreco produtoPreco;
                        preco = osItem.getPrecoOriginal();
                        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)preco) && NumberUtil.bigDecimalNullOrZero((BigDecimal)(preco = (produtoPreco = ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(SessaoUtil.getSessao().getFilial(), osItem.getIdProduto(), isPautaPorItem ? osItem.getPautaPreco() : ordemServico.getPautaPreco(), VariacaoRN.getInstance().stringToMap(osItem.getVariacoes()), osItem.getIdEmbalagem()))).getPreco()))) {
                            preco = Util.seBigDecimalNullOrZeroEntao((BigDecimal)osItem.getPrecoInformado(), (BigDecimal)osItem.getPreco());
                        }
                    }
                    if (recalcularPreco) {
                        osItem.setPreco(CondicaoPagamentoRN.getInstance().calcularPrecoPorCondicaoPagamento(idCondicaoPagamento, preco));
                    } else {
                        osItem.setPreco(preco);
                    }
                    BigDecimal totalItem = osItem.getPreco().multiply(osItem.getQuantidade());
                    totalItem = Util.valorComDesconto((BigDecimal)totalItem, (BigDecimal)osItem.getPercentualDesconto(), (int)2).subtract(osItem.getDescontoSubTotal());
                    osItem.setTotal(totalItem);
                }
            }
        }
        List notasFiscaisOS = FaturadorOrdemServico.getInstance().criarNotasFiscais(SessaoUtil.getSessao(), configuracaoOS, listOs, mapProdServOs, null, idCondicaoPagamento);
        BigDecimal total = BigDecimal.ZERO;
        for (NotaFiscal notaFiscal : notasFiscaisOS) {
            Map cfop = NaturezaOperacaoCommonRN.getInstance().buscarValoresPorID(notaFiscal.getIdCfop(), new String[]{"integracao"});
            boolean geraFinanceiro = cfop != null && !((TipoIntegracaoFinanceiro)EnumUtils.getPorId(TipoIntegracaoFinanceiro.class, cfop.get("integracao"), (AbstractEnum)TipoIntegracaoFinanceiro.NENHUM)).equals((Object)TipoIntegracaoFinanceiro.NENHUM);
            if (!geraFinanceiro) continue;
            total = total.add(notaFiscal.getTotalFinanceiroItens());
        }
        FaturamentoOsRetornoWrapper faturamentoOsRetornoWrapper = new FaturamentoOsRetornoWrapper();
        faturamentoOsRetornoWrapper.setListaOs(listOs);
        faturamentoOsRetornoWrapper.setTotal(total);
        return faturamentoOsRetornoWrapper;
    }

    private void validarCliente(Sessao sessao, Long idCondPagamento, OrdemServico os) throws UnicoMensagemUsuarioException {
        boolean condPagtoPrazoZero = CondicaoPagamentoRN.getInstance().isCondicaoPagamentoPrazoZero(idCondPagamento);
        if (!condPagtoPrazoZero) {
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(os.getIdCliente());
            if (!CondicaoPagamentoRN.getInstance().isCondicaoPagamentoAVista(idCondPagamento) || PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 711)) {
                EntidadeRN.getInstance().permiteVender(sessao, entidade, true, true);
                if (entidade != null && !EntidadeRN.getInstance().isLiberaVendaClienteAtrasado(entidade) && EntidadeRN.getInstance().isEntidadeBloqueadaPorAtraso(sessao, entidade.getId())) {
                    throw new UnicoMensagemUsuarioException("WORS54", "O cliente possui documentos em atraso.");
                }
            }
        }
    }

    private void validarTimeMillisOS(Map<Long, Long> mapMillis, List<OrdemServico> listOs) throws UnicoMensagemUsuarioException {
        for (Map.Entry<Long, Long> entry : mapMillis.entrySet()) {
            if (entry.getValue() == null) continue;
            Long timeMillisBanco = SGBDManager.getInstance().buscarDataHoraObjeto(OrdemServicoRN.getInstance().getTabela(), entry.getKey());
            if (entry.getValue().compareTo(timeMillisBanco) == 0) continue;
            OrdemServico ordemServico = listOs.stream().filter(os -> os.getId().equals(entry.getKey())).findFirst().get();
            throw new UnicoMensagemUsuarioException("WORS135", "A ordem de servi\u00e7o " + ordemServico.getCodigo() + " sofreu altera\u00e7\u00f5es depois que foi carregada para faturamento!\nPor favor selecione a ordem de servi\u00e7o novamente para faturamento.");
        }
    }

    private boolean validarCamposFinanceiro(Sessao sessao, Long idOs, Long idEntidade, List<OrdemServico> listOs) throws UnicoMensagemUsuarioException {
        Long idCfop;
        boolean apenasServicos;
        ConfiguracaoOrdemServico configuracaoOS = ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(sessao);
        Entidade entidade = null;
        Estado estado = null;
        boolean vendaInterna = true;
        boolean substitutoTributarioISS = false;
        if (idOs != null) {
            OrdemServico ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(idOs);
            if (ordemServico != null) {
                entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(ordemServico.getIdCliente());
            }
        } else {
            entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
        }
        if (entidade != null) {
            estado = (Estado)EstadoRN.getInstance().buscarPorId(entidade.getEndereco().getIdEstado());
            vendaInterna = entidade.getEndereco().getIdEstado().equals(sessao.getFilial().getIdEstado());
            substitutoTributarioISS = entidade.isSubstitutoTributarioISS();
        }
        if (apenasServicos = idOs != null ? OrdemServicoRN.getInstance().isOsApenasServico(idOs) : OrdemServicoRN.getInstance().isOsApenasServico(listOs)) {
            idCfop = substitutoTributarioISS ? (vendaInterna ? configuracaoOS.getIdCFOPInternaServicoST() : configuracaoOS.getIdCFOPExternaServicoST()) : (vendaInterna ? configuracaoOS.getIdCFOPInternaServico() : configuracaoOS.getIdCFOPExternaServico());
        } else {
            Long l = idCfop = vendaInterna ? configuracaoOS.getIdCFOPInternaProduto() : configuracaoOS.getIdCFOPExternaProduto();
        }
        if (NumberUtil.longNullOuZero((Long)idCfop) && estado != null) {
            idCfop = NaturezaOperacaoRN.getInstance().getCFOPDefault(6, estado.getCodigo(), TipoMovimento.SAIDA, sessao.getFilial());
        }
        if (idCfop != null) {
            NaturezaOperacao cfop = NaturezaOperacaoRN.getInstance().buscarPorId(idCfop);
            return TipoIntegracaoFinanceiro.RECEBER.equals((Object)cfop.getIntegracao());
        }
        return false;
    }
}

