/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Empresa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.PreferenciaUsuario;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.VersaoLayoutNfe;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusProcessamento;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusReplicacao;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.pdv.regranegocio.NumeracaoOperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;

public class InicioOperacaoWeb {
    public Operacao iniciarNovaOperacao(Sessao sessao, TipoOperacao tipoOperacao) throws UnicoMensagemUsuarioException {
        return this.iniciarNovaOperacao(sessao, tipoOperacao, null);
    }

    public Operacao iniciarNovaOperacao(Sessao sessao, TipoOperacao tipoOperacao, Operacao op) throws UnicoMensagemUsuarioException {
        Empresa empresa = (Empresa)EmpresaRN.getInstance().buscarPorId(sessao.getFilial().getIdEmpresa());
        Operacao operacao = new Operacao();
        if (op != null) {
            operacao = op;
        }
        operacao.setTipo(tipoOperacao);
        operacao.setEmpresa(empresa != null ? empresa.getCodigo().toString() : "");
        operacao.setFilial(sessao.getFilial().getCodigo());
        operacao.setUsuario(sessao.getUsuario().getCodigo());
        operacao.setStatusProcessamento(StatusProcessamento.PROCESSAR);
        PreferenciaUsuario pu = PreferenciaUsuarioRN.getInstance().buscarPorIdUsuario(sessao, sessao.getIdUsuario());
        operacao.setPdv(Integer.valueOf(pu.getPdv()));
        operacao.setCentroLucro(sessao.getUsuario().getCentroLucro());
        operacao.setReplicacao(StatusReplicacao.OPERACAO_REPLICADA);
        operacao.setOperacaoLocal(true);
        operacao.setIntegracao(Integer.valueOf(0));
        operacao.setCnpjEmissor(Util.apenasNumeros((String)sessao.getFilial().getCnpj()));
        operacao.setCfop("5102");
        operacao.setNfce(true);
        operacao.setWeb(true);
        operacao.setTipoDocumento(3);
        operacao.setData(DataHoraFactory.getData());
        operacao.setHoraInicial(DataHoraFactory.getDataHora());
        operacao.setSequencia(Integer.valueOf(OperacaoRN.getInstance().getProximaSequencia(operacao)));
        operacao.setAtualizacao(Integer.valueOf(1));
        operacao.setLocalhost(Util.left((String)Util.getLocalHost(), (int)20));
        operacao.setUuid(UUID.randomUUID());
        if (tipoOperacao == TipoOperacao.VENDA_MANUAL) {
            operacao.setManual(true);
            operacao.setTipoDocumento(1);
        }
        Entidade vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(sessao.getUsuario().getIdEntidade());
        operacao.getItens().forEach(item -> {
            if (StringUtil.stringNullOrEmpty((String)item.getVendedor())) {
                item.setVendedor(vendedor != null ? vendedor.getCodigo() : null);
            }
        });
        operacao.setRegistraProducao(true);
        return operacao;
    }

    public void marcaInicioOperacao(Sessao sessao, Operacao op) throws UnicoMensagemUsuarioException {
        if (op.getTipo().isCupomFiscal()) {
            this.marcaInicioVendaNfce(sessao, op);
        } else {
            this.marcaInicioOutrasOperacoes(sessao, op);
        }
    }

    public void atualizarTotaisItens(Operacao operacao) {
        BigDecimal valorLiquidoItens = BigDecimal.ZERO;
        BigDecimal valorBrutoItens = BigDecimal.ZERO;
        BigDecimal descontoItem = BigDecimal.ZERO;
        BigDecimal descontoPromocao = BigDecimal.ZERO;
        BigDecimal acrescimoItem = BigDecimal.ZERO;
        BigDecimal descontoSubTotalItens = BigDecimal.ZERO;
        BigDecimal acrescimoSubTotalItens = BigDecimal.ZERO;
        BigDecimal baseIcmsEfetivo = BigDecimal.ZERO;
        BigDecimal valorIcmsEfetivo = BigDecimal.ZERO;
        BigDecimal totalFrete = BigDecimal.ZERO;
        BigDecimal totalQtdIcmsMonoRetAnterior = BigDecimal.ZERO;
        BigDecimal totalIcmsMonoRetAnterior = BigDecimal.ZERO;
        BigDecimal totalProdutos = BigDecimal.ZERO;
        BigDecimal totalServicos = BigDecimal.ZERO;
        for (Item item : operacao.getItens()) {
            item.setTotalDesconto(item.calcularTotalDescontos());
            item.setTotalAcrescimo(item.calcularTotalAcrescimo());
            valorLiquidoItens = valorLiquidoItens.add(item.getPrecoLiquido());
            valorBrutoItens = valorBrutoItens.add(item.getPrecoBruto());
            descontoItem = descontoItem.add(item.getDescontoItem());
            descontoPromocao = descontoPromocao.add(item.getDescontoPromocao());
            acrescimoItem = acrescimoItem.add(item.getAcrescimoItem());
            descontoSubTotalItens = descontoSubTotalItens.add(item.getDescontoSubtotal());
            acrescimoSubTotalItens = acrescimoSubTotalItens.add(item.getArredondamento());
            baseIcmsEfetivo = baseIcmsEfetivo.add(item.getBaseIcmsEfetivo());
            valorIcmsEfetivo = valorIcmsEfetivo.add(item.getValorIcmsEfetivo());
            totalFrete = totalFrete.add(item.getFrete());
            totalQtdIcmsMonoRetAnterior = totalQtdIcmsMonoRetAnterior.add(item.getBaseIcmsMonoRetAnterior());
            totalIcmsMonoRetAnterior = totalIcmsMonoRetAnterior.add(item.getValorIcmsMonoRetAnterior());
            if (item.getTipo() == TipoRegistroProduto.PRODUTO) {
                totalProdutos = totalProdutos.add(item.getPrecoLiquido());
                continue;
            }
            totalServicos = totalServicos.add(item.getPrecoLiquido());
        }
        operacao.setValorBruto(valorBrutoItens);
        operacao.setDescontoItem(descontoItem);
        operacao.setDescontoPromocao(descontoPromocao);
        operacao.setAcrescimoItem(acrescimoItem);
        operacao.setArredondamento(acrescimoSubTotalItens);
        operacao.setDescontoSubtotal(descontoSubTotalItens);
        operacao.setFrete(totalFrete);
        operacao.setTotalProdutos(totalProdutos);
        operacao.setTotalServicos(totalServicos);
        operacao.setBaseIcmsEfetivo(baseIcmsEfetivo);
        operacao.setValorIcmsEfetivo(valorIcmsEfetivo);
        operacao.setTotalQtdIcmsMonoRetAnterior(totalQtdIcmsMonoRetAnterior.setScale(2, RoundingMode.HALF_EVEN));
        operacao.setTotalIcmsMonoRetAnterior(totalIcmsMonoRetAnterior);
        operacao.setValorLiquido(valorLiquidoItens);
        operacao.accumulateAllIbsCbsIs(operacao.getItens());
    }

    private void marcaInicioVendaNfce(Sessao sessao, Operacao operacao) throws UnicoMensagemUsuarioException {
        Filial filial = sessao.getFilial();
        operacao.setNfce(true);
        operacao.setTipoDocumento(3);
        operacao.setData(DataHoraFactory.getData());
        operacao.setHoraInicial(DataHoraFactory.getDataHora());
        operacao.setAutorizacaoLocal(true);
        operacao.setVersaoNfce(VersaoLayoutNfe.V4);
        operacao.setTipoAmbienteNfce(filial.getParametroNfceSat().getTipoAmbienteNfce());
        operacao.setFormaEmissaoNfce(filial.getParametroNfceSat().getFormaEmissaoNfce());
        operacao.setNumeroChaveAcessoNfce(Util.string2Integer((String)Util.gerarCodigoNumericoNfe()));
        this.geraSequenciaOperacao(sessao, operacao);
    }

    private void marcaInicioOutrasOperacoes(Sessao sessao, Operacao operacao) throws UnicoMensagemUsuarioException {
        this.buscarNumeroOperacaoLocal(operacao);
        this.geraSequenciaOperacao(sessao, operacao);
    }

    private void geraSequenciaOperacao(Sessao sessao, Operacao operacao) throws UnicoMensagemUsuarioException {
        operacao.setSequencia(Integer.valueOf(OperacaoRN.getInstance().getProximaSequencia(operacao)));
        operacao.setAtualizacao(Integer.valueOf(1));
        operacao.setLocalhost(Util.left((String)Util.getLocalHost(), (int)20));
        operacao.setIdFechamento(this.getIdFechamento(sessao));
        operacao.setFechamentoLocal(true);
    }

    private void buscarNumeroOperacaoLocal(Operacao operacao) throws UnicoMensagemUsuarioException {
        int coo = NumeracaoOperacaoRN.getInstance().getProximoNumero(SessaoUtil.getSessao());
        operacao.setData(DataHoraFactory.getData());
        operacao.setHoraInicial(DataHoraFactory.getDataHora());
        operacao.setCoo(Integer.valueOf(coo));
        operacao.setAutorizacaoLocal(true);
    }

    private Long getIdFechamento(Sessao sessao) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoPdv = FechamentoPdvCommonRN.getInstance().buscarFechamentoAbertoUsuario(sessao, sessao.getIdUsuario());
        if (fechamentoPdv == null) {
            fechamentoPdv = FechamentoPdvCommonRN.getInstance().criarMovimento(sessao, sessao.getIdUsuario(), sessao.getUsuario().getPreferenciaUsuario().getPdv(), DataHoraFactory.getDataHora());
        }
        return fechamentoPdv.getId();
    }
}

