/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.TransmissorNfeLocal;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.EntidadeDesconto;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.Kit;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.VersaoLayoutNfe;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoPendencia;
import br.intelidata.commons.domain.pojo.estoque.ValidacaoSaldoEstoque;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FormacaoPrecoProdutoCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoPdvWeb;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDescontoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.regranegocio.EstoqueNegativoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.PendenciaProcessamentoRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVenda;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.InicioOperacaoWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.InicioPagamentoWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.OperacaoPrecoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.ValidarClienteWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.ValidarPrecoMinimoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.pojo.nfce.RetornoAutorizacao;
import unipaf.pojo.nfce.RetornoCancelamento;
import unipaf.processa.ProcessaOperacao;
import unipaf.servidor.ContadorAlertas;
import unipaf.servidor.RateioItem;
import unipaf.servidor.nfce.StatusPdvFilial;
import unipaf.servidor.nfce.StatusPdvFilialHelper;
import unipaf.servidor.nfce.TransmissorNfceUtil;
import unipaf.servidor.nfce.funcoes.CancelaNfce;
import unipaf.servidor.nfce.funcoes.TransmitirNfceWeb;

@RestController
@Component(value="pdv-web")
@RequestMapping(value={"/api/pdv-web"})
@SubMenuMapping(MENU="SubMenuPdvFiscal", NOME="PDV", ICONE="icon-cupom-fiscal", ROTA="/vendas/pdv-web", PROGRAMA=1000050)
public class PdvOperacaoCrudController
extends SimpleCrudController<Operacao, OperacaoRN>
implements ProdutoItemInterface<Item> {
    private final FuncionalidadeService funcionalidadeService;
    private final NotificationService notificationService;

    public PdvOperacaoCrudController(FuncionalidadeService funcionalidadeService, NotificationService notificationService) {
        super((AbstractRegraNegocio)OperacaoRN.getInstance());
        this.funcionalidadeService = funcionalidadeService;
        this.notificationService = notificationService;
    }

    public Operacao get(Long parentId) {
        return null;
    }

    public ProdutoItemWeb<Item> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) {
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        Item item = new Item();
        item.setQuantidade(BigDecimal.ONE);
        produtoItem.setItem((ItemWeb)item);
        produtoItem.setProduto(produto);
        String codigoCliente = parametros != null ? (String)parametros.getFirst((Object)"cliente") : null;
        new ProdutoPdvWeb().carrgarItem(SessaoUtil.getSessao(), codigoCliente, produtoItem);
        return produtoItem;
    }

    @RequestMapping(value={"/buscar-preco-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<Item> getPrecoProduto(@RequestBody OperacaoPrecoWrapper wrapper) {
        Promocao promocao;
        Sessao sessao = SessaoUtil.getSessao();
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getItem().getIdProduto());
        if (!NumberUtil.longNullOuZero((Long)wrapper.getItem().getIdEmbalagem()) && wrapper.getItem().getIdEmbalagem() != -1L) {
            wrapper.getItem().setUnidadeMedida(((Embalagem)EmbalagemRN.getInstance().buscarPorId(wrapper.getItem().getIdEmbalagem())).getCodigoUnidadeMedida());
        }
        ProdutoPreco produtoPreco = ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(sessao.getFilial(), wrapper.getItem().getIdProduto(), wrapper.getItem().getPauta(), VariacaoRN.getInstance().stringToMap(wrapper.getItem().getVariacoes()), wrapper.getItem().getIdEmbalagem()));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            Map map = FormacaoPrecoProdutoCommonRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), produto.getId());
            wrapper.getItem().setPrecoMinimoVenda((BigDecimal)map.get("precoMinimoVenda"));
        } else {
            wrapper.getItem().setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produtoPreco.getPrecoPromocao())) {
            wrapper.getItem().setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            wrapper.getItem().setPrecoLiquido(produtoPreco.getPrecoPromocao());
            wrapper.getItem().setPromocao(produtoPreco.getCodigoPromocao());
        } else {
            wrapper.getItem().setDescontoPromocao(BigDecimal.ZERO);
            wrapper.getItem().setPrecoLiquido(produtoPreco.getPreco());
            wrapper.getItem().setPromocao(null);
        }
        ProdutoItemWeb produtoItemWeb = new ProdutoItemWeb();
        produtoItemWeb.setProdutoPreco(produtoPreco);
        Item item = new Item();
        BeanUtil.copiarValores((Object)wrapper.getItem(), (Object)item, (boolean)false, (boolean)true, null);
        produtoItemWeb.setItem((ItemWeb)item);
        if (!NumberUtil.longNullOuZero((Long)((Item)produtoItemWeb.getItem()).getIdPromocao()) && (promocao = PromocaoRN.getInstance().buscarPorId(((Item)produtoItemWeb.getItem()).getIdPromocao())) != null) {
            produtoItemWeb.setPromocao(promocao);
        }
        return produtoItemWeb;
    }

    @RequestMapping(value={"/cancelar-nfce"})
    @DBTransaction
    public RetornoCancelamento cancelar(@RequestParam Long idOperacao, @RequestParam String justificativa, @RequestParam boolean somenteFinanceiro) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        if (somenteFinanceiro) {
            boolean temFinanceiro;
            boolean bl = temFinanceiro = EventoFinanceiroRN.getInstance().buscarPorIdOrigem(operacao.getId(), 1) != null;
            if (!temFinanceiro) {
                throw new UnicoMensagemUsuarioException("WPDV728", "Imposs\u00edvel continuar. Esta opera\u00e7\u00e3o n\u00e3o tem contas a receber para cancelar.");
            }
            OperacaoRN.getInstance().gravarCancelamentoOperacao(operacao, justificativa, SessaoUtil.getSessao());
            RetornoCancelamento retorno = new RetornoCancelamento();
            retorno.setCancelado(true);
            retorno.setMensagemRetorno("Financeiro cancelado com sucesso");
            return retorno;
        }
        if (operacao.isOperacaoLocal()) {
            throw new UnicoMensagemUsuarioException("WWW667", "N\u00e3o \u00e9 permitido realizar o cancelamento de vendas feitas no PDV local!");
        }
        TransmissorNfeLocal transmissor = TransmissorNfceUtil.get((String)operacao.getFilial(), (VersaoLayoutNfe)operacao.getVersaoNfce());
        return new CancelaNfce().cancelar(operacao, SessaoUtil.getSessao().getUsuario().getCodigo(), justificativa, transmissor);
    }

    @RequestMapping(value={"/gravar-operacao"}, method={RequestMethod.POST})
    @DBTransaction
    public RetornoAutorizacao gravarOperacao(@RequestBody Operacao operacao) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        new InicioOperacaoWeb().iniciarNovaOperacao(sessao, TipoOperacao.VENDA, operacao);
        new InicioOperacaoWeb().marcaInicioOperacao(sessao, operacao);
        if (ListMapUtil.listNullOrEmpty((List)operacao.getItens())) {
            throw new UnicoMensagemUsuarioException("WWW672", "Opera\u00e7\u00e3o n\u00e3o possui itens. Imposs\u00edvel continuar.");
        }
        if (!NumberUtil.longNullOuZero((Long)operacao.getIdCliente()) && StringUtil.stringNullOrEmpty((String)operacao.getCliente())) {
            operacao.setCliente((String)EntidadeRN.getInstance().buscarValorPorID(operacao.getIdCliente(), "codigo"));
        }
        if (!NumberUtil.longNullOuZero((Long)operacao.getIdVendedor()) && StringUtil.stringNullOrEmpty((String)operacao.getVendedor())) {
            operacao.setVendedor((String)EntidadeRN.getInstance().buscarValorPorID(operacao.getIdVendedor(), "codigo"));
        }
        operacao.getItens().forEach(it -> {
            if (!StringUtil.stringNullOrEmpty((String)operacao.getVendedor())) {
                it.setVendedor(operacao.getVendedor());
            }
            if (!NumberUtil.longNullOuZero((Long)operacao.getIdVendedor())) {
                it.setIdVendedor(operacao.getIdVendedor());
            }
        });
        operacao.setUuid(UUID.randomUUID());
        operacao.setPagamentos(new InicioPagamentoWeb().gerarParcelas(sessao, operacao.getPagamentos(), operacao));
        new RateioItem().ratear(operacao.getItens(), true, operacao.getDescontoSubtotal(), operacao.getTipo());
        new RateioItem().ratear(operacao.getItens(), false, operacao.getArredondamento(), operacao.getTipo());
        new InicioOperacaoWeb().atualizarTotaisItens(operacao);
        this.validarEstoque(sessao, operacao.getItens());
        ((OperacaoRN)this.getRegraNegocio()).incluirOperacaoCompleta(operacao, sessao);
        this.verificarValidadeCertificado(operacao.getFilial());
        RetornoAutorizacao retorno = new TransmitirNfceWeb().transmitir(operacao);
        retorno.setIdOperacao(operacao.getId());
        return retorno;
    }

    @RequestMapping(value={"/buscar-item-rapido"})
    @DBAutoCommit
    public List<ProdutoDTOWeb> buscarItensRapido() {
        List produtos = ProdutoRN.getInstance().buscarListaItemRapidoUnichef();
        ArrayList<ProdutoDTOWeb> produtosDTO = new ArrayList<ProdutoDTOWeb>();
        for (Produto p : produtos) {
            ProdutoDTOWeb produtoDTOWeb = new ProdutoDTOWeb();
            BeanUtil.copiarValores((Object)p, (Object)produtoDTOWeb, (boolean)true, null);
            if (!Util.stringNullOrEmpty((String)p.getCaminhoImagem())) {
                produtoDTOWeb.setIcon(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, TipoImagem.Icone, p.getCaminhoImagem()));
            }
            produtosDTO.add(produtoDTOWeb);
        }
        return produtosDTO;
    }

    @RequestMapping(value={"/vender-item-rapido"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<Item> venderItemRapido(@RequestBody ProdutoDTOWeb prod) {
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), prod.getId());
        return this.carregarDadosItem(produto, null);
    }

    @RequestMapping(value={"/pdv-status"})
    @DBAutoCommit
    public StatusPdvFilial bustarStatusPdv() throws UnicoMensagemUsuarioException {
        ContadorAlertas.getInstance().contarAlertas(true);
        return StatusPdvFilialHelper.getStatus((String)SessaoUtil.getSessao().getCodigoFilial());
    }

    @RequestMapping(value={"/buscar-itens-kit"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<Item> buscarItensKit(@RequestBody Item item) throws UnicoMensagemUsuarioException {
        Produto produto = ProdutoRN.getInstance().buscarProduto(item.getProduto(), SessaoUtil.getSessao());
        List itensKit = KitRN.getInstance().buscarListaPorIdProdutoKit(SessaoUtil.getSessao(), produto.getId());
        if (!ListMapUtil.listNullOrEmpty((List)itensKit)) {
            Map<Long, BigDecimal> itensMap = itensKit.stream().collect(Collectors.toMap(Kit::getIdproduto, Kit::getQuantidade));
            ArrayList<ProdutoItemWeb> itensKitFinal = new ArrayList<ProdutoItemWeb>();
            for (Map.Entry<Long, BigDecimal> entryItemKit : itensMap.entrySet()) {
                ProdutoDTOWeb produtoDTOWeb = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), entryItemKit.getKey());
                ProdutoItemWeb produtoItem = this.carregarDadosItem(produtoDTOWeb, null);
                ((Item)produtoItem.getItem()).setQuantidade(item.getQuantidade().multiply(entryItemKit.getValue()));
                if (produtoItem.getProdutoPreco() != null && Util.bigDecimalNullOrZero((BigDecimal)((Item)produtoItem.getItem()).getPrecoUnitario())) {
                    ((Item)produtoItem.getItem()).setPrecoUnitario(produtoItem.getProdutoPreco().getPreco());
                }
                ((Item)produtoItem.getItem()).setKit(TipoKit.KIT_COMPONENTE);
                itensKitFinal.add(produtoItem);
            }
            List<Item> itensParaRateio = itensKitFinal.stream().map(ProdutoItemWeb::getItem).collect(Collectors.toList());
            GeradorKitVenda geradorKitVenda = new GeradorKitVenda();
            geradorKitVenda.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)item, itensParaRateio, null);
            for (Item itemRateio : itensParaRateio) {
                itemRateio.setPrecoBruto(itemRateio.getPrecoUnitario().multiply(itemRateio.getQuantidade()).setScale(2, RoundingMode.HALF_DOWN));
                itemRateio.setPrecoLiquido(itemRateio.getPrecoBruto().subtract(itemRateio.getDescontoItem()).setScale(2, RoundingMode.HALF_DOWN));
            }
            return itensParaRateio;
        }
        return null;
    }

    @RequestMapping(value={"/validar-cliente"})
    @DBAutoCommit
    public ValidarClienteWrapper validarCliente(@RequestParam Long idEntidade, @RequestParam List<Long> idsProdutos) throws UnicoMensagemUsuarioException {
        ValidarClienteWrapper wrapper = new ValidarClienteWrapper();
        Sessao sessao = SessaoUtil.getSessao();
        if (EntidadeRN.getInstance().isEntidadeBloqueadaPorAtrasoPDV(sessao, idEntidade)) {
            wrapper.setMensagem((String)PropriedadeRN.getInstance().getPropriedade(sessao.getFilial(), 307));
            if (Util.stringNullOrEmpty((String)wrapper.getMensagem())) {
                wrapper.setMensagem("Cliente em atraso");
            }
        }
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 194)) {
            for (Long idProduto : idsProdutos) {
                EntidadeDesconto entidadeDesconto = EntidadeDescontoRN.getInstance().buscaDescontoProduto(idEntidade, idProduto);
                if (entidadeDesconto == null) continue;
                wrapper.addDescontos(entidadeDesconto);
            }
        }
        return wrapper;
    }

    @RequestMapping(value={"/processa-operacao"})
    @DBTransaction
    public void processaOperacao(@RequestParam Long idOperacao) throws UnicoMensagemUsuarioException {
        Operacao operacao = OperacaoRN.getInstance().buscarOperacaoCompletaPorId(idOperacao);
        try {
            new ProcessaOperacao().processa(operacao, false);
        }
        catch (Throwable e) {
            PendenciaProcessamentoRN.getInstance().incluirPendencia(idOperacao, TipoPendencia.PROCESSAMENTO, e);
        }
    }

    private void validarEstoque(Sessao sessao, List<Item> itens) throws UnicoMensagemUsuarioException {
        StringBuilder sb = new StringBuilder();
        ValidacaoSaldoEstoque validacao = new ValidacaoSaldoEstoque(75, itens);
        int indexItem = -1;
        for (Item item : itens) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorCodigo(item.getProduto());
            validacao.setDadosOperacao(null, sessao.getIdFilial(), sessao.getUsuario().getIdLocalEstoqueTrabalho(), ++indexItem, produto.getId(), produto.getIdUnidadeMedida(), item.getIdEmbalagem(), item.getTipoKit(), item.getQuantidade(), null, item.getVariacoes());
            try {
                HashMap mapCfopBaixaEstoque = new HashMap();
                HashMap mapPossuiFichaTecnica = new HashMap();
                EstoqueNegativoRN.getInstance().validaEstoque(sessao, validacao, mapCfopBaixaEstoque, mapPossuiFichaTecnica);
            }
            catch (UnicoMensagemUsuarioException ux) {
                sb.append(ux.getDetalhe()).append(";");
            }
        }
        if (!StringUtil.stringNullOrEmpty((String)sb.toString())) {
            throw new UnicoMensagemUsuarioException("WWW735", sb.substring(0, sb.toString().length() - 1));
        }
    }

    private void verificarValidadeCertificado(String filial) {
        String mensagemCertificado;
        try {
            mensagemCertificado = TransmissorNfceUtil.get((String)filial).getValidadeCertificado();
        }
        catch (UnicoMensagemUsuarioException e) {
            mensagemCertificado = e.getMensagemSemCodigo();
        }
        if (!StringUtil.stringNullOrEmpty((String)mensagemCertificado)) {
            this.notificationService.notifyUser(SessaoUtil.getSessao().getIdUsuario(), mensagemCertificado, TipoNotificacaoSimples.WARNING, NotificationType.NOTIFICATION);
        }
    }

    @PostMapping(value={"/validar-preco-produto"})
    @DBAutoCommit
    public Map<String, Object> validarPrecoProduto(@RequestBody List<ValidarPrecoMinimoWrapper> listaWrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ValidarPrecoMinimoWrapper> itensInvalidos = new ArrayList<ValidarPrecoMinimoWrapper>();
        for (ValidarPrecoMinimoWrapper itemValidacao : listaWrapper) {
            BigDecimal precoMinimo;
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(itemValidacao.getIdProduto());
            itemValidacao.setCodigoProduto(produto.getCodigo());
            itemValidacao.setNomeProduto(produto.getNome());
            ProdutoRN.getInstance().validarPrecoAbaixoCusto(sessao, produto, itemValidacao.getPrecoUnitario(), itemValidacao.getIdEmbalagem());
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                Map map = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), produto.getId());
                precoMinimo = (BigDecimal)map.get("precoMinimoVenda");
            } else {
                precoMinimo = produto.getPrecoMinimoVenda();
            }
            itemValidacao.setPrecoMinimo(precoMinimo);
            if (ProdutoRN.getInstance().isPrecoMinimoValido(sessao.getFilial().getId(), sessao.getUsuario(), itemValidacao.getPrecoUnitario(), precoMinimo, Long.valueOf(0L), itemValidacao.getIdPromocao(), Long.valueOf(0L), false, itemValidacao.getValorDesconto(), itemValidacao.getQuantidade())) continue;
            itensInvalidos.add(itemValidacao);
        }
        String mensagemRetorno = "";
        if (!itensInvalidos.isEmpty()) {
            mensagemRetorno = itensInvalidos.size() > 1 ? "Existem produtos com o pre\u00e7o menor que o pre\u00e7o m\u00ednimo de venda permitido. Deseja realmente aplicar este pre\u00e7o?<br>" + itensInvalidos.stream().map(i -> i.getCodigoProduto() + " - " + i.getNomeProduto() + " - pre\u00e7o minimo: R$" + i.getPrecoMinimo()).collect(Collectors.joining("<br>")) : "O pre\u00e7o do produto [" + ((ValidarPrecoMinimoWrapper)itensInvalidos.get(0)).getNomeProduto() + "] \u00e9 menor que o pre\u00e7o m\u00ednimo de venda permitido [R$ " + ((ValidarPrecoMinimoWrapper)itensInvalidos.get(0)).getPrecoMinimo() + "]. Deseja realmente aplicar este pre\u00e7o?";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mensagem", mensagemRetorno);
        map.put("itens", itensInvalidos);
        return map;
    }
}

