/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.cancelamentos;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.EnumJoin;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.enuns.pafecf.CancelamentoOperacaoStatus;
import br.intelidata.commons.domain.pojo.notafiscal.PendenciaNfe;
import br.intelidata.commons.domain.pojo.pafecf.CancelamentoOperacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.PendenciaNfeRN;
import br.intelidata.commons.modulo.pdv.regranegocio.CancelamentoOperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoNfceRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.cancelamentos.ExclusaoWrapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cancelamentos"})
public class CancelamentosCrudController
extends CrudController<PendenciaNfe, PendenciaNfeRN> {
    public CancelamentosCrudController() {
        super((AbstractRegraNegocio)PendenciaNfeRN.getInstance(), PendenciaNfe::new, true, true);
    }

    protected String getCacheId() {
        return "cancelamentos";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("id", "idobjeto_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("filial", "filial_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("serienfce", "serie_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce", "fk_cancelamento_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "numero_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce", "fk_cancelamento_operacao"}));
        colunas.add(new ColunaSQL("datahora", "datahora_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("status", "status_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("chaveacessonfce", "chaveacessonfce", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce", "fk_cancelamento_operacao"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "qtdtransmissao_"));
        colunas.add(new ColunaSQL("ultimatransmissao", "ultimatransmissao_"));
        colunas.add(new ColunaSQL("codigorejeicao", "codigorejeicao_"));
        colunas.add(new ColunaSQL("serienfce", "serie_cancelamento", "S\u00e9rie", 50, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce", "fk_cancelamento_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "numero_cancelamento", "N\u00famero", 90, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce", "fk_cancelamento_operacao"}));
        colunas.add(new ColunaSQL("horafinal", "emissao_cancelamento", "Emiss\u00e3o", 150, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce", "fk_cancelamento_operacao"}));
        colunas.add(new ColunaSQL("datahora", "datahora_cancelamento", "Data Canc.", 150, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "Qtd. Transmiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("ultimatransmissao", "Ult. Transmiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("prazocancelamento", "prazo_cancelamento", "Prazo", 130, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("justificativa", "justificativa_cancelamento", "Hist\u00f3rico", 400, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("statusretorno", "stretorno_cancelamento", "Status Retorno", 100, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("mensagemretorno", "msgretorno_cancelamento", "Mensagem Retorno", 400, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        colunas.add(new ColunaSQL("codigoerro", "C\u00f3digo do erro", 150, true));
        colunas.add(new ColunaSQL("mensagemexcecao", "Mensagem erro interno", 450, true));
        colunas.add(new ColunaSQL("tipoambiente", "tipoambiente_cancelamento", "Ambiente", 130, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_cancnfce"}));
        GridBuilder controler = new GridBuilder(((PendenciaNfeRN)this.rn).getTabela(), colunas, "pendenciacancelamentonfce_v3");
        controler.addCodicaoDefault(new Condicao("status_", Operador.CONTIDO_EM, new Integer[]{CancelamentoOperacaoStatus.ERRO.getId(), CancelamentoOperacaoStatus.PENDENTE.getId(), CancelamentoOperacaoStatus.REJEITADO.getId()}));
        controler.addCodicaoDefault(new Condicao("filial_", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.E));
        controler.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IGUAL, 0));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IS_NULL));
        controler.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        controler.addOrdem(new Ordem("datahora_"));
        controler.addOrdem(new Ordem("serie_"));
        controler.addOrdem(new Ordem("numero_"));
        return controler;
    }

    @RequestMapping(value={"/buscar-operacao"})
    @DBAutoCommit
    public Long buscarOperacaoPorInutilizacao(@RequestParam Long idCancelamento) {
        CancelamentoOperacao cancelamento = (CancelamentoOperacao)CancelamentoOperacaoRN.getInstance().buscarPorId(idCancelamento);
        Operacao nfce = (Operacao)OperacaoNfceRN.getInstance().buscarPorId(cancelamento.getIdOperacao());
        if (nfce != null && !Util.longNullOuZero((Long)nfce.getIdNfceSubstituta())) {
            return nfce.getIdNfceSubstituta();
        }
        return nfce != null ? nfce.getId() : null;
    }

    @RequestMapping(value={"/exclusao"}, method={RequestMethod.POST})
    @DBTransaction
    public void excluir(@RequestBody List<ExclusaoWrapper> exclusaoWrapper) throws UnicoMensagemUsuarioException {
        Sessao s = SessaoUtil.getSessao();
        for (ExclusaoWrapper exclusao : exclusaoWrapper) {
            CancelamentoOperacao cancelamento = (CancelamentoOperacao)CancelamentoOperacaoRN.getInstance().buscarPorId(exclusao.getIdCancelamento());
            PendenciaNfe pendencia = (PendenciaNfe)PendenciaNfeRN.getInstance().buscarPorId(exclusao.getIdPendencia());
            if (pendencia != null) {
                PendenciaNfeRN.getInstance().excluir((AbstractPojo)pendencia, s);
            }
            if (cancelamento == null) continue;
            PendenciaNfeRN.getInstance().excluirPendencias(cancelamento, s);
            CancelamentoOperacaoRN.getInstance().excluir((AbstractPojo)cancelamento, s);
        }
    }
}

