/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.contigencias;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.EnumJoin;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Serie;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.notafiscal.PendenciaNfe;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.PendenciaNfeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SerieRN;
import br.intelidata.commons.modulo.pdv.patches.CorrigiNfceEmDuplicidade;
import br.intelidata.commons.modulo.pdv.patches.ReconstroiXmlNfce;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.relatorio.RejeicoesNfceRelatorio;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contigencia-nfce"})
public class ContigenciaCrudController
extends CrudController<PendenciaNfe, PendenciaNfeRN> {
    protected ResponseEntityService responseService;

    public ContigenciaCrudController(ResponseEntityService responseService) {
        super((AbstractRegraNegocio)PendenciaNfeRN.getInstance(), PendenciaNfe::new, true, true);
        this.responseService = responseService;
    }

    protected String getCacheId() {
        return "contigencia-nfce";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("id", "idobjeto_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("filial", "filial_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("statusnfce", "status_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("serienfce", "serie_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "numero_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("horafinal", "horafinal_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("chaveacessonfce", "chaveacessonfce", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "qtdtransmissao_"));
        colunas.add(new ColunaSQL("ultimatransmissao", "ultimatransmissao_"));
        colunas.add(new ColunaSQL("codigorejeicao", "codigorejeicao_"));
        colunas.add(new ColunaSQL("serienfce", "operacao_serienfce", "S\u00e9rie", 50, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "operacao_numeronfce", "N\u00famero", 90, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("horafinal", "operacao_horafinal", "Emiss\u00e3o", 150, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("statusnfce", "operacao_statusnfce", "Status", 200, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "Qtd. Transmiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("ultimatransmissao", "Ult. Transmiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("statusretornonfce", "operacao_stretorno", "Status Retorno", 100, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("mensagemretornonfce", "operacao_msgretorno", "Mensagem Retorno", 200, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("statusprotocolonfce", "operacao_stprotocolo", "Status Protocolo", 100, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("mensagemprotocolonfce", "operacao_msgprotocolo", "Mensagem Protocolo", 400, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("codigoerro", "C\u00f3digo do erro", 150, true));
        colunas.add(new ColunaSQL("mensagemexcecao", "Mensagem erro interno", 400, true));
        colunas.add(new ColunaSQL("tipoambientenfce", "operacao_tipoambientenfce", "Ambiente", 150, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        GridBuilder controler = new GridBuilder(((PendenciaNfeRN)this.rn).getTabela(), colunas, "pendencianfce_v2");
        controler.addCodicaoDefault(new Condicao("status_", Operador.CONTIDO_EM, new Integer[]{StatusNfce.EMITIDA_EM_CONTIGENCIA.getId(), StatusNfce.CONTIGENCIA_REJEITADA.getId()}));
        controler.addCodicaoDefault(new Condicao("filial_", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.E));
        controler.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IGUAL, 0));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IS_NULL));
        controler.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        controler.addOrdem(new Ordem("horafinal_"));
        controler.addOrdem(new Ordem("serie_"));
        controler.addOrdem(new Ordem("horafinal_"));
        return controler;
    }

    @RequestMapping(value={"/imprimir-rejeicoes"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirRejeicoes() throws UnicoMensagemUsuarioException {
        Remessa remessa = new RejeicoesNfceRelatorio().getRelatorio();
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"Rejei\u00e7\u00f5es");
    }

    @RequestMapping(value={"/validar-xml"})
    @DBAutoCommit
    public String validarXml(@RequestParam Long idOperacao) {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        return new String(operacao.getXmlNfceAutorizado(), StandardCharsets.UTF_8);
    }

    @RequestMapping(value={"/corrigir-data-emissao"})
    @DBTransaction
    public void corrigirRejeicaoDataEmissao(@RequestParam String data, @RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        LocalDateTime dataHora = DataHoraFactory.string2LocalDateTime((String)data, (String)"dd/MM/yyyy HH:mm:ss");
        ArrayList<Operacao> operacoesParaAlterar = new ArrayList<Operacao>(ids.size());
        for (Long operacaoId : ids) {
            Operacao operacao = OperacaoRN.getInstance().buscarOperacaoCompletaPorId(operacaoId);
            operacao.setHoraInicial(dataHora);
            operacao.setHoraFinal(dataHora);
            operacoesParaAlterar.add(operacao);
        }
        OperacaoRN.getInstance().gravarLista(1, operacoesParaAlterar, SessaoUtil.getSessao());
        ReconstroiXmlNfce recontroiXml = new ReconstroiXmlNfce();
        for (Long id : ids) {
            recontroiXml.recontruir(id);
        }
    }

    @RequestMapping(value={"/corrigir-duplicidade"})
    @DBAutoCommit
    public void corrigirContigenciaEmDuplicidade(@RequestParam Long idSerie) throws UnicoMensagemUsuarioException {
        Serie serie = (Serie)SerieRN.getInstance().buscarPorId(idSerie);
        new CorrigiNfceEmDuplicidade().corrigirContigencias(serie.getModelo());
        this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.SUCCESS, "Opera\u00e7\u00e3o conclu\u00edda");
    }

    @RequestMapping(value={"/corrigir-destinatario"}, method={RequestMethod.POST})
    @DBTransaction
    public void corrigirRejeicaoDestinatario(@RequestBody Operacao operacao) throws UnicoMensagemUsuarioException {
        OperacaoRN.getInstance().alterar(operacao, SessaoUtil.getSessao());
        new ReconstroiXmlNfce().recontruir(operacao.getId());
    }
}

