/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.problemasautorizacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sql.EnumJoin;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.notafiscal.PendenciaNfe;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.PendenciaNfeRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/problemas-autorizacao"})
public class ProblemasAutorizacaoCrudController
extends CrudController<PendenciaNfe, PendenciaNfeRN> {
    public ProblemasAutorizacaoCrudController() {
        super((AbstractRegraNegocio)PendenciaNfeRN.getInstance(), PendenciaNfe::new, true, true);
    }

    protected String getCacheId() {
        return "problemas-autorizacao";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("id", "idobjeto_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("filial", "filial_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("statusnfce", "status_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("serienfce", "serie_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "numero_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("horafinal", "horafinal_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("chaveacessonfce", "chaveacessonfce", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "qtdtransmissao_"));
        colunas.add(new ColunaSQL("ultimatransmissao", "ultimatransmissao_"));
        colunas.add(new ColunaSQL("codigorejeicao", "codigorejeicao_"));
        colunas.add(new ColunaSQL("serienfce", "operacao_serienfce", "S\u00e9rie", 50, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "operacao_numeronfce", "N\u00famero", 90, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("horafinal", "operacao_horafinal", "Emiss\u00e3o", 150, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("statusnfce", "operacao_statusnfce", "Status", 200, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "Qtd. Transmiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("ultimatransmissao", "Ult. Transmiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("statusretornonfce", "operacao_stretorno", "Status Retorno", 100, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("mensagemretornonfce", "operacao_msgretorno", "Mensagem Retorno", 200, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("statusprotocolonfce", "operacao_stprotocolo", "Status Protocolo", 100, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("mensagemprotocolonfce", "operacao_msgprotocolo", "Mensagem Protocolo", 400, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        colunas.add(new ColunaSQL("codigoerro", "C\u00f3digo do erro", 150, true));
        colunas.add(new ColunaSQL("mensagemexcecao", "Mensagem erro interno", 400, true));
        colunas.add(new ColunaSQL("tipoambientenfce", "operacao_tipoambientenfce", "Ambiente", 130, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_operacao"}));
        GridBuilder controler = new GridBuilder(((PendenciaNfeRN)this.rn).getTabela(), colunas, "pendencianfce_v3");
        controler.addCodicaoDefault(new Condicao("status_", Operador.CONTIDO_EM, new Integer[]{StatusNfce.PROBLEMAS_NA_AUTORIZACAO.getId(), StatusNfce.PROBLEMAS_NA_CONSULTA.getId()}));
        controler.addCodicaoDefault(new Condicao("filial_", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.E));
        controler.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IGUAL, 0));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IS_NULL));
        controler.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        controler.addOrdem(new Ordem("horafinal_"));
        controler.addOrdem(new Ordem("serie_"));
        controler.addOrdem(new Ordem("horafinal_"));
        return controler;
    }
}

