/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumPrecificado;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.Precificacao;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.ModoCalculoPreco;
import br.intelidata.commons.domain.pojo.enuns.OrigemCusto;
import br.intelidata.commons.domain.pojo.enuns.StatusPrecoCompra;
import br.intelidata.commons.domain.pojo.enuns.TipoComandoPrecificacao;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoReplicacaoFormacaoPreco;
import br.intelidata.commons.domain.pojo.enuns.TipoReplicacaoPrecoCusto;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.NotaFiscalItemCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoValorProduto;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.estoque.regranegocio.MovimentoEstoqueRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.preco.enums.TipoFiltroPrecificacao;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.preco.regranegocio.PrecificacaoRN;
import br.intelidata.commons.modulo.preco.regranegocio.PrecificadoRN;
import br.intelidata.commons.modulo.preco.relatorio.PrecificacaoRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.service.FormacaoPrecoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.client.report.DummyReport;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacao.ArredondarPrecificacaoRequest;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacao.ComandosPrecificacaoRequest;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacao.PrecificacaoRequest;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacao.PrecificarRequest;
import com.lowagie.text.Font;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/precificacoes"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Precifica\u00e7\u00e3o", ICONE="icon-calculaprecovenda", ROTA="/estoques/precificacoes", PROGRAMA=1401)
public class PrecificacaoCrudController
extends SimpleCrudController<Precificacao, PrecificacaoRN> {
    private final FormacaoPrecoService formacaoPrecoService;
    private final FuncionalidadeService funcionalidadeService;
    private final ResponseEntityService responseEntityService;
    private final NotificationService notificationService;

    public PrecificacaoCrudController(FormacaoPrecoService formacaoPrecoService, FuncionalidadeService funcionalidadeService, ResponseEntityService responseEntityService, NotificationService notificationService) {
        this.formacaoPrecoService = formacaoPrecoService;
        this.funcionalidadeService = funcionalidadeService;
        this.responseEntityService = responseEntityService;
        this.notificationService = notificationService;
    }

    @PostMapping(value={"/buscar-dados"})
    @DBAutoCommit
    public List<Precificacao> buscarDados(@RequestBody PrecificacaoRequest precificacaoRequest) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        this.verificarModoCalculoPreco(sessao);
        if (TipoFiltroPrecificacao.PRECIFICADOS.equals((Object)precificacaoRequest.getTipo())) {
            return PrecificadoRN.getInstance().buscarItensPrecificadosWeb(sessao, precificacaoRequest.getDataInicial(), precificacaoRequest.getDataFinal(), precificacaoRequest.getIdsFiliais());
        }
        List precificacoes = PrecificacaoRN.getInstance().buscarPrecificacaoWeb(sessao, precificacaoRequest.getIds(), precificacaoRequest.getIdsFiliais(), precificacaoRequest.getTipo(), precificacaoRequest.getIdProduto(), precificacaoRequest.getNomeProduto(), precificacaoRequest.getIdFornecedor(), precificacaoRequest.getIdGrupo(), precificacaoRequest.getIdFamilia());
        precificacoes.sort(new /* Unavailable Anonymous Inner Class!! */);
        precificacoes.forEach(precificacao -> precificacao.getFormacaoPreco().setPrecoVendaAjustadoOriginal(precificacao.getFormacaoPreco().getPrecoVendaAjustado()));
        return precificacoes;
    }

    @PostMapping(value={"/imprimir"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody DummyReport report, @RequestParam TipoFiltroPrecificacao tipo, @RequestParam String inicio, @RequestParam String fim, @RequestParam List<Long> ids, @RequestParam List<Long> idsFiliais, @RequestParam Long idProduto, @RequestParam Long idFornecedor, @RequestParam Long idGrupo, @RequestParam Long idFamilia) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        LocalDateTime dataInicial = DataHoraFactory.string2LocalDateTime((String)inicio, (String)"yyyy-MM-dd HH:mm:ss");
        LocalDateTime dataFinal = DataHoraFactory.string2LocalDateTime((String)fim, (String)"yyyy-MM-dd HH:mm:ss");
        PrecificacaoRequest request = new PrecificacaoRequest();
        request.setTipo(tipo);
        request.setDataInicial(dataInicial);
        request.setDataFinal(dataFinal);
        request.setIds(ids);
        request.setIdsFiliais(idsFiliais);
        request.setIdProduto(idProduto);
        request.setIdGrupo(idGrupo);
        request.setIdFamilia(idFamilia);
        request.setIdFornecedor(idFornecedor);
        int[] colunas = new int[]{};
        String titulo = "";
        if (request.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) {
            colunas = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
            titulo = "Precifica\u00e7\u00e3o - Nota Fiscal";
        } else if (request.getTipo().equals((Object)TipoFiltroPrecificacao.PRECIFICADOS)) {
            colunas = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
            titulo = "Precifica\u00e7\u00e3o - Itens precificados";
        } else if (request.getTipo().equals((Object)TipoFiltroPrecificacao.PRODUTOS)) {
            colunas = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
            titulo = "Precifica\u00e7\u00e3o - Produtos";
        }
        UViewer uViewer = new UViewer(true, titulo, report.getSaida().getSaida(), report.getSaida().getDelimitador(), report.getSaida().isImprimirPaisagem(), report.getSaida().getExtensao(), colunas);
        uViewer.setFonte(new Font(1, 6.0f, 0));
        uViewer.inicioRelatorio();
        uViewer.setZebrado(true);
        boolean exibirPauta1 = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 6);
        boolean exibirPauta2 = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 9);
        boolean exibirPauta3 = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 12);
        boolean exibirPauta4 = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 15);
        uViewer.inicioTitulo();
        if (request.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) {
            uViewer.escreveTitulo("Produto", false);
            uViewer.escreveTitulo("EAN", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            uViewer.escreveTitulo("Unid", false);
            uViewer.escreveTitulo("Qtd. entrada", true);
            uViewer.escreveTitulo("Estoque", true);
            uViewer.escreveTitulo("Pre\u00e7o compra", true);
            uViewer.escreveTitulo("Custo", true);
            uViewer.escreveTitulo("C. aquisi\u00e7\u00e3o", true);
            uViewer.escreveTitulo("Pre\u00e7o", true);
            uViewer.escreveTitulo("PE", true);
            uViewer.escreveTitulo("%Lucro", true);
            uViewer.escreveTitulo("N\u00famero NF", false);
            uViewer.escreveTitulo("Entrada NF", false);
        } else if (request.getTipo().equals((Object)TipoFiltroPrecificacao.PRECIFICADOS)) {
            uViewer.escreveTitulo("Filial", false);
            uViewer.escreveTitulo("Nome filial", false);
            uViewer.escreveTitulo("Produto", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            uViewer.escreveTitulo("Unid", false);
            uViewer.escreveTitulo("Estoque", true);
            uViewer.escreveTitulo("Pre\u00e7o compra", true);
            uViewer.escreveTitulo("Custo anterior", true);
            uViewer.escreveTitulo("Custo", true);
            uViewer.escreveTitulo("Pre\u00e7o anterior", true);
            uViewer.escreveTitulo("Pre\u00e7o", true);
            uViewer.escreveTitulo("PE", true);
            uViewer.escreveTitulo("%Lucro desejado", true);
            uViewer.escreveTitulo("%Lucro obtido", true);
            uViewer.escreveTitulo("Data da precifica\u00e7\u00e3o", false);
        } else if (request.getTipo().equals((Object)TipoFiltroPrecificacao.PRODUTOS)) {
            uViewer.escreveTitulo("Precificado", false);
            uViewer.escreveTitulo("Produto", false);
            uViewer.escreveTitulo("EAN", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            uViewer.escreveTitulo("Unid", false);
            uViewer.escreveTitulo("Estoque", true);
            uViewer.escreveTitulo("Pre\u00e7o compra", true);
            uViewer.escreveTitulo("Custo", true);
            uViewer.escreveTitulo("C. aquisi\u00e7\u00e3o", true);
            uViewer.escreveTitulo("Pre\u00e7o", true);
            uViewer.escreveTitulo("PE", true);
            uViewer.escreveTitulo("%Lucro", true);
            uViewer.escreveTitulo("Ult. precifica\u00e7\u00e3o", false);
        }
        if (request.getTipo().in(new AbstractEnum[]{TipoFiltroPrecificacao.PRODUTOS, TipoFiltroPrecificacao.ITENS_NOTAFISCAL})) {
            String str;
            if (exibirPauta1) {
                str = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 7);
                uViewer.escreveTitulo(Util.stringNullOrEmpty((String)str) ? "Pauta 1" : str, true);
            }
            if (exibirPauta2) {
                str = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 10);
                uViewer.escreveTitulo(Util.stringNullOrEmpty((String)str) ? "Pauta 2" : str, true);
            }
            if (exibirPauta3) {
                str = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 13);
                uViewer.escreveTitulo(Util.stringNullOrEmpty((String)str) ? "Pauta 3" : str, true);
            }
            if (exibirPauta4) {
                str = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 16);
                uViewer.escreveTitulo(Util.stringNullOrEmpty((String)str) ? "Pauta 4" : str, true);
            }
        }
        uViewer.fimTitulo();
        List precificacoes = this.buscarDados(request);
        for (Precificacao precificacao : precificacoes) {
            uViewer.inicioLinha();
            if (request.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) {
                uViewer.escreveColuna(precificacao.getCodigoProduto());
                uViewer.escreveColuna(precificacao.getEan());
                uViewer.escreveColuna(precificacao.getDescricaoProduto());
                uViewer.escreveColuna(precificacao.getUnidade());
                uViewer.escreveColuna(precificacao.getQuantidadeItesNota());
                uViewer.escreveColuna(precificacao.getSaldoEstoque());
                uViewer.escreveColuna(precificacao.getPrecoCompra());
                uViewer.escreveColuna(precificacao.getCustoNovo());
                uViewer.escreveColuna(precificacao.getCustoAquisicao());
                uViewer.escreveColuna(precificacao.getPrecoNovo());
                uViewer.escreveColuna(precificacao.getPontoEquilibrio());
                uViewer.escreveColuna(precificacao.getLucroObtidoPercentual());
                uViewer.escreveColuna(precificacao.getNumeroNotaFiscal());
                uViewer.escreveColuna(precificacao.getEmissao());
            } else if (request.getTipo().equals((Object)TipoFiltroPrecificacao.PRECIFICADOS)) {
                uViewer.escreveColuna(precificacao.getCodigoFilial());
                uViewer.escreveColuna(precificacao.getNomeFilial());
                uViewer.escreveColuna(precificacao.getCodigoProduto());
                uViewer.escreveColuna(precificacao.getDescricaoProduto());
                uViewer.escreveColuna(precificacao.getUnidade());
                uViewer.escreveColuna(precificacao.getSaldoEstoque());
                uViewer.escreveColuna(precificacao.getPrecoCompra());
                uViewer.escreveColuna(precificacao.getCustoAtual());
                uViewer.escreveColuna(precificacao.getCustoNovo());
                uViewer.escreveColuna(precificacao.getPrecoAtual());
                uViewer.escreveColuna(precificacao.getPrecoNovo());
                uViewer.escreveColuna(precificacao.getPontoEquilibrio());
                uViewer.escreveColuna(precificacao.getLucroDesejadoPercentual());
                uViewer.escreveColuna(precificacao.getLucroObtidoPercentual());
                uViewer.escreveColuna(precificacao.getDataHora());
            } else if (request.getTipo().equals((Object)TipoFiltroPrecificacao.PRODUTOS)) {
                uViewer.escreveColuna(precificacao.getPrecificado() != null && precificacao.getPrecificado() == 1 ? "Sim" : "N\u00e3o");
                uViewer.escreveColuna(precificacao.getCodigoProduto());
                uViewer.escreveColuna(precificacao.getEan());
                uViewer.escreveColuna(precificacao.getDescricaoProduto());
                uViewer.escreveColuna(precificacao.getUnidade());
                uViewer.escreveColuna(precificacao.getSaldoEstoque());
                uViewer.escreveColuna(precificacao.getPrecoCompra());
                uViewer.escreveColuna(precificacao.getCustoNovo());
                uViewer.escreveColuna(precificacao.getCustoAquisicao());
                uViewer.escreveColuna(precificacao.getPrecoNovo());
                uViewer.escreveColuna(precificacao.getPontoEquilibrio());
                uViewer.escreveColuna(precificacao.getLucroObtidoPercentual());
                uViewer.escreveColuna(precificacao.getDataUltimaPrecificacao());
            }
            if (request.getTipo().in(new AbstractEnum[]{TipoFiltroPrecificacao.PRODUTOS, TipoFiltroPrecificacao.ITENS_NOTAFISCAL})) {
                if (exibirPauta1) {
                    uViewer.escreveColuna(precificacao.getPrecoPauta1());
                }
                if (exibirPauta2) {
                    uViewer.escreveColuna(precificacao.getPrecoPauta2());
                }
                if (exibirPauta3) {
                    uViewer.escreveColuna(precificacao.getPrecoPauta3());
                }
                if (exibirPauta4) {
                    uViewer.escreveColuna(precificacao.getPrecoPauta4());
                }
            }
            uViewer.fimLinha();
        }
        uViewer.fimRelatorio();
        return RelatorioUtil.visualizar((Remessa)uViewer.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)report.getSaidaRelatorio(), (String)"precificacao");
    }

    @PostMapping(value={"/validar-precificacao"})
    @DBAutoCommit
    public List<Precificacao> validarPrecificacao(@RequestBody PrecificarRequest precificarRequest) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Precificacao precificacao = precificarRequest.getPrecificacoes().stream().filter(p -> precificarRequest.getIdPrecificacao().equals(p.getId())).findFirst().orElse(null);
        if (precificacao != null) {
            boolean isAlterouCusto;
            FormacaoPreco formacaoPreco = precificacao.getFormacaoPreco();
            this.formacaoPrecoService.validarFormacaoPreco(formacaoPreco);
            if (formacaoPreco.isAplicarPrecoCalculado()) {
                FormacaoPrecoRN.getInstance().aplicaPrecoCalculado(formacaoPreco);
            }
            if (isAlterouCusto = FormacaoPrecoRN.getInstance().isCustoAlterado(formacaoPreco, sessao.getFilial())) {
                formacaoPreco.setOrigemCusto(OrigemCusto.USUARIO);
                String usuario = sessao.getUsuario().getCodigo() + " - " + sessao.getUsuario().getNome();
                formacaoPreco.setCustoAlteradoPor(usuario);
            }
            if (formacaoPreco.getTipoReplicacaoPrecoProduto().equals((Object)TipoReplicacaoFormacaoPreco.NENHUM)) {
                formacaoPreco.setReplicarCusto(this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL));
            }
            formacaoPreco.setPrecificado(true);
            formacaoPreco.setPrecoAlterado(true);
            formacaoPreco.setMillisAlteracaoPreco(DataHoraFactory.getCurrentTimeMillisServidor((boolean)false).longValue());
            List formacoesPrecos = precificarRequest.getPrecificacoes().stream().map(Precificacao::getFormacaoPreco).collect(Collectors.toList());
            Long idProduto = null;
            Long idFamilia = null;
            Long idGrupo = null;
            Long idFornecedor = null;
            ArrayList<Long> idsProdutosAlterados = new ArrayList<Long>();
            if (TipoReplicacaoFormacaoPreco.FAMILIA.equals((Object)formacaoPreco.getTipoReplicacaoPrecoProduto())) {
                List replicarComposicaoPrecoParaFamilia = FormacaoPrecoRN.getInstance().replicarComposicaoPrecoParaFamilia(sessao, precificacao.getIdFilial(), formacaoPreco, formacoesPrecos);
                idsProdutosAlterados.addAll(replicarComposicaoPrecoParaFamilia);
                idFamilia = formacaoPreco.getProduto().getIdFamilia();
            }
            if (TipoReplicacaoFormacaoPreco.GRUPO.equals((Object)formacaoPreco.getTipoReplicacaoPrecoProduto())) {
                List replicarComposicaoPrecoParaGrupo = FormacaoPrecoRN.getInstance().replicarComposicaoPrecoParaGrupo(sessao, precificacao.getIdFilial(), formacaoPreco, formacoesPrecos);
                idsProdutosAlterados.addAll(replicarComposicaoPrecoParaGrupo);
                idGrupo = formacaoPreco.getProduto().getIdHierarquia();
            }
            if (TipoReplicacaoFormacaoPreco.FORNECEDOR.equals((Object)formacaoPreco.getTipoReplicacaoPrecoProduto())) {
                List replicarComposicaoPrecoParaFornecedor = FormacaoPrecoRN.getInstance().replicarComposicaoPrecoParaFornecedor(sessao, precificacao.getIdFilial(), formacaoPreco, formacoesPrecos);
                idsProdutosAlterados.addAll(replicarComposicaoPrecoParaFornecedor);
                idFornecedor = formacaoPreco.getProduto().getIdFornecedor();
            }
            if (idFamilia == null && idGrupo == null && idFornecedor == null) {
                idProduto = precificacao.getIdProduto();
            }
            FormacaoPrecoRN.getInstance().replicarComposicaoPrecoFilialParaFiliaisListaProduto(sessao, precificacao.getIdFilial(), precificacao.getIdProduto(), formacoesPrecos);
            PrecificacaoRN.getInstance().preencherValoresDasFormacoesDePrecoNasPrecificacoes(precificarRequest.getPrecificacoes(), formacoesPrecos, precificacao.getIdFilial(), idProduto, idFamilia, idGrupo, idFornecedor, this.getTipoReplicacao(sessao.getFilial()));
            idsProdutosAlterados.add(precificacao.getIdProduto());
            PrecificacaoRN.getInstance().marcarItemComoPrecificadoProdutoFilial(idsProdutosAlterados, precificacao.getIdFilial(), precificarRequest.getPrecificacoes(), this.getTipoReplicacao(sessao.getFilial()));
        }
        return precificarRequest.getPrecificacoes();
    }

    @PostMapping(value={"/precificacao-rapida"})
    @DBAutoCommit
    public List<Precificacao> precificacaoRapida(@RequestBody PrecificarRequest precificarRequest) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (this.funcionalidadeService.programacaoPreco(sessao) && precificarRequest.getDataProgramada() == null) {
            throw new UnicoMensagemUsuarioException("WWW524", "Por favor informe a data de programa\u00e7\u00e3o do pre\u00e7o.");
        }
        TipoReplicacaoPrecoCusto tipoReplicacao = this.getTipoReplicacao(sessao.getFilial());
        List formacoesPrecos = precificarRequest.getPrecificacoes().stream().map(Precificacao::getFormacaoPreco).collect(Collectors.toList());
        ModoCalculoPreco modoCalculo = (ModoCalculoPreco)EnumUtils.getPorId(ModoCalculoPreco.class, (Object)PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 203));
        ArrayList<Long> idsProdutosAlterados = new ArrayList<Long>();
        ArrayList<Long> idsFiliais = new ArrayList<Long>();
        if (precificarRequest.getPrecificacoes().size() > 1) {
            precificarRequest.getPrecificacoes().forEach(precificacao -> {
                BigDecimal valorGerado;
                FormacaoPreco formacaoPreco = precificacao.getFormacaoPreco();
                formacaoPreco.setModoCalculoPreco(modoCalculo);
                if (ModoCalculoPreco.MARGEM_CONTRIBUICAO.equals((Object)modoCalculo)) {
                    formacaoPreco.setPercentualLucroAjustado(precificarRequest.getPercentualAjustado());
                    valorGerado = FormacaoPrecoRN.getInstance().calcularValorPorPercentualInformado(formacaoPreco, precificarRequest.getPercentualAjustado());
                } else {
                    formacaoPreco.setPercentualMarkupAjustado(precificarRequest.getPercentualAjustado());
                    valorGerado = FormacaoPrecoRN.getInstance().calcularMarkupPorPercentualAjustado(formacaoPreco, precificarRequest.getPercentualAjustado());
                }
                formacaoPreco.setPrecoVendaAjustado(valorGerado);
                formacaoPreco.setPrecificado(true);
                formacaoPreco.setPrecoAlterado(true);
                formacaoPreco.setMillisAlteracaoPreco(DataHoraFactory.getCurrentTimeMillisServidor((boolean)false).longValue());
                if (this.funcionalidadeService.programacaoPreco(sessao)) {
                    formacaoPreco.setDataProgramada(precificarRequest.getDataProgramada());
                }
                idsProdutosAlterados.add(formacaoPreco.getProduto().getId());
                if (!idsFiliais.contains(precificacao.getIdFilial())) {
                    idsFiliais.add(precificacao.getIdFilial());
                }
                PrecificacaoRN.getInstance().preencherValoresDasFormacoesDePrecoNasPrecificacoes(precificarRequest.getPrecificacoes(), formacoesPrecos, precificacao.getIdFilial(), formacaoPreco.getProduto().getId(), null, null, null, tipoReplicacao);
            });
        } else {
            Precificacao precificacao2 = (Precificacao)precificarRequest.getPrecificacoes().get(0);
            FormacaoPreco formacaoPreco = precificacao2.getFormacaoPreco();
            formacaoPreco.setModoCalculoPreco(modoCalculo);
            if (ModoCalculoPreco.MARGEM_CONTRIBUICAO.equals((Object)modoCalculo)) {
                formacaoPreco.setPercentualLucroAjustado(precificarRequest.getPercentualAjustado());
            } else {
                formacaoPreco.setPercentualMarkupAjustado(precificarRequest.getPercentualAjustado());
            }
            formacaoPreco.setPrecificado(true);
            formacaoPreco.setPrecoAlterado(true);
            formacaoPreco.setMillisAlteracaoPreco(DataHoraFactory.getCurrentTimeMillisServidor((boolean)false).longValue());
            if (this.funcionalidadeService.programacaoPreco(sessao)) {
                formacaoPreco.setDataProgramada(precificarRequest.getDataProgramada());
            }
            idsProdutosAlterados.add(formacaoPreco.getProduto().getId());
            if (!idsFiliais.contains(precificacao2.getIdFilial())) {
                idsFiliais.add(precificacao2.getIdFilial());
            }
            PrecificacaoRN.getInstance().preencherValoresDasFormacoesDePrecoNasPrecificacoes(precificarRequest.getPrecificacoes(), formacoesPrecos, precificacao2.getIdFilial(), formacaoPreco.getProduto().getId(), null, null, null, tipoReplicacao);
        }
        idsFiliais.forEach(idFilial -> PrecificacaoRN.getInstance().marcarItemComoPrecificadoProdutoFilial(idsProdutosAlterados, idFilial, precificarRequest.getPrecificacoes(), tipoReplicacao));
        precificarRequest.getPrecificacoes().forEach(precificacao -> precificacao.getFormacaoPreco().setPrecoVendaAjustadoOriginal(precificacao.getFormacaoPreco().getPrecoVendaAjustado()));
        return precificarRequest.getPrecificacoes();
    }

    @PostMapping(value={"/precificar"})
    @DBTransaction
    public ResponseEntity<byte[]> precificar(@RequestBody PrecificarRequest precificarRequest) throws UnicoMensagemUsuarioException {
        ArrayList idsNotas = new ArrayList();
        ArrayList embalagens = new ArrayList();
        ArrayList precificacoes = new ArrayList();
        ArrayList produtosIgnorarReplicacao = new ArrayList();
        ArrayList formacoes = new ArrayList();
        HashMap dadosNota = new HashMap();
        Sessao sessao = SessaoUtil.getSessao();
        precificarRequest.getPrecificacoes().forEach(precificacao -> {
            if (EnumPrecificado.PENDENTE.getId().equals(precificacao.getPrecificado())) {
                boolean precificar = true;
                if (precificarRequest.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) {
                    Long idNota = (Long)NotaFiscalItemRN.getInstance().buscarValoresPorID(precificacao.getIdNotaFiscalItem(), new String[]{"idnotafiscal"}).get("idnotafiscal");
                    Map dados = (Map)dadosNota.get(idNota);
                    if (dados == null) {
                        dados = this.buscarDadosNota(idNota);
                        dadosNota.put(idNota, dados);
                        precificacao.getFormacaoPreco().setCustoAlteradoPor(OrigemCusto.NOTA_FISCAL.getDescricao() + " - " + dados.get("numeronotafiscal"));
                    }
                    LocalDateTime dataHoraEmissao = null;
                    if (dados.containsKey("datahoraemissao")) {
                        dataHoraEmissao = (LocalDateTime)dados.get("datahoraemissao");
                    }
                    boolean bl = precificar = MovimentoEstoqueRN.getInstance().buscaMovimentoNotaFiscalCustoMedioMaisRecente((Long)dados.get("idfilial"), dataHoraEmissao, precificacao.getIdProduto()) == null;
                    if (precificar && !idsNotas.contains(idNota)) {
                        idsNotas.add(idNota);
                    }
                }
                if (precificar) {
                    precificacoes.add(precificacao);
                    formacoes.add(precificacao.getFormacaoPreco());
                    TipoReplicacaoPrecoCusto tipoReplicacao = this.getTipoReplicacao(sessao.getFilial());
                    if (TipoReplicacaoPrecoCusto.REPLICAR_CUSTO.equals((Object)tipoReplicacao) || TipoReplicacaoPrecoCusto.REPLICAR_PRECO.equals((Object)tipoReplicacao) || TipoReplicacaoPrecoCusto.NAO_REPLICAR.equals((Object)tipoReplicacao)) {
                        produtosIgnorarReplicacao.add(precificacao.getFormacaoPreco().getProduto());
                    }
                    if (!ListMapUtil.listNullOrEmpty((List)precificacao.getFormacaoPreco().getEmbalagens())) {
                        embalagens.addAll(precificacao.getFormacaoPreco().getEmbalagens());
                    }
                }
            }
        });
        ArrayList mensagensErro = new ArrayList();
        List formacoesOrdenadas = FormacaoPrecoRN.getInstance().ordenarFormacoesPrecoPorAlteracao(formacoes);
        if (precificarRequest.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) {
            formacoesOrdenadas.forEach(formacao -> formacao.setOrigemCusto(OrigemCusto.NOTA_FISCAL));
        }
        ProdutoRN.getInstance().aplicarAlteracoesPrecoPrecificacao(sessao, formacoesOrdenadas, this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL), null, mensagensErro);
        EmbalagemRN.getInstance().gravarEmbalagens(1, embalagens, sessao);
        PrecificadoRN.getInstance().incluirPorListaPrecificacao(sessao, precificacoes, PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 203));
        for (Precificacao precificacao2 : precificacoes) {
            NotaFiscalItem item = (NotaFiscalItem)NotaFiscalItemRN.getInstance().buscarPorId(precificacao2.getIdNotaFiscalItem());
            if (item != null) {
                this.atualizarNotaFiscalItem(sessao, item, precificacao2.getFormacaoPreco());
                NotaFiscalItemCommonRN.getInstance().gravar(1, (AbstractPojo)item, sessao);
            }
            precificacao2.getFormacaoPreco().setPrecoVendaAjustadoOriginal(precificacao2.getFormacaoPreco().getPrecoVendaAjustado());
        }
        if (precificarRequest.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) {
            for (Long idNota : idsNotas) {
                NotaFiscalRN.getInstance().atualizarNotaFisalPrecoPendente(sessao, idNota.longValue());
            }
            if (!FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO)) {
                for (Precificacao precificacao2 : precificarRequest.getPrecificacoes()) {
                    if (!precificarRequest.getTipo().equals((Object)TipoFiltroPrecificacao.ITENS_NOTAFISCAL)) continue;
                    Long idNota = (Long)NotaFiscalItemRN.getInstance().buscarValoresPorID(precificacao2.getIdNotaFiscalItem(), new String[]{"idnotafiscal"}).get("idnotafiscal");
                    NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNota);
                    Filial filial = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
                    NotaFiscalItemRN.getInstance().registraCalculoCustoMedioDiario(sessao, 1, notaFiscal.getDataHoraEmissao(), notaFiscal, filial);
                }
            }
        }
        if (!ListMapUtil.listNullOrEmpty(mensagensErro)) {
            return this.responseEntityService.createPDFResponse(new PrecificacaoRelatorio().getRelatorio(mensagensErro).getMalote().extrai("pdf"), "Erros precifica\u00e7\u00e3o");
        }
        return null;
    }

    @PostMapping(value={"/arredondar"})
    @DBTransaction
    public List<Precificacao> arredondarPrecos(@RequestBody ArredondarPrecificacaoRequest request) throws UnicoMensagemUsuarioException {
        for (Precificacao precificacao : request.getPrecificacoes()) {
            BigDecimal preco = precificacao.getFormacaoPreco().getPrecoVendaAjustadoOriginal();
            BigDecimal precoNovo = BigDecimal.ZERO;
            switch (request.getOpcaoArredondamento()) {
                case 1: {
                    precoNovo = ProdutoRN.getInstance().arrendondarCasaDecimalParaNove(preco, precificacao.getFormacaoPreco().getCasasDecimaisPreco(), false);
                    break;
                }
                case 2: {
                    precoNovo = ProdutoRN.getInstance().arrendondarCasaDecimalParaNove(preco, precificacao.getFormacaoPreco().getCasasDecimaisPreco(), true);
                    break;
                }
                case 3: {
                    precoNovo = ProdutoRN.getInstance().arrendondarCasaDecimalParaZero(preco, precificacao.getFormacaoPreco().getCasasDecimaisPreco(), false);
                    break;
                }
                case 4: {
                    precoNovo = ProdutoRN.getInstance().arrendondarCasaDecimalParaZero(preco, precificacao.getFormacaoPreco().getCasasDecimaisPreco(), true);
                }
            }
            precificacao.setDataUltimaPrecificacao(DataHoraFactory.getData());
            precificacao.getFormacaoPreco().setPrecoVendaAjustado(precoNovo);
            precificacao.setPrecoNovo(precoNovo);
            precificacao.setPrecificado(Integer.valueOf(2));
            precificacao.getFormacaoPreco().setPrecificado(true);
            precificacao.getFormacaoPreco().setPrecoAlterado(true);
            precificacao.getFormacaoPreco().setMillisAlteracaoPreco(DataHoraFactory.getCurrentTimeMillisServidor((boolean)false).longValue());
            FormacaoPrecoRN.getInstance().calcularLucroMarkupAjustado(precificacao.getFormacaoPreco(), precoNovo);
            if (ModoCalculoPreco.MARGEM_CONTRIBUICAO.equals((Object)precificacao.getFormacaoPreco().getModoCalculoPreco())) {
                precificacao.setLucroObtidoPercentual(precificacao.getFormacaoPreco().getPercentualLucroAjustado());
                continue;
            }
            precificacao.setLucroObtidoPercentual(precificacao.getFormacaoPreco().getPercentualMarkupAjustado());
        }
        for (Precificacao precificacao : request.getPrecificacoes()) {
            PrecificarRequest precificarRequest = new PrecificarRequest();
            precificarRequest.setIdPrecificacao(precificacao.getId());
            precificarRequest.setPrecificacoes(request.getPrecificacoes());
            this.validarPrecificacao(precificarRequest);
        }
        return request.getPrecificacoes();
    }

    private void atualizarNotaFiscalItem(Sessao sessao, NotaFiscalItem item, FormacaoPreco formacao) {
        if (item != null) {
            item.setPrecificado(true);
            item.setPercentualLucroMinimo(formacao.getPercentualCalculadoPrecoMinimo());
            item.setPercentualLucroMaximo(formacao.getPercentualCalculadoPrecoMaximo());
            item.setRebaixa(formacao.getRebaixa());
            item.setIdMotivoRebaixa(formacao.getIdMotivoRebaixa());
            item.setObservacaoRebaixa(formacao.getObservacaoRebaixa());
            item.setEmbalagensItensPrecificados(formacao.getEmbalagens());
            item.setStatusPrecoItem(StatusPrecoCompra.PRECO_ALTERADO_USUARIO);
            item.setCustoAquisicao(formacao.getCustoAquisicao());
            item.setPontoEquilibrio(formacao.getPontoEquilibrio());
            item.setFreteOutrasDespesas(formacao.getValorFreteOutrasDespesas());
            item.setValorICMSSTEntrada(formacao.getValorIcmsStEntrada());
            if (FormacaoPrecoRN.getInstance().isPermiteOutrosImpostosCusto(sessao)) {
                item.setOutrosImpostosCusto(formacao.getPercentualOutrosImpostosCusto());
                item.setValorOutrosImpostosCusto(formacao.getValorOutrosImpostosCusto());
            }
            if (FormacaoPrecoRN.getInstance().isPermiteOutrosValoresCusto(sessao)) {
                item.setOutrosValoresCusto(formacao.getValorOutrosValoresCusto());
                item.setPercentualOutrosValoresCusto(formacao.getPercentualOutrosValoresCusto());
            }
            item.setCustoOperacional(formacao.getPercentualCustoIndireto());
            item.setOutrosImpostosPreco(formacao.getPercentualOutrosImpostosPreco());
            item.setComissaoPreco(formacao.getPercentualComissao());
            item.setValorICMSSaida(formacao.getPercentualIcmsSaida());
            item.setAliquotaPisCofinsSaidaPreco(formacao.getPercentualPisCofinsSaida());
            item.setPercentualIPISaida(formacao.getPercentualDespesasVariaveisVenda());
            item.setModoCalculoPreco(formacao.getModoCalculoPreco());
            item.setTipoValorCustoFormacaoPrecoVenda(formacao.getTipoValorCalculoCusto().getId().intValue());
            if (ModoCalculoPreco.MARGEM_CONTRIBUICAO.equals((Object)formacao.getModoCalculoPreco())) {
                item.setLucroBruto(formacao.getPercentualLucroCalculado());
                item.setPercentualLucroAjustado(formacao.getPercentualLucroAjustado());
            } else {
                item.setLucroBruto(formacao.getPercentualMarkupCalculado());
                item.setPercentualMarkupCalculado(formacao.getPercentualMarkupCalculado());
                item.setPercentualMarkupAjustado(formacao.getPercentualMarkupAjustado());
            }
            item.setPrecoVendaAjustado(formacao.getPrecoVendaAjustado());
            item.setPrecoVendaAjustadoPauta1(formacao.getPrecoVendaAjustadoPauta1());
            item.setPrecoVendaAjustadoPauta2(formacao.getPrecoVendaAjustadoPauta2());
            item.setPrecoVendaAjustadoPauta3(formacao.getPrecoVendaAjustadoPauta3());
            item.setPrecoVendaAjustadoPauta4(formacao.getPrecoVendaAjustadoPauta4());
            item.setQuantidadePauta1(formacao.getQuantidadePauta1());
            item.setQuantidadePauta2(formacao.getQuantidadePauta2());
            item.setQuantidadePauta3(formacao.getQuantidadePauta3());
            item.setQuantidadePauta4(formacao.getQuantidadePauta4());
            item.setPercentualPauta1(formacao.getPercentualAjustadoPauta1());
            item.setPercentualPauta2(formacao.getPercentualAjustadoPauta2());
            item.setPercentualPauta3(formacao.getPercentualAjustadoPauta3());
            item.setPercentualPauta4(formacao.getPercentualAjustadoPauta4());
            item.setCmvAtual(formacao.getCmvAtual());
            item.setPercentualPrecoMinimoVenda(formacao.getPercentualPrecoMinimoVenda());
            item.setPrecoMinimoVenda(formacao.getPrecoMinimoVenda());
            if (Util.bigDecimalNullOrZero((BigDecimal)item.getValorIcmsDiferencialEntrada())) {
                item.setPercIcmsDiferencialComporPreco(formacao.getAliquotaIcmsDiferencialEntrada());
                item.setIcmsDiferencialComporPreco(formacao.getValorIcmsDiferencialEntrada());
            }
            item.setAplicaPrecoCalculado(false);
            item.setDataProgramacaoPreco(formacao.getDataProgramada() != null ? formacao.getDataProgramada() : DataHoraFactory.getData());
            item.setPrecoVendaModificado(true);
            TipoReplicacaoFormacaoPreco replicacao = formacao.getTipoReplicacaoPrecoProduto();
            item.setReplicarFormacao(replicacao);
            item.setReplicarCusto(formacao.isReplicarCusto());
        }
    }

    private Map<String, Object> buscarDadosNota(Long idNota) {
        return NotaFiscalRN.getInstance().buscarValoresPorID(idNota, new String[]{"idfilial", "datahoraemissao", "numeronotafiscal"});
    }

    private TipoReplicacaoPrecoCusto getTipoReplicacao(Filial filial) {
        Integer tipoReplicacaoInt = PropriedadeRN.getInstance().getPropriedadeInt(filial, 588);
        TipoReplicacaoPrecoCusto tipoReplicacao = (TipoReplicacaoPrecoCusto)EnumUtils.getPorId(TipoReplicacaoPrecoCusto.class, (Object)tipoReplicacaoInt, (AbstractEnum)TipoReplicacaoPrecoCusto.NAO_REPLICAR);
        if (tipoReplicacao == null) {
            tipoReplicacao = TipoReplicacaoPrecoCusto.NAO_REPLICAR;
        }
        return tipoReplicacao;
    }

    private void verificarModoCalculoPreco(Sessao sessao) throws UnicoMensagemUsuarioException {
        String modoCalculoPreco = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 203);
        if (!ModoCalculoPreco.MARKUP.getId().toString().equals(modoCalculoPreco) && !ModoCalculoPreco.MARGEM_CONTRIBUICAO.getId().toString().equals(modoCalculoPreco)) {
            PropriedadeRN.getInstance().setPropriedade(sessao, 203, ModoCalculoPreco.MARGEM_CONTRIBUICAO.getId().toString());
        }
    }

    @RequestMapping(value={"/buscar-tipo-comando-precificacao"})
    @DBAutoCommit
    public Object[] buscarListaTipoValorProduto(@RequestParam boolean incluiPrecoEmbalagem, @RequestParam boolean incluiCusto) {
        return TipoValorProduto.getInstance().getListTipoValorProduto(SessaoUtil.getSessao(), incluiPrecoEmbalagem, incluiCusto);
    }

    @PostMapping(value={"/executar-comando-precificacao"})
    @DBAutoCommit
    public List<Precificacao> executarComandoPrecificao(@RequestBody ComandosPrecificacaoRequest request) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PropriedadeRN.getInstance().setPropriedade(sessao, 657, request.getTipoArredondamento().getValorPropriedade());
        PropriedadeRN.getInstance().setPropriedade(sessao, 663, request.getArredondamento().getId());
        boolean isHabilitaProgramarPreco = PropriedadeRN.getInstance().isProgramacaoReajustePreco(sessao.getFilial());
        String modoCalculoPreco = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 203);
        List precificacaosSelecionado = request.getPrecificacoes();
        List idsProdutos = precificacaosSelecionado.stream().map(Precificacao::getIdProduto).distinct().collect(Collectors.toList());
        List formacaoPrecoSelecionado = FormacaoPrecoRN.getInstance().pesquisarFormacoesPreco(sessao, idsProdutos, request.getIdsFiliais(), request.getTipoFiltro());
        if (isHabilitaProgramarPreco) {
            FormacaoPrecoRN.getInstance().definirDataProgramacaoPrecoFormacoes(formacaoPrecoSelecionado, request.getDataProgramacao());
        }
        if (request.getTipoComando().equals((Object)TipoComandoPrecificacao.APLICA_PERCENTUAL)) {
            FormacaoPrecoRN.getInstance().aplicarPercentualFormacoesCampoOrigemCampoDestino(sessao, formacaoPrecoSelecionado, request.getAplicarPercentual(), request.getTipoValorAplicarOrigem(), request.getTipoValorAplicarDestino(), request.getArredondamento());
        } else if (request.getTipoComando().equals((Object)TipoComandoPrecificacao.APLICA_DESCONTO_PERCENTUAL)) {
            FormacaoPrecoRN.getInstance().aplicarPercentualDescontoFormacoesCampoOrigemCampoDestino(sessao, formacaoPrecoSelecionado, request.getAplicarDescontoPercentual(), request.getTipoValorDescontoOrigem(), request.getTipoValorDescontoDestino(), request.getArredondamento());
        } else if (request.getTipoComando().equals((Object)TipoComandoPrecificacao.APLICA_MARGEM_MARKUP_PERCENTUAL)) {
            boolean ocorreuErro = FormacaoPrecoRN.getInstance().aplicarMargemOuMarkupFormacoesPrecoCampoDestino(sessao, formacaoPrecoSelecionado, request.getAplicarMargemMarkupPercentual(), request.getTipoValorMargemMarkupDestino());
            if (ModoCalculoPreco.MARKUP.getId().toString().equals(modoCalculoPreco)) {
                for (FormacaoPreco formacaoPreco : formacaoPrecoSelecionado) {
                    if (request.getAplicarMargemMarkupPercentual().equals(formacaoPreco.getPercentualMarkupAjustado())) continue;
                    this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), sessao.getIdUsuario(), TipoNotificacaoSimples.WARNING, "Aten\u00e7\u00e3o! Devido ao arredondamento selecionado, o percentual de lucro pode sofrer reajuste autom\u00e1tico pelo sistema.");
                    break;
                }
            } else {
                for (FormacaoPreco formacaoPreco : formacaoPrecoSelecionado) {
                    if (request.getAplicarMargemMarkupPercentual().equals(formacaoPreco.getPercentualLucroAjustado())) continue;
                    this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), sessao.getIdUsuario(), TipoNotificacaoSimples.WARNING, "Aten\u00e7\u00e3o! Devido ao arredondamento selecionado, o percentual de lucro pode sofrer reajuste autom\u00e1tico pelo sistema.");
                    break;
                }
            }
            FormacaoPrecoRN.getInstance().replicarComposicaoPrecoFilialParaFiliaisLista(sessao, sessao.getFilial().getId(), formacaoPrecoSelecionado);
            if (ocorreuErro) {
                this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), sessao.getIdUsuario(), TipoNotificacaoSimples.SUCCESS, "Houve linha em que a altera\u00e7\u00e3o zerou o valor, os campos dos produtos afetados permanecem com o mesmo valor que tinham antes da altera\u00e7\u00e3o.");
            }
        } else if (request.getTipoComando().equals((Object)TipoComandoPrecificacao.APLICA_VALOR)) {
            FormacaoPrecoRN.getInstance().aplicarValorFormacoesCampoDestino(sessao, formacaoPrecoSelecionado, request.getAplicarValor(), request.getTipoValorDestino());
        } else if (request.getTipoComando().equals((Object)TipoComandoPrecificacao.APLICA_LUCRO_MINIMO)) {
            FormacaoPrecoRN.getInstance().aplicarMargemOuMarkupCadastroFormacoesPrecoCampoDestino(sessao, formacaoPrecoSelecionado, request.getTipoValorLucroMinimoDestino());
        }
        for (FormacaoPreco item : formacaoPrecoSelecionado) {
            if (modoCalculoPreco.equals("1")) {
                item.setModoCalculoPreco(ModoCalculoPreco.MARKUP);
                continue;
            }
            item.setModoCalculoPreco(ModoCalculoPreco.MARGEM_CONTRIBUICAO);
        }
        FormacaoPrecoRN.getInstance().calcularLucroMarkupAjustado(sessao, formacaoPrecoSelecionado);
        FormacaoPrecoRN.getInstance().replicarComposicaoPrecoFilialParaFiliaisLista(sessao, sessao.getFilial().getId(), formacaoPrecoSelecionado);
        FormacaoPrecoRN.getInstance().mudarTipoDeReplicacaoParaProduto(formacaoPrecoSelecionado);
        PrecificacaoRN.getInstance().preencherValoresDasFormacoesDePrecoNasPrecificacoes(precificacaosSelecionado, formacaoPrecoSelecionado, modoCalculoPreco);
        PrecificacaoRN.getInstance().marcarItensComoPrecificado(precificacaosSelecionado);
        FormacaoPrecoRN.getInstance().marcarItensComoPrecificado(formacaoPrecoSelecionado);
        for (Precificacao precificacao : precificacaosSelecionado) {
            precificacao.getFormacaoPreco().setPrecificado(true);
            precificacao.getFormacaoPreco().setPrecoAlterado(true);
            precificacao.getFormacaoPreco().setMillisAlteracaoPreco(DataHoraFactory.getCurrentTimeMillisServidor((boolean)false).longValue());
            precificacao.getFormacaoPreco().setPrecoVendaAjustado(precificacao.getPrecoNovo());
            if (!Util.bigDecimalNullOrZero((BigDecimal)precificacao.getPrecoPauta1())) {
                precificacao.getFormacaoPreco().setPrecoVendaAjustadoPauta1(precificacao.getPrecoPauta1());
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)precificacao.getPrecoPauta2())) {
                precificacao.getFormacaoPreco().setPrecoVendaAjustadoPauta2(precificacao.getPrecoPauta2());
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)precificacao.getPrecoPauta3())) {
                precificacao.getFormacaoPreco().setPrecoVendaAjustadoPauta3(precificacao.getPrecoPauta3());
            }
            if (Util.bigDecimalNullOrZero((BigDecimal)precificacao.getPrecoPauta4())) continue;
            precificacao.getFormacaoPreco().setPrecoVendaAjustadoPauta4(precificacao.getPrecoPauta4());
        }
        return precificacaosSelecionado;
    }
}

