/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.prestacaoservicodesacordocte;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.conhecimento.PrestacaoServicoDesacordoCTe;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.StatusPrestacaoServicoDesacordo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cte.CteManagerWeb;
import br.intelidata.commons.modulo.cte.regranegocio.PrestacaoServicoDesacordoCTeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prestacao-servico-desacordo-cte"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliar", NOME="Presta\u00e7\u00e3o de servi\u00e7o em desacordo - CT-e", ROTA="/notas-fiscais/prestacao-servico-desacordo-cte", PROGRAMA=0, CUSTOM_ACTION=true)
public class PrestacaoServicoDesacordoCteCrudController
extends CrudController<PrestacaoServicoDesacordoCTe, PrestacaoServicoDesacordoCTeRN> {
    public PrestacaoServicoDesacordoCteCrudController() {
        super((AbstractRegraNegocio)PrestacaoServicoDesacordoCTeRN.getInstance(), PrestacaoServicoDesacordoCTe::new, true, true);
    }

    protected String getCacheId() {
        return "prestacao-servico-desacordo-cte";
    }

    protected GridBuilder<PrestacaoServicoDesacordoCTeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("status", "Status", 0, false));
        colunas.add(new ColunaSQL("data", "Data", 120, true));
        colunas.add(new ColunaSQL("chavecte", "CT-e", 0, true));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        colunas.add(new ColunaSQL("mensagemretorno", "Mensagem", 0, true));
        GridBuilder grid = new GridBuilder(PrestacaoServicoDesacordoCTeRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("data", "dataordem"));
        grid.addOrdemDefault(new Ordem("dataordem", true));
        return grid;
    }

    @PostMapping(value={"/transmitir"})
    @DBAutoCommit
    public boolean transmitir(@RequestBody PrestacaoServicoDesacordoCTe prestacaoServicoDesacordoCTe) {
        Sessao sessao = SessaoUtil.getSessao();
        try {
            CteManagerWeb cteManagerWeb = new CteManagerWeb(sessao, (mensagem, processo) -> this.notificationService.notifyCteNow(mensagem));
            prestacaoServicoDesacordoCTe.setIdUsuario(sessao.getUsuario().getId());
            cteManagerWeb.enviarPrestacaoServicoDesacordo(prestacaoServicoDesacordoCTe);
            return StatusPrestacaoServicoDesacordo.AUTORIZADA.equals((Object)prestacaoServicoDesacordoCTe.getStatus());
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.notificationService.notifyCteNow(ex.getMensagemSemCodigo());
            return false;
        }
    }

    @PostMapping(value={"/cancelar"})
    @DBAutoCommit
    public void cancelar(@RequestBody Long idPrestacao) {
        Sessao sessao = SessaoUtil.getSessao();
        try {
            PrestacaoServicoDesacordoCTe prestacaoServicoDesacordoCTe = (PrestacaoServicoDesacordoCTe)PrestacaoServicoDesacordoCTeRN.getInstance().buscarPorId(idPrestacao);
            CteManagerWeb cteManagerWeb = new CteManagerWeb(sessao, (mensagem, processo) -> this.notificationService.notifyCteNow(mensagem));
            cteManagerWeb.cancelarPrestacaoServicoDesacordo(prestacaoServicoDesacordoCTe);
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.notificationService.notifyCteNow(ex.getMensagemSemCodigo());
        }
    }

    @PostMapping(value={"/download-xml"})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        PrestacaoServicoDesacordoCTe desacordoCTe = (PrestacaoServicoDesacordoCTe)PrestacaoServicoDesacordoCTeRN.getInstance().buscarPorId(id);
        HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
        String chaveAutorizada = "";
        if (desacordoCTe.getXml() != null) {
            chaveAutorizada = desacordoCTe.getChaveCte() + "-evPrestDesacordo" + Util.zeroEsquerda((Object)desacordoCTe.getSequencia(), (int)2);
            mapArquivos.put(chaveAutorizada + ".xml", desacordoCTe.getXml());
        }
        if (desacordoCTe.getXmlCancelamento() != null) {
            mapArquivos.put(desacordoCTe.getChaveCte() + "-evCancPrestDesacordo" + Util.zeroEsquerda((Object)desacordoCTe.getSequencia(), (int)2) + ".xml", desacordoCTe.getXmlCancelamento());
        }
        if (mapArquivos.size() == 1) {
            return this.responseEntityService.createXMLResponse((byte[])mapArquivos.get(chaveAutorizada + ".xml"), chaveAutorizada);
        }
        File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Xmls da CT-e ".concat(desacordoCTe.getChaveCte()).concat(".zip"));
        return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Xmls do CT-e ".concat(desacordoCTe.getChaveCte()));
    }
}

