/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.producao.fichatecnica;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoImagem;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.IPPT;
import br.intelidata.commons.domain.pojo.enuns.TipoGeracaoProducao;
import br.intelidata.commons.domain.pojo.enuns.TipoHierarquiaFichaTecnica;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoImagem;
import br.intelidata.commons.domain.pojo.producao.CalculoCustoTotalFicha;
import br.intelidata.commons.domain.pojo.producao.FichaTecnicaProduto;
import br.intelidata.commons.domain.pojo.producao.ProdutoFichaTecnica;
import br.intelidata.commons.domain.regranegocio.FichaTecnicaProdutoLocalEstoqueRN;
import br.intelidata.commons.domain.regranegocio.UnidademedidaCommonRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoFactory;
import br.intelidata.commons.modulo.producao.regranegocio.FichaTecnicaEspecificacaoRN;
import br.intelidata.commons.modulo.producao.regranegocio.FichaTecnicaProdutoRN;
import br.intelidata.commons.modulo.producao.regranegocio.QuantidadeFichaTecnicaRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.producao.fichatecnica.CopiarFichaTecnicaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.producao.fichatecnica.PopularFichaTecnicaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.producao.fichatecnica.SubstituirInsumosWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ficha-tecnica"})
@SubMenuMapping(MENU="SubMenuProducaoGeral", NOME="Ficha t\u00e9cnica", ROTA="/producao/ficha-tecnica", PROGRAMA=802, CUSTOM_ACTION=true)
public class FichaTecnicaCrudController
extends SimpleCrudController<ProdutoFichaTecnica, FichaTecnicaProdutoRN> {
    @Autowired
    private ResponseEntityService responseService;

    @DBAutoCommit
    public ProdutoFichaTecnica get(Long parentId) {
        ProdutoFichaTecnica produtoFichaTecnica = new ProdutoFichaTecnica();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(parentId);
        if (produto != null) {
            produtoFichaTecnica.setIdProduto(parentId);
            produtoFichaTecnica.setDescricaoProduto(produto.toString());
            produtoFichaTecnica.setRegistraProducaoSubItens(produto.isRegistraProducaoSubItens());
            produtoFichaTecnica.setRendimento(produto.getQuantidadePadrao());
            produtoFichaTecnica.setTipoQuantidade(produto.getTipoQuantidade());
            produtoFichaTecnica.setTipoQuantidadeProducao(produto.getTipoQuantidadeProducao());
            produtoFichaTecnica.setQuantidadeAlternativa(produto.getQuantidadeAlternativa());
            produtoFichaTecnica.setIdUnidadeMedidaAlternativa(produto.getIdUnidadeMedidaAlternativa());
            produtoFichaTecnica.setUnidadeMedida((String)UnidademedidaCommonRN.getInstance().buscarValorPorID(produto.getIdUnidadeMedida(), "codigo"));
            produtoFichaTecnica.setReceita(produto.getReceitaFichaTecnica());
            produtoFichaTecnica.setTipoGeracaoProducao(produto.getTipoGeracaoProducao() == null ? TipoGeracaoProducao.MANUALMENTE : produto.getTipoGeracaoProducao());
            produtoFichaTecnica.setListaQuantidade(QuantidadeFichaTecnicaRN.getInstance().buscaListaPorIdProduto(produto.getId(), produto.getIdUnidadeMedida()));
            produtoFichaTecnica.setListaEspecificacao(FichaTecnicaEspecificacaoRN.getInstance().buscaListaPorIdProduto(produto.getId()));
            ProdutoImagem pi = ProdutoRN.getInstance().buscaImagemPorTipo(produto, TipoProdutoImagem.FICHA_TECNICA);
            if (pi != null) {
                String caminho = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, TipoImagem.TamanhoOriginal, pi.getCaminhoImagem());
                produtoFichaTecnica.setCaminhoImagem(caminho);
            }
            try {
                List listaProdutos = FichaTecnicaProdutoRN.getInstance().buscarListaPorIdProdutoComFilhos(SessaoUtil.getSessao(), produto.getId(), Integer.valueOf(0), true, 0, null);
                produtoFichaTecnica.setListaProdutos(listaProdutos);
                if (Util.listNullOrEmpty((List)listaProdutos)) {
                    produtoFichaTecnica.setRegistraProducaoSubItens(true);
                }
            }
            catch (Throwable e) {
                String msg = e instanceof StackOverflowError ? "Ocorreu um erro ao carregar a ficha t\u00e9cnica deste produto. Ela precisa ser refeita!" : e.getMessage();
                throw new UnicoException("WPRD62", msg);
            }
        }
        return this.calcularTotalFicha(produtoFichaTecnica);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ProdutoFichaTecnica produtoFichaTecnica) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(produtoFichaTecnica.getIdProduto());
        FichaTecnicaProdutoRN.getInstance().gravaFichaTecnicaProduto(SessaoUtil.getSessao(), produto, produtoFichaTecnica.getListaProdutos(), produtoFichaTecnica.getIdUnidadeMedidaAlternativa(), produtoFichaTecnica.getQuantidadeAlternativa(), produtoFichaTecnica.getRendimento(), produtoFichaTecnica.getTipoQuantidade(), produtoFichaTecnica.getTipoQuantidadeProducao(), produtoFichaTecnica.getReceita(), produtoFichaTecnica.isRegistraProducaoSubItens(), produtoFichaTecnica.getTipoGeracaoProducao(), produtoFichaTecnica.getListaQuantidade(), produtoFichaTecnica.getListaEspecificacao());
        return 0L;
    }

    @RequestMapping(value={"/popular-ficha"}, method={RequestMethod.POST})
    @DBTransaction
    public ProdutoFichaTecnica popularFichaTecnica(@RequestBody PopularFichaTecnicaWrapper wrapper) throws UnicoMensagemUsuarioException {
        FichaTecnicaProduto ficha = wrapper.getFichaTecnicaNova();
        ficha.setIdProdutoPai(wrapper.getProdutoFichaTecnica().getIdProduto());
        if (FichaTecnicaProdutoRN.getInstance().verificaSeProdutoPaiEstaNosInsumos(ficha.getIdProduto(), Integer.valueOf(0), ficha.getIdProdutoPai(), Integer.valueOf(0), SessaoUtil.getSessao().getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WPRD59", "Este produto n\u00e3o pode ser inclu\u00eddo, pois o produto principal faz parte de seus insumos! Verifique.");
        }
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(ficha.getIdProduto());
        if (ficha.getIdProduto().equals(wrapper.getProdutoFichaTecnica().getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WPRD58", "Produto " + produto.getNome() + " n\u00e3o pode ser incluso na lista por se tratar do produto pai da ficha t\u00e9cnica.");
        }
        if (produto.isPossuiVariacao()) {
            throw new UnicoMensagemUsuarioException("WPRD60", "N\u00e3o \u00e9 poss\u00edvel incluir um produto com varia\u00e7\u00e3o na ficha t\u00e9cnica");
        }
        if (produto.isNumeroSerie()) {
            throw new UnicoMensagemUsuarioException("WPRD61", "N\u00e3o \u00e9 poss\u00edvel incluir um produto com n\u00famero de s\u00e9rie na ficha t\u00e9cnica");
        }
        ficha.setCodigoProduto(produto.getCodigo());
        ficha.setDescricaoProduto(produto.getNome());
        ficha.setFatorConversao(EmbalagemRN.getInstance().getEmbalagemFatorConversao(ficha.getIdEmbalagem()));
        Unidademedida unidademedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produto.getIdUnidadeMedida());
        if (unidademedida != null) {
            ficha.setIdUnidadeMedida(unidademedida.getId());
            ficha.setUnidadeMedida(unidademedida.getCodigo());
            ficha.setDecimaisUnidade(unidademedida.getCasasdecimais().intValue());
        }
        if (!FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO)) {
            ficha.setCusto(CustoFactory.getValorCustoProducao((Long)produto.getId(), (Filial)SessaoUtil.getSessao().getFilial()));
        }
        ficha.setVariacaoProduto(0);
        ficha.setDecimaisCusto(produto.getCasasDecimaisPrecoCusto().intValue());
        ficha.setFilhos(FichaTecnicaProdutoRN.getInstance().buscarListaPorIdProdutoComFilhos(SessaoUtil.getSessao(), ficha.getIdProduto(), Integer.valueOf(ficha.getVariacaoProduto()), true, 1, ficha));
        if (!ListMapUtil.listNullOrEmpty((List)ficha.getFilhos())) {
            ficha.setTipoComponente(TipoHierarquiaFichaTecnica.COMPONENTE_PAI);
        } else {
            ficha.setTipoComponente(TipoHierarquiaFichaTecnica.COMPONENTE);
        }
        if (NumberUtil.longNullOuZero((Long)ficha.getId())) {
            long maxId = wrapper.getProdutoFichaTecnica().getListaProdutos().stream().map(f -> Math.abs(f.getId())).max(Long::compareTo).orElse(0L);
            ficha.setId(Long.valueOf(-Math.abs(maxId + 1L)));
            wrapper.getProdutoFichaTecnica().getListaProdutos().add(ficha);
        } else {
            for (int i = 0; i < wrapper.getProdutoFichaTecnica().getListaProdutos().size(); ++i) {
                FichaTecnicaProduto fichaTecnicaProduto = (FichaTecnicaProduto)wrapper.getProdutoFichaTecnica().getListaProdutos().get(i);
                if (!fichaTecnicaProduto.getId().equals(ficha.getId())) continue;
                wrapper.getProdutoFichaTecnica().getListaProdutos().set(i, ficha);
                break;
            }
        }
        this.calcularTotalFicha(wrapper.getProdutoFichaTecnica());
        return wrapper.getProdutoFichaTecnica();
    }

    @RequestMapping(value={"/calcular-custo"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoFichaTecnica calcularTotalFicha(@RequestBody ProdutoFichaTecnica produtoFichaTecnica) {
        if (produtoFichaTecnica != null && !ListMapUtil.listNullOrEmpty((List)produtoFichaTecnica.getListaProdutos())) {
            CalculoCustoTotalFicha calculoCustoTotalFicha = FichaTecnicaProdutoRN.getInstance().calculaCustoFicha(SessaoUtil.getSessao().getFilial(), null, produtoFichaTecnica.getListaProdutos(), produtoFichaTecnica.isRegistraProducaoSubItens());
            boolean isGestaoCustoPreco = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO);
            BigDecimal custoTotal = produtoFichaTecnica.getListaProdutos().stream().map(fichaTecnicaProduto -> fichaTecnicaProduto.getCustoTotal(produtoFichaTecnica.isRegistraProducaoSubItens(), isGestaoCustoPreco)).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.calcularCustoTotalItem(produtoFichaTecnica.getListaProdutos(), produtoFichaTecnica.isRegistraProducaoSubItens(), isGestaoCustoPreco);
            BigDecimal custoPorQuantidade = custoTotal.divide(produtoFichaTecnica.getRendimento(), 10, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
            produtoFichaTecnica.setCustoPorQuantidade(custoPorQuantidade);
            produtoFichaTecnica.setCustoTotal(custoTotal);
            if (!StringUtil.stringNullOrEmpty((String)calculoCustoTotalFicha.getCodigosProdutos())) {
                produtoFichaTecnica.setMensagemCalculoCusto("Os seguintes produtos possuem custo diferente do c\u00e1lculo dos insumos: " + calculoCustoTotalFicha.getCodigosProdutos() + ".");
            }
        }
        return produtoFichaTecnica;
    }

    @RequestMapping(value={"/saldo-local-estoque"}, method={RequestMethod.POST})
    @DBAutoCommit
    public FichaTecnicaProduto getSaldoLocalEstoque(@RequestBody FichaTecnicaProduto fichaTecnicaProduto) {
        fichaTecnicaProduto.setSaldoEstoque(FichaTecnicaProdutoLocalEstoqueRN.getInstance().getSaltoEstoqueFilialSaldoEstoque(SessaoUtil.getSessao(), null, 0, fichaTecnicaProduto));
        return fichaTecnicaProduto;
    }

    @RequestMapping(value={"/copiar"}, method={RequestMethod.POST})
    @DBTransaction
    public void copiarFichaTecnica(@RequestBody CopiarFichaTecnicaWrapper copiarWrapper) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)copiarWrapper.getIdProdutoCopia())) {
            throw new UnicoMensagemUsuarioException("WPRD299", "Informe um produto para copiar a ficha t\u00e9cnica");
        }
        boolean retorno = false;
        Produto produtoParaCopia = (Produto)ProdutoRN.getInstance().buscarPorId(copiarWrapper.getIdProdutoCopia());
        if (produtoParaCopia != null) {
            if (produtoParaCopia.getIppt() != IPPT.MERCADORIA_MANUFATURADA_PELO_CONTRIBUINTE) {
                throw new UnicoMensagemUsuarioException("WPRD300", "Selecione um produto onde o IPPT seja igual a Mercadoria manufaturada pelo contribuinte");
            }
            retorno = FichaTecnicaProdutoRN.getInstance().copiarFicha(SessaoUtil.getSessao(), produtoParaCopia.getId(), copiarWrapper.getIdProdutoOriginal(), copiarWrapper.isCopiarProdutos(), copiarWrapper.isCopiarModoPreparo(), copiarWrapper.isCopiarEspecificacao(), copiarWrapper.isCopiarQuatidade(), copiarWrapper.isRegistraProducaoSubItens());
        }
        if (!retorno) {
            throw new UnicoMensagemUsuarioException("WPRD298", "N\u00e3o foi poss\u00edvel copiar a ficha informada.");
        }
    }

    @RequestMapping(value={"/substituir-insumos-em-massa"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<String> substituirInsumosEmMassa(@RequestBody SubstituirInsumosWrapper wrapper) throws UnicoMensagemUsuarioException {
        HashMap mapFichasAlteradas = new HashMap();
        HashMap mapRegistroProducaoAlterados = new HashMap();
        FichaTecnicaProdutoRN.getInstance().substituirInsumoEmMassa(SessaoUtil.getSessao(), wrapper.getIdProdutoInsumo(), wrapper.getIdProdutoNovo(), DataHoraFactory.getLocalDateInicioMes(), mapFichasAlteradas, mapRegistroProducaoAlterados);
        StringBuilder mensagem = FichaTecnicaProdutoRN.getInstance().mostrarFicharProducaoAlterada(mapFichasAlteradas, mapRegistroProducaoAlterados);
        if (mensagem.length() > 0) {
            return this.responseService.createJSONResponse("Processo finalizado.<br>" + mensagem.toString().replace("\n", "<br>"));
        }
        return null;
    }

    private void calcularCustoTotalItem(List<FichaTecnicaProduto> lista, boolean registrarProducaoSubitens, boolean gestaoCustoPreco) {
        if (!ListMapUtil.listNullOrEmpty(lista)) {
            for (FichaTecnicaProduto ficha : lista) {
                ficha.setCustoTotalWeb(ficha.getCustoTotal(registrarProducaoSubitens, gestaoCustoPreco));
                this.calcularCustoTotalItem(ficha.getFilhos(), registrarProducaoSubitens, gestaoCustoPreco);
            }
        }
    }
}

