/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ComplementoProdutoFilial;
import br.intelidata.commons.domain.pojo.ComponenteSaldoPreferencias;
import br.intelidata.commons.domain.pojo.ComponenteSaldoQuantidade;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.FormacaoPrecoProduto;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.JsonWrapped;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.Ncm;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoEmpresa;
import br.intelidata.commons.domain.pojo.ProdutoImagem;
import br.intelidata.commons.domain.pojo.ProdutoNumeroSerie;
import br.intelidata.commons.domain.pojo.ProdutoPautaPreco;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.Variacao;
import br.intelidata.commons.domain.pojo.annotations.FileWeb;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumSituacaoOrcamento;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.OrigemProduto;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusProdutoNumeroSerie;
import br.intelidata.commons.domain.pojo.enuns.TipoAliquotaEstado;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimento;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoOperacaoVeiculoNF;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoEspecifico;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoRodizio;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoValidacaoSaldo;
import br.intelidata.commons.domain.pojo.enuns.TipoVariacao;
import br.intelidata.commons.domain.pojo.enuns.TributacaoProduto;
import br.intelidata.commons.domain.pojo.enuns.estoque.TipoConfiguracaoEstoqueNegativo;
import br.intelidata.commons.domain.pojo.fiscal.ClassificacaoTributariaIbsCbs;
import br.intelidata.commons.domain.pojo.fiscal.ProdutoClassificacaoTributaria;
import br.intelidata.commons.domain.pojo.integracao.IntegracaoFiscalConsultaProdutoCadastro;
import br.intelidata.commons.domain.pojo.integracao.RetornoIntegracaoFiscalProduto;
import br.intelidata.commons.domain.pojo.producao.FichaTecnicaProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AliquotaEstadoCommonRN;
import br.intelidata.commons.domain.regranegocio.MotivoDesoneracaoIcmsPafRN;
import br.intelidata.commons.domain.regranegocio.NaturezaOperacaoCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoImagemCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoPautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.b2c.ProdutoTagRN;
import br.intelidata.commons.domain.regranegocio.b2c.TagRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoRN;
import br.intelidata.commons.modulo.estoque.regranegocio.LocalEstoqueRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.GrupoProdutoClassificacaoTributariaRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.ProdutoClassificacaoTributariaRN;
import br.intelidata.commons.modulo.integracao.regranegocio.UnicoIntegracaoFiscal;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoRN;
import br.intelidata.commons.modulo.producao.regranegocio.FichaTecnicaProdutoRN;
import br.intelidata.commons.modulo.produto.ProdutoOrigemCombustivelRN;
import br.intelidata.commons.modulo.produto.regranegocio.ComplementoProdutoFilialRN;
import br.intelidata.commons.modulo.produto.regranegocio.CustoAdicionalRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.LoteRN;
import br.intelidata.commons.modulo.produto.regranegocio.NcmRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoEanRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoEmpresaRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoFornecedorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoImagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoNaturezaOperacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoNumeroSerieRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoOpcionalRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRodizioRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavItemRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.coreinterfaces.ValidationSaldoEstoqueInterface;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.prompt.produto.ProdutoPromptController;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.AbstractProdutoCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.EanReferenciaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.SaldoPorFilialWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.ValidarPrecoMinimoWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.SaldoWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import unichef.pojo.ModoOpcional;
import unichef.regranegocio.ContaClienteRN;

@Component(value="produtos")
@ConfiguracaoCampoExtra(TABELA="cad_produto", QUANTIDADE=QuantidadeCampoExtra.PRODUTO)
@RestController
@RequestMapping(value={"/api/produtos"})
@SubMenuMapping(MENU="SubMenuCadastroGeral", NOME="Produtos", ICONE="icon-produto", ROTA="/produtos-module/produtos", PROGRAMA=6)
public class ProdutoCrudController
extends AbstractProdutoCrudController<Produto, ProdutoRN> {
    private final Map<String, ProdutoPromptController> cachePrompt;
    private final Map<String, ProdutoItemInterface> cacheProdutoItem;
    private ModuloService moduloService;
    private final Map<String, ValidationSaldoEstoqueInterface> cacheValidation;
    private final ResponseEntityService responseEntityService;

    @Autowired
    public ProdutoCrudController(ResponseEntityService responseEntityService, Map<String, ProdutoPromptController> cachePrompt, Map<String, ValidationSaldoEstoqueInterface> cacheValidation, Map<String, ProdutoItemInterface> cacheProdutoItem, FuncionalidadeService funcionalidadeService, ModuloService moduloService) {
        super((AbstractRegraNegocio)ProdutoRN.getInstance(), Produto::new, funcionalidadeService);
        this.responseEntityService = responseEntityService;
        this.cachePrompt = cachePrompt;
        this.cacheValidation = cacheValidation;
        this.cacheProdutoItem = cacheProdutoItem;
        this.moduloService = moduloService;
    }

    @RequestMapping(value={"/gerar-codigo-barras"})
    @DBTransaction
    public String gerarCodigoBarra(@RequestParam(value="codigoProduto") String codigoProduto) throws UnicoMensagemUsuarioException {
        return ProdutoRN.getInstance().gerarCodigoDeBarras(SessaoUtil.getSessao(), codigoProduto);
    }

    @RequestMapping(value={"/buscar-imagens-produto"})
    @DBTransaction
    public List<ProdutoImagem> buscarImagensProduto(@RequestParam(value="idProduto") Long idProduto) throws UnicoMensagemUsuarioException {
        ProdutoImagem produtoImagem;
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        List imagens = ProdutoImagemRN.getInstance().buscarListaPorIdProduto(produto.getId());
        if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoImagem())) {
            produtoImagem = new ProdutoImagem();
            produtoImagem.setTipoImagem(TipoProdutoImagem.PADRAO);
            produtoImagem.setCaminhoImagem(produto.getCaminhoImagem());
            imagens.add(produtoImagem);
        }
        if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoIcone())) {
            produtoImagem = new ProdutoImagem();
            produtoImagem.setTipoImagem(TipoProdutoImagem.ICONE);
            produtoImagem.setCaminhoImagem(produto.getCaminhoIcone());
            imagens.add(produtoImagem);
        }
        return imagens.stream().filter(imagem -> !StringUtil.stringNullOrEmpty((String)imagem.getCaminhoImagem()) && imagem.getTipoImagem().isWeb()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/validar-aliquota-icms"})
    @DBAutoCommit
    public boolean validarAliquota(@RequestParam(value="value") BigDecimal aliquota, @RequestParam(value="idEstado", required=false) Long idEstado) {
        if (NumberUtil.longNullOuZero((Long)idEstado)) {
            idEstado = SessaoUtil.getSessao().getFilial().getIdEstado();
        }
        return AliquotaEstadoCommonRN.getInstance().isAliquotaValida(TipoAliquotaEstado.ICMS, idEstado, aliquota);
    }

    @RequestMapping(value={"/permitir-tipo-produto"})
    @DBAutoCommit
    public boolean permitirTipoProduto(@RequestParam(value="idProduto") Long idProduto) {
        return !this.funcionalidadeService.isAtiva(Funcionalidade.CUSTO_MEDIO_MENSAL) || ProdutoRN.getInstance().isPermiteAlterarTipoProduto(idProduto);
    }

    @RequestMapping(value={"/possui-saldo"})
    @DBAutoCommit
    public boolean produtoPossuiSaldo(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        BigDecimal saldoPrevisto = ProdutoRN.getInstance().getSaldoPrevistoEstoque(SessaoUtil.getSessao(), SessaoUtil.getSessao().getFilial().getId(), idProduto);
        return (saldoPrevisto = saldoPrevisto.subtract(DavItemRN.getInstance().buscaPrevisaoVendaPorProduto(idProduto, null, SessaoUtil.getSessao().getFilial().getId(), Integer.valueOf(0), null, null, false))).compareTo(BigDecimal.ZERO) != 0;
    }

    @RequestMapping(value={"/gravar-formacao-produto"}, method={RequestMethod.PUT})
    @DBTransaction
    public Long gravarFormacaoPrecoProduto(@RequestBody FormacaoPrecoProduto formacaoPrecoProduto) throws UnicoMensagemUsuarioException {
        Produto produto;
        if (formacaoPrecoProduto == null) {
            throw new UnicoMensagemUsuarioException("WWW454", "Composi\u00e7\u00e3o de pre\u00e7o n\u00e3o informada.");
        }
        Produto produto2 = produto = !NumberUtil.longNullOuZero((Long)formacaoPrecoProduto.getIdProduto()) ? (Produto)ProdutoRN.getInstance().buscarPorId(formacaoPrecoProduto.getIdProduto()) : null;
        if (produto == null) {
            throw new UnicoMensagemUsuarioException("WWW455", "Produto n\u00e3o informado na composi\u00e7\u00e3o de pre\u00e7o.");
        }
        if (NumberUtil.longNullOuZero((Long)formacaoPrecoProduto.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WWW32", "Filial n\u00e3o informada na composi\u00e7\u00e3o de pre\u00e7o.");
        }
        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)formacaoPrecoProduto.getPreco()) && !PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 1027)) {
            throw new UnicoMensagemUsuarioException("WWW33", "O pre\u00e7o de venda do produto deve ser maior que zero. Por favor verifique!");
        }
        produto.setFormacaoPrecosPorFilial(Collections.singletonList(formacaoPrecoProduto));
        this.validarProgramacao(produto, null, formacaoPrecoProduto);
        ProdutoRN.getInstance().gravarPrecoProduto(SessaoUtil.getSessao(), produto);
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            FormacaoPrecoProduto formacao = FormacaoPrecoProdutoRN.getInstance().buscarFormacaoPrecoPorProdutoFilial(produto.getId(), formacaoPrecoProduto.getIdFilial());
            if (formacao != null) {
                return formacao.getId();
            }
            return null;
        }
        return produto.getId();
    }

    @RequestMapping(value={"/quantidade-por-preco"})
    @DBAutoCommit
    public BigDecimal getQuantidadePorPrecoTotal(@RequestParam Long idUnidadeMedida, @RequestParam BigDecimal preco, @RequestParam BigDecimal precoUnitarioProduto) {
        return ProdutoRN.getInstance().getQuantidadePorPrecoTotalWeb(idUnidadeMedida, preco, precoUnitarioProduto);
    }

    @RequestMapping(value={"/filtro-prompt"})
    @DBAutoCommit
    public ResponseEntity<String> filtraProdutosPromptController(@RequestParam String prompt, @RequestParam(required=false) String query, @RequestParam(name="idHierarquia", required=false) Long idHierarquia, @RequestParam(name="idFornecedor", required=false) Long idFornecedor, @RequestParam(name="idFamilia", required=false) Long idFamilia, @RequestParam(name="grid", required=false) boolean isGrid, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false) String filter, @RequestParam(required=false, name="produtoItem") String cacheItem, @RequestParam MultiValueMap<String, String> parameters, @RequestParam(required=false, defaultValue="true") boolean inativo) throws UnicoMensagemUsuarioException {
        String prod;
        ProdutoItemInterface produtoItemInterface = null;
        if (!StringUtil.stringNullOrEmpty((String)cacheItem)) {
            produtoItemInterface = (ProdutoItemInterface)this.cacheProdutoItem.get(cacheItem);
        }
        if (!StringUtil.stringNullOrEmpty((String)(prod = (String)parameters.getFirst((Object)"idProduto")))) {
            ProdutoDTOWeb produto = this.buscarDTOPorId(Long.valueOf(prod));
            if (produto != null) {
                if (produto.getObjUnidadeMedida() == null) {
                    throw new UnicoMensagemUsuarioException("WWW696", "Produto sem unidade de medida definida! Revise o cadastro do produto.");
                }
                if (produtoItemInterface != null) {
                    return this.responseEntityService.createJSONResponse(JsonUtil.toJson((Object)produtoItemInterface.carregarDadosItem(produto, parameters)));
                }
                return this.responseEntityService.createJSONResponse(JsonUtil.toJson((Object)produto));
            }
            throw new UnicoMensagemUsuarioException("WWW172", "Produto n\u00e3o encontrado!");
        }
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        if (parameters.containsKey((Object)"tiposEmbalagem")) {
            List novosTipos = StringUtil.getAllValuesMap(parameters, (String)"tiposEmbalagem");
            novosTipos.forEach(tipo -> {
                String[] tiposStr;
                for (String s : tiposStr = tipo.split(",")) {
                    TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, s);
                    if (tipos.contains(tipoEmbalagem)) continue;
                    tipos.add(tipoEmbalagem);
                }
            });
        }
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        ProdutoPromptController promptProduto = (ProdutoPromptController)this.cachePrompt.get(prompt);
        promptProduto.aplicarCondicoes(idHierarquia, idFornecedor, idFamilia, inativo, tipos);
        if (!isGrid) {
            promptProduto.executaFiltros(query);
            if (promptProduto.isAchouMaisDeUmRegistro() != null && !promptProduto.isAchouMaisDeUmRegistro().booleanValue()) {
                ProdutoDTOWeb produtoDTO = promptProduto.getObjeto();
                if (produtoDTO.getObjUnidadeMedida() == null) {
                    throw new UnicoMensagemUsuarioException("WWW697", "Produto sem unidade de medida definida! Revise o cadastro do produto.");
                }
                if (produtoItemInterface != null) {
                    return this.responseEntityService.createJSONResponse(JsonUtil.toJson((Object)produtoItemInterface.carregarDadosItem(produtoDTO, parameters)));
                }
                return this.responseEntityService.createJSONResponse(JsonUtil.toJson((Object)produtoDTO));
            }
        }
        List filtros = null;
        if (!StringUtil.stringNullOrEmpty((String)filter)) {
            filtros = (List)JsonUtil.fromJson((String)filter, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        Grid grid = promptProduto.getGrid();
        String data = JsonUtil.getJsonh((List)grid.getDadosWeb(page, 35, query, null, filtros, null), (List)grid.getColunasSql(), (int)grid.getTotalRegistros(), (int)35, null, null, (List)this.getTabelasConfiguracaoRelatorio(), null, null);
        return this.responseEntityService.createJSONResponse(data);
    }

    @RequestMapping(value={"/validar-numero-serie"})
    @DBAutoCommit
    public boolean validarNumeroSerie(@RequestParam Long idProduto, @RequestParam TipoMovimento tipoMovimento, @RequestParam String numeroSerie, @RequestParam(required=false) Long idCrud, @RequestParam(required=false) Long idItemAtual, @RequestParam(name="resourceName", required=false) String resourceName) throws UnicoMensagemUsuarioException {
        BigDecimal quantidade;
        ProdutoNumeroSerie produtoNumeroSerie = ProdutoNumeroSerieRN.getInstance().buscarPorIdProdutoNumeroSerie(idProduto, numeroSerie);
        if (produtoNumeroSerie != null) {
            if (produtoNumeroSerie.getStatus() == StatusProdutoNumeroSerie.BAIXADO && tipoMovimento.equals((Object)TipoMovimento.SAIDA)) {
                throw new UnicoMensagemUsuarioException("COM236638", "N\u00famero de s\u00e9rie j\u00e1 baixado.");
            }
            if (produtoNumeroSerie.getStatus() == StatusProdutoNumeroSerie.EM_ESTOQUE && tipoMovimento.equals((Object)TipoMovimento.ENTRADA)) {
                throw new UnicoMensagemUsuarioException("COM236639", "N\u00famero de s\u00e9rie j\u00e1 em estoque.");
            }
        } else if (tipoMovimento.equals((Object)TipoMovimento.SAIDA)) {
            throw new UnicoMensagemUsuarioException("COM236640", "N\u00famero de s\u00e9rie n\u00e3o cadastrado.");
        }
        if (!StringUtil.stringNullOrEmpty((String)resourceName) && !NumberUtil.longNullOuZero((Long)idCrud) && (quantidade = ((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeVendida(idCrud, idItemAtual, idProduto, null, numeroSerie, false, null)).compareTo(BigDecimal.ZERO) != 0) {
            throw new UnicoMensagemUsuarioException("WEST27", "N\u00famero de s\u00e9rie j\u00e1 adicionado em outro item.");
        }
        return true;
    }

    @RequestMapping(value={"/validar-saldo-estoque"})
    @DBAutoCommit
    public boolean validarSaldoEstoque(@RequestParam String resourceName, @RequestParam Integer origem, @RequestParam Long idProduto, @RequestParam(required=false) Long idCrud, @RequestParam(required=false) Long idItemAtual, @RequestParam(required=false) Long idFilial, @RequestParam(required=false) List<Long> idsLotes, @RequestParam(required=false) Long idLocalEstoque, @RequestParam(required=false) Long idUnidadeMedida, @RequestParam(name="variacao", required=false, defaultValue="0") Integer variacao, @RequestParam(name="quantidade") BigDecimal quantidade, @RequestParam(required=false) String variacoes, @RequestParam(required=false) List<Long> listaDavIgnorada, @RequestParam(required=false) List<Long> listaOSIgnorada, @RequestParam(required=false) List<Long> idsItensIgnorados, @RequestParam(required=false) Long idCfop, @RequestParam(required=false) boolean osOrcamento, @RequestParam(required=false) EnumSituacaoOrcamento situacaoOSOrcamento) throws UnicoMensagemUsuarioException {
        TipoValidacaoSaldo tipoValidacaoSaldo;
        int propriedade;
        Sessao sessao = SessaoUtil.getSessao();
        if (this.validaEstoqueDavDaf(resourceName)) {
            propriedade = PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 1006);
            tipoValidacaoSaldo = ProdutoRN.getInstance().buscaTipoValidacaoSaldoOSPedidos(sessao.getFilial().getId());
        } else if ("ajustes-estoque-saldo".equals(resourceName)) {
            propriedade = PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 1007);
            tipoValidacaoSaldo = TipoValidacaoSaldo.ATUAL;
        } else {
            propriedade = PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 75);
            tipoValidacaoSaldo = ProdutoRN.getInstance().buscaTipoValidacaoSaldo(sessao.getFilial().getId());
        }
        TipoConfiguracaoEstoqueNegativo tipoConfEstoqueNegativo = (TipoConfiguracaoEstoqueNegativo)EnumUtils.getPorId(TipoConfiguracaoEstoqueNegativo.class, (Object)propriedade);
        if (idFilial == null) {
            idFilial = sessao.getIdFilial();
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE) && NumberUtil.longNullOuZero((Long)idLocalEstoque) && Util.longNullOuZero((Long)(idLocalEstoque = sessao.getUsuario().getIdLocalEstoqueTrabalho()))) {
            throw new UnicoMensagemUsuarioException("COM236641", "Usu\u00e1rio n\u00e3o possui local de estoque definido.");
        }
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, idProduto);
        if (produto != null && produto.getTipo().equals((Object)TipoRegistroProduto.SERVICO)) {
            return true;
        }
        if (osOrcamento && !EnumSituacaoOrcamento.APROVADO.equals((Object)situacaoOSOrcamento)) {
            return true;
        }
        if (tipoConfEstoqueNegativo.equals((Object)TipoConfiguracaoEstoqueNegativo.BLOQUEAR)) {
            if (!StringUtil.stringNullOrEmpty((String)variacoes)) {
                Map mapVariacao = VariacaoRN.getInstance().stringToMap(variacoes);
                for (Map.Entry linhaVariacao : mapVariacao.entrySet()) {
                    BigDecimal saldo = TipoValidacaoSaldo.PREVISTO.equals((Object)tipoValidacaoSaldo) ? ProdutoRN.getInstance().getSaldoPrevistoEstoque(idFilial, idLocalEstoque, idProduto, ((Integer)linhaVariacao.getKey()).intValue(), listaDavIgnorada, listaOSIgnorada) : ProdutoRN.getInstance().getSaldoEstoque(idFilial, idLocalEstoque, ((Integer)linhaVariacao.getKey()).intValue(), idProduto);
                    BigDecimal qtd = new BigDecimal((Integer)linhaVariacao.getValue());
                    if (!StringUtil.stringNullOrEmpty((String)resourceName) && !NumberUtil.longNullOuZero((Long)idCrud)) {
                        saldo = saldo.add(((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeRestituida(idCrud, idItemAtual, idProduto, idsLotes, variacao.toString()));
                        qtd = qtd.add(((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeVendida(idCrud, idItemAtual, idProduto, idsLotes, variacao.toString(), false, idsItensIgnorados));
                    }
                    if (saldo.subtract(qtd).compareTo(BigDecimal.ZERO) >= 0) continue;
                    String nomeProduto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, idProduto).getNome();
                    Variacao variacaoProduto = VariacaoRN.getInstance().buscarObjectoPorIdProdutoTipoOrdem(idProduto, TipoVariacao.TIPO_VARIACAO, (Integer)linhaVariacao.getKey());
                    if (variacaoProduto != null) {
                        nomeProduto = nomeProduto + " (" + variacaoProduto.getDescricao() + ")";
                    }
                    String mascara = Util.getMascaraQuantidade((int)(idUnidadeMedida != null ? UnidademedidaRN.getInstance().getCasasDecimais(idUnidadeMedida) : 0));
                    String msg = "Estoque".concat(": ").concat(StringUtil.bigDecimal2String((BigDecimal)saldo, (String)mascara)).concat(" Venda: ").concat(StringUtil.bigDecimal2String((BigDecimal)qtd, (String)mascara));
                    throw new UnicoMensagemUsuarioException("WPVDV210", msg + " - Produto " + nomeProduto + " com saldo insuficiente em estoque. Venda n\u00e3o permitida.");
                }
            } else if (ProdutoRN.getInstance().isProdutoUmKit(idProduto)) {
                Map mapQuantidade = KitRN.getInstance().buscarQuantidadePorIdProdutoKitWeb(idProduto);
                for (Map.Entry entry : mapQuantidade.entrySet()) {
                    BigDecimal saldoEstoque = TipoValidacaoSaldo.PREVISTO.equals((Object)tipoValidacaoSaldo) ? ProdutoRN.getInstance().getSaldoPrevistoEstoque(idFilial, idLocalEstoque, (Long)entry.getKey(), 0, listaDavIgnorada, listaOSIgnorada) : ProdutoRN.getInstance().getSaldoEstoque(idFilial, idLocalEstoque, 0, (Long)entry.getKey());
                    BigDecimal qtdVendida = ((BigDecimal)entry.getValue()).multiply(quantidade);
                    if (!StringUtil.stringNullOrEmpty((String)resourceName) && !NumberUtil.longNullOuZero((Long)idCrud)) {
                        saldoEstoque = saldoEstoque.add(((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeRestituida(idCrud, idItemAtual, (Long)entry.getKey(), null, "0"));
                        qtdVendida = qtdVendida.add(((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeVendida(idCrud, idItemAtual, (Long)entry.getKey(), null, "0", true, idsItensIgnorados));
                    }
                    if (saldoEstoque.compareTo(qtdVendida) >= 0) continue;
                    Map produtoKit = ProdutoRN.getInstance().buscarValoresPorID((Long)entry.getKey(), new String[]{"idUnidadeMedida", "nome"});
                    String mascara = Util.getMascaraQuantidade((int)((Unidademedida)UnidademedidaRN.getInstance().buscarPorId((Long)produtoKit.get("idUnidadeMedida"))).getCasasdecimais());
                    String msg = "Quantidade em estoque: ".concat(Util.bigDecimal2String((BigDecimal)saldoEstoque, (String)mascara)).concat(" Quantidade vendida: ").concat(Util.bigDecimal2String((BigDecimal)qtdVendida, (String)mascara));
                    throw new UnicoMensagemUsuarioException("WEST61", msg.concat(" - Produto ").concat(produtoKit.get("nome").toString()).concat(" com saldo insuficiente em estoque. Venda n\u00e3o permitida."));
                }
            } else {
                BigDecimal saldo = ListMapUtil.listNullOrEmpty(idsLotes) ? (TipoValidacaoSaldo.PREVISTO.equals((Object)tipoValidacaoSaldo) ? ProdutoRN.getInstance().getSaldoPrevistoEstoque(idFilial, idLocalEstoque, idProduto, variacao.intValue(), listaDavIgnorada, listaOSIgnorada) : ProdutoRN.getInstance().getSaldoEstoque(idFilial, idLocalEstoque, variacao.intValue(), idProduto)) : (TipoValidacaoSaldo.PREVISTO.equals((Object)tipoValidacaoSaldo) ? LoteRN.getInstance().getSaldoPrevisto(idFilial, idProduto, idsLotes, listaDavIgnorada, listaOSIgnorada, idLocalEstoque) : LoteRN.getInstance().getSaldo(idsLotes, idLocalEstoque));
                BigDecimal quantidadeVendida = BigDecimal.ZERO;
                if (!StringUtil.stringNullOrEmpty((String)resourceName) && !NumberUtil.longNullOuZero((Long)idCrud)) {
                    saldo = saldo.add(((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeRestituida(idCrud, idItemAtual, idProduto, idsLotes, variacao.toString()));
                    quantidadeVendida = ((ValidationSaldoEstoqueInterface)this.cacheValidation.get(resourceName)).getQuantidadeVendida(idCrud, idItemAtual, idProduto, idsLotes, variacao.toString(), false, idsItensIgnorados);
                }
                if (saldo.compareTo(quantidade = quantidade.add(quantidadeVendida)) < 0) {
                    boolean validarFicha;
                    String mascara = Util.getMascaraQuantidade((int)(idUnidadeMedida != null ? UnidademedidaRN.getInstance().getCasasDecimais(idUnidadeMedida) : 0));
                    NaturezaOperacao cfop = idCfop != null ? NaturezaOperacaoCommonRN.getInstance().buscarPorId(idCfop) : null;
                    boolean bl = validarFicha = origem == -18 || origem == -21 || origem == 5 || origem == 48 || origem == 18 || origem == 43;
                    if (validarFicha && FichaTecnicaProdutoRN.getInstance().produtoPossuiFichaTecnica(idProduto) && (cfop == null || cfop.isRegistrarProducaoVenda())) {
                        List listaItensFicha = FichaTecnicaProdutoRN.getInstance().buscarListaPorIdProduto(idProduto, idFilial, false);
                        if (!Util.listNullOrEmpty((List)listaItensFicha)) {
                            StringBuilder mensagemException = new StringBuilder();
                            for (FichaTecnicaProduto fichaTecnicaProduto : listaItensFicha) {
                                BigDecimal quantidadeNecessaria;
                                Produto produtoFicha = (Produto)ProdutoCommonRN.getInstance().buscarPorId(fichaTecnicaProduto.getIdProduto());
                                saldo = TipoValidacaoSaldo.PREVISTO.equals((Object)tipoValidacaoSaldo) ? ProdutoRN.getInstance().getSaldoPrevistoEstoque(idFilial, idLocalEstoque, fichaTecnicaProduto.getIdProduto(), fichaTecnicaProduto.getVariacaoProduto(), (List)null, null) : ProdutoRN.getInstance().getSaldoEstoque(idFilial, idLocalEstoque, fichaTecnicaProduto.getVariacaoProduto(), fichaTecnicaProduto.getIdProduto());
                                if (saldo.subtract(quantidadeNecessaria = fichaTecnicaProduto.getQuantidade().multiply(quantidadeVendida)).compareTo(BigDecimal.ZERO) >= 0) continue;
                                mensagemException.append("Insumo ").append(produtoFicha.getNome()).append(" com saldo: ").append(Util.bigDecimal2String((BigDecimal)saldo, (String)mascara)).append(" - quantidade necess\u00e1ria: ").append(Util.bigDecimal2String((BigDecimal)quantidadeNecessaria, (String)mascara)).append("\n");
                            }
                            if (mensagemException.length() > 0) {
                                throw new UnicoMensagemUsuarioException("WPRD214", mensagemException.toString().concat(" - Saldo insuficiente em estoque."));
                            }
                        }
                    } else {
                        String msg = "Estoque".concat(": ").concat(StringUtil.bigDecimal2String((BigDecimal)saldo, (String)mascara)).concat(" Venda: ").concat(StringUtil.bigDecimal2String((BigDecimal)quantidade, (String)mascara));
                        throw new UnicoMensagemUsuarioException("WPRD213", msg.concat(" - Saldo insuficiente em estoque."));
                    }
                }
            }
        }
        return true;
    }

    @RequestMapping(value={"/buscar-dto-por-id/{id}"})
    @DBAutoCommit
    public ProdutoDTOWeb buscarDTOPorId(@PathVariable Long id) {
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), id);
    }

    @RequestMapping(value={"/buscar-dto-por-codigo"})
    @DBAutoCommit
    public ProdutoDTOWeb buscarDTOPorCodigo(@RequestParam String codigo) {
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), codigo);
    }

    @RequestMapping(value={"/buscar-dtos"})
    @DBAutoCommit
    public List<MapResultSet> buscarProdutosDTOs(@RequestParam(required=false) String query, @RequestParam(required=false) Long idHierarquia, @RequestParam(required=false) Long idNcm, @RequestParam(required=false, defaultValue="6") int limit) {
        List results = ProdutoRN.getInstance().buscarProdutoDTOWeb(query, idHierarquia, idNcm, limit, TipoRegistroProduto.PRODUTO);
        results.forEach(mapResultSet -> mapResultSet.put("custoFilialAtual", (Object)CustoRN.getInstance().getCustoAtualProdutoFilial(SessaoUtil.getSessao(), (Long)mapResultSet.get("id"))));
        return results;
    }

    @RequestMapping(value={"/buscar-produto-servico-dtos"})
    @DBAutoCommit
    public List<MapResultSet> buscarProdutosServicoDTOs(@RequestParam(required=false) String query, @RequestParam(required=false) Long idHierarquia, @RequestParam(required=false) Long idNcm, @RequestParam(required=false, defaultValue="6") int limit) {
        List results = ProdutoRN.getInstance().buscarProdutoDTOWeb(query, idHierarquia, idNcm, limit, null);
        results.forEach(mapResultSet -> mapResultSet.put("custoFilialAtual", (Object)CustoRN.getInstance().getCustoAtualProdutoFilial(SessaoUtil.getSessao(), (Long)mapResultSet.get("id"))));
        return results;
    }

    @RequestMapping(value={"/saldo-estoque"})
    @DBAutoCommit
    public Map<String, BigDecimal> getSaldoEstoque(@RequestParam(required=false) Long idFilial, @RequestParam Long idProduto, @RequestParam(required=false) Long idLocalEstoque, @RequestParam(required=false) String resource) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Map valoresProduto = ProdutoRN.getInstance().buscarValoresPorID(idProduto, new String[]{"tipo", "kit"});
        boolean isKit = ((Object)valoresProduto.getOrDefault("kit", 0)).equals(1);
        TipoRegistroProduto tipo = (TipoRegistroProduto)EnumUtils.getPorId(TipoRegistroProduto.class, (Object)valoresProduto.getOrDefault("tipo", "P"));
        HashMap<String, BigDecimal> saldos = new HashMap<String, BigDecimal>();
        if (isKit || TipoRegistroProduto.SERVICO.equals((Object)tipo)) {
            saldos.put("saldo", BigDecimal.ZERO);
            saldos.put("saldoPrevisto", BigDecimal.ZERO);
        } else {
            ComponenteSaldoQuantidade componenteSaldoQuantidade = ProdutoRN.getInstance().buscaSaldoQuantidadeComponente(sessao, idFilial, idProduto, null, idLocalEstoque, this.validaEstoqueDavDaf(resource));
            saldos.put("saldo", componenteSaldoQuantidade.getSaldoAtual());
            saldos.put("saldoPrevisto", componenteSaldoQuantidade.getSaldoPrevisto());
        }
        return saldos;
    }

    @RequestMapping(value={"/componente-saldo-estoque"})
    @DBAutoCommit
    public ComponenteSaldoPreferencias getComponenteSaldoPreferencias(@RequestParam(required=false) String resource) {
        return ProdutoRN.getInstance().verificaTipoSaldoComponente(SessaoUtil.getSessao(), this.validaEstoqueDavDaf(resource));
    }

    @RequestMapping(value={"/saldo-previsto-produto"})
    @DBAutoCommit
    public SaldoWrapper getSaldoProduto(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        BigDecimal saldoAtual = ProdutoRN.getInstance().getSaldoEstoque(SessaoUtil.getSessao(), SessaoUtil.getSessao().getFilial().getId(), idProduto);
        BigDecimal saldoPrevisto = ProdutoRN.getInstance().getSaldoPrevistoEstoque(SessaoUtil.getSessao(), SessaoUtil.getSessao().getFilial().getId(), idProduto);
        return new SaldoWrapper(StringUtil.bigDecimal2String((BigDecimal)saldoAtual, (String)StringUtil.getMascaraQuantidade((int)saldoAtual.scale())), StringUtil.bigDecimal2String((BigDecimal)saldoPrevisto, (String)StringUtil.getMascaraQuantidade((int)saldoPrevisto.scale())));
    }

    @RequestMapping(value={"/opcional"})
    @DBAutoCommit
    public ModoOpcional getModoOpcional() {
        return ContaClienteRN.getInstance().getModoOpcional();
    }

    @RequestMapping(value={"/atualizar-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Produto atualizaDadosGrupo(@RequestBody Produto produto, @RequestParam boolean replicarNulo) {
        HierarquiaGrupoProduto grupoProduto = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(produto.getIdHierarquia());
        if (grupoProduto != null) {
            if (grupoProduto.getCstICMS() != null || replicarNulo) {
                produto.setSituacaoTributaria(grupoProduto.getCstICMS());
            }
            if (!StringUtil.stringNullOrEmpty((String)grupoProduto.getTributacao()) || replicarNulo) {
                if (StringUtil.stringNullOrEmpty((String)grupoProduto.getTributacao())) {
                    produto.setTributacao(null);
                } else {
                    produto.setTributacao(((TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)grupoProduto.getTributacao())).name());
                }
            }
            if (grupoProduto.getPercentualReducaoICMS() != null || replicarNulo) {
                produto.setPercentualReducaoICMS(grupoProduto.getPercentualReducaoICMS());
            }
            produto.setPossuiAliquotaCombatePobreza(grupoProduto.isPossuiAliquotaCombatePobreza());
            produto.setAliquotaIcmsNf(grupoProduto.getAliquotaIcmsNf());
            produto.setAliquotaFcpNf(grupoProduto.getAliquotaFcpNf());
            if (grupoProduto.getSituacaoTributariaEntrada() != null || replicarNulo) {
                produto.setSituacaoTributariaEntrada(grupoProduto.getSituacaoTributariaEntrada());
            }
            if (grupoProduto.getAliquotaIcmsInterna() != null || replicarNulo) {
                produto.setAliquotaIcmsInterna(grupoProduto.getAliquotaIcmsInterna());
            }
            if (grupoProduto.getAliquotaFcp() != null || replicarNulo) {
                produto.setAliquotaFcp(grupoProduto.getAliquotaFcp());
            }
            if (grupoProduto.getTributacaoSN() != null || replicarNulo) {
                produto.setTributacaoSN(grupoProduto.getTributacaoSN());
            }
            if (grupoProduto.getMotivoDesoneracaoIcms() != null || replicarNulo) {
                produto.setMotivoDesoneracaoIcms(grupoProduto.getMotivoDesoneracaoIcms());
            }
            if (grupoProduto.getIdBeneficioFiscalOperacao() != null || replicarNulo) {
                produto.setIdBeneficioFiscalOperacao(grupoProduto.getIdBeneficioFiscalOperacao());
            }
            if (SessaoUtil.getSessao().getFilial().getTipoEnquadramento() == TipoEnquadramentoFilial.SIMPLESNACIONAL) {
                if (grupoProduto.getCstSNICMS() != null || replicarNulo) {
                    produto.setSituacaoTributariaSN(grupoProduto.getCstSNICMS());
                }
                if (grupoProduto.getSituacaoTributariaSNEntrada() != null || replicarNulo) {
                    produto.setSituacaoTributariaSNEntrada(grupoProduto.getSituacaoTributariaSNEntrada());
                }
            }
            if (grupoProduto.getTributacaoEspecialNfceSat() != null || replicarNulo) {
                produto.setTributacaoEspecialNfceSat(grupoProduto.getTributacaoEspecialNfceSat());
            }
            if (grupoProduto.getAliquotaReducaoIcmsNfceSat() != null || replicarNulo) {
                produto.setAliquotaReducaoIcmsNfceSat(grupoProduto.getAliquotaReducaoIcmsNfceSat());
            }
            if (!Util.longNullOuZero((Long)grupoProduto.getIdNcm()) || replicarNulo) {
                produto.setIdNcm(grupoProduto.getIdNcm());
            }
            if (!Util.longNullOuZero((Long)grupoProduto.getIdComprador()) || replicarNulo) {
                produto.setIdComprador(grupoProduto.getIdComprador());
            }
            if (grupoProduto.getModalidadeIcmsST() != null || replicarNulo) {
                produto.setModalidadeIcmsST(grupoProduto.getModalidadeIcmsST());
            }
            if (grupoProduto.getComissao() != null || replicarNulo) {
                produto.setComissao(grupoProduto.getComissao());
            }
            if (grupoProduto.getComissaoAPrazo() != null || replicarNulo) {
                produto.setComissaoAPrazo(grupoProduto.getComissaoAPrazo());
            }
            if (grupoProduto.getComissaoAVista() != null || replicarNulo) {
                produto.setComissaoAVista(grupoProduto.getComissaoAVista());
            }
            if (grupoProduto.getComissaoQuitacao() != null || replicarNulo) {
                produto.setComissaoQuitacao(grupoProduto.getComissaoQuitacao());
            }
            if (ModuloManager.getInstance().isAtivo(Modulo.COMISSAO)) {
                if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 6)) {
                    produto.setComissaoQuitacaoPauta1(grupoProduto.getComissaoQuitacaoPauta1());
                    produto.setComissaoAPrazoPauta1(grupoProduto.getComissaoAPrazoPauta1());
                    produto.setComissaoAVistaPauta1(grupoProduto.getComissaoAVistaPauta1());
                    produto.setComissaoPauta1(grupoProduto.getComissaoPauta1());
                }
                if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 9)) {
                    produto.setComissaoPauta2(grupoProduto.getComissaoPauta2());
                    produto.setComissaoAVistaPauta2(grupoProduto.getComissaoAVistaPauta2());
                    produto.setComissaoAPrazoPauta2(grupoProduto.getComissaoAPrazoPauta2());
                    produto.setComissaoQuitacaoPauta2(grupoProduto.getComissaoQuitacaoPauta2());
                }
                if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 12)) {
                    produto.setComissaoPauta3(grupoProduto.getComissaoPauta3());
                    produto.setComissaoAVistaPauta3(grupoProduto.getComissaoAVistaPauta3());
                    produto.setComissaoAPrazoPauta3(grupoProduto.getComissaoAPrazoPauta3());
                    produto.setComissaoQuitacaoPauta3(grupoProduto.getComissaoQuitacaoPauta3());
                }
                if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 15)) {
                    produto.setComissaoPauta4(grupoProduto.getComissaoPauta4());
                    produto.setComissaoAVistaPauta1(grupoProduto.getComissaoAVistaPauta4());
                    produto.setComissaoAPrazoPauta4(grupoProduto.getComissaoAPrazoPauta4());
                    produto.setComissaoQuitacaoPauta4(grupoProduto.getComissaoQuitacaoPauta4());
                }
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)grupoProduto.getValorIcmsST()) || replicarNulo) {
                produto.setValorIcmsST(grupoProduto.getValorIcmsST());
            }
            if (grupoProduto.getTributacaoEspecial() != null || replicarNulo) {
                produto.setTributacaoEspecial(grupoProduto.getTributacaoEspecial());
            }
            if (grupoProduto.getIppt() != null || replicarNulo) {
                produto.setIppt(grupoProduto.getIppt());
            }
            if (grupoProduto.getOrigem() != null || replicarNulo) {
                produto.setOrigem(grupoProduto.getOrigem());
            }
            if (grupoProduto.getIat() != null || replicarNulo) {
                produto.setIat(grupoProduto.getIat());
            }
            if (grupoProduto.getTipoProduto() != null || replicarNulo) {
                produto.setTipoProduto(grupoProduto.getTipoProduto());
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)grupoProduto.getPercentualReducaoMVA()) || replicarNulo) {
                produto.setPercentualReducaoMVA(grupoProduto.getPercentualReducaoMVA());
            }
            if (!Util.longNullOuZero((Long)grupoProduto.getIdTabelaMVA()) || replicarNulo) {
                produto.setIdTabelaMVA(grupoProduto.getIdTabelaMVA());
            }
            if (!Util.longNullOuZero((Long)grupoProduto.getIdCest()) || replicarNulo) {
                produto.setIdCest(grupoProduto.getIdCest());
            }
            if (grupoProduto.getSituacaoTributariaIPI() != null || replicarNulo) {
                produto.setSituacaoTributariaIPI(grupoProduto.getSituacaoTributariaIPI());
            }
            if (grupoProduto.getModoCalculoIPI() != null || replicarNulo) {
                produto.setModoCalculoIPI(grupoProduto.getModoCalculoIPI());
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)grupoProduto.getIpi()) || replicarNulo) {
                produto.setIpi(grupoProduto.getIpi());
            }
            if (grupoProduto.getSituacaoTributariaIPIEntrada() != null || replicarNulo) {
                produto.setSituacaoTributariaIPIEntrada(grupoProduto.getSituacaoTributariaIPIEntrada());
            }
            if (grupoProduto.getModoCalculoIPIEntrada() != null || replicarNulo) {
                produto.setModoCalculoIPIEntrada(grupoProduto.getModoCalculoIPIEntrada());
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)grupoProduto.getIpiEntrada()) || replicarNulo) {
                produto.setIpiEntrada(grupoProduto.getIpiEntrada());
            }
            if (grupoProduto.getCstPis() != null || replicarNulo) {
                produto.setCstPis(grupoProduto.getCstPis());
            }
            produto.setAliquotaPis(grupoProduto.getAliquotaPis());
            produto.setAliquotaCofins(grupoProduto.getAliquotaCofins());
            if (grupoProduto.getCstPisEntrada() != null || replicarNulo) {
                produto.setCstPisEntrada(grupoProduto.getCstPisEntrada());
            }
            if (produto.isEnviamobile() != grupoProduto.isEnviamobile()) {
                produto.setEnviamobile(grupoProduto.isEnviamobile());
            }
            produto.setAliquotaPisEntrada(grupoProduto.getAliquotaPisEntrada());
            produto.setAliquotaCofinsEntrada(grupoProduto.getAliquotaCofinsEntrada());
            produto.setPercentualMarkupMinimo(grupoProduto.getPercentualMarkupMinimo());
            produto.setPercentualMarkupMaximo(grupoProduto.getPercentualMarkupMaximo());
            produto.setLucroBrutoMinimo(grupoProduto.getLucroBrutoMinimo());
            produto.setLucroBrutoMaximo(grupoProduto.getLucroBrutoMaximo());
            produto.setMotivoDesoneracaoNf(grupoProduto.getMotivoDesoneracaoNf());
            produto.setIdBeneficioFiscalNf(grupoProduto.getIdBeneficioFiscalNf());
            produto.setIdBeneficioFiscalPresu(grupoProduto.getIdBeneficioFiscalPresu());
            produto.setAliquotaIcmsPresu(grupoProduto.getAliquotaIcmsPresu());
            produto.setIdBeneficioFiscalNfPresu(grupoProduto.getIdBeneficioFiscalNfPresu());
            produto.setAliquotaIcmsNfPresu(grupoProduto.getAliquotaIcmsNfPresu());
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 166)) {
                if (!NumberUtil.longNullOuZero((Long)grupoProduto.getIdContribuicaoPrevidenciaria()) || replicarNulo) {
                    produto.setIdContribuicaoPrevidenciaria(grupoProduto.getIdContribuicaoPrevidenciaria());
                }
                if (!NumberUtil.longNullOuZero((Long)grupoProduto.getIdContribuicaoSocialApurada()) || replicarNulo) {
                    produto.setIdContribuicaoSocialApurada(grupoProduto.getIdContribuicaoSocialApurada());
                }
                if (!NumberUtil.longNullOuZero((Long)grupoProduto.getIdReceitaSemContribuicao()) || replicarNulo) {
                    produto.setIdReceitaSemContribuicao(grupoProduto.getIdReceitaSemContribuicao());
                }
                if (!NumberUtil.longNullOuZero((Long)grupoProduto.getIdTipoCredito()) || replicarNulo) {
                    produto.setIdTipoCredito(grupoProduto.getIdTipoCredito());
                }
                if (!NumberUtil.longNullOuZero((Long)grupoProduto.getIdContribuicaoSocialApurCofins()) || replicarNulo) {
                    produto.setIdContribuicaoSocialApurCofins(grupoProduto.getIdContribuicaoSocialApurCofins());
                }
            }
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PREFIXO_GRUPO_PRODUTO) && Util.longNullOuZero((Long)produto.getId())) {
                produto.setCodigo(ProdutoRN.getInstance().getCodigoProduto(SessaoUtil.getSessao(), grupoProduto, Util.all2Atring((Object)produto.getCodigo())));
            }
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CFOP_PRODUTO) && !PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 747)) {
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopEntrada()) || replicarNulo) {
                    produto.setIdCfopEntrada(grupoProduto.getIdCfopEntrada());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopEntradaExterna()) || replicarNulo) {
                    produto.setIdCfopEntradaExterna(grupoProduto.getIdCfopEntradaExterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopEntradaDevolucaoInterna()) || replicarNulo) {
                    produto.setIdCfopEntradaDevolucaoInterna(grupoProduto.getIdCfopEntradaDevolucaoInterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopEntradaDevolucaoExterna()) || replicarNulo) {
                    produto.setIdCfopEntradaDevolucaoExterna(grupoProduto.getIdCfopEntradaDevolucaoExterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopEntradaTransfInterna()) || replicarNulo) {
                    produto.setIdCfopEntradaTransfInterna(grupoProduto.getIdCfopEntradaTransfInterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopEntradaTransfExterna()) || replicarNulo) {
                    produto.setIdCfopEntradaTransfExterna(grupoProduto.getIdCfopEntradaTransfExterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaida()) || replicarNulo) {
                    produto.setIdCfopSaida(grupoProduto.getIdCfopSaida());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaExterna()) || replicarNulo) {
                    produto.setIdCfopSaidaExterna(grupoProduto.getIdCfopSaidaExterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaDevolucaoInterna()) || replicarNulo) {
                    produto.setIdCfopSaidaDevolucaoInterna(grupoProduto.getIdCfopSaidaDevolucaoInterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaDevolucaoExterna()) || replicarNulo) {
                    produto.setIdCfopSaidaDevolucaoExterna(grupoProduto.getIdCfopSaidaDevolucaoExterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaTransfInterna()) || replicarNulo) {
                    produto.setIdCfopSaidaTransfInterna(grupoProduto.getIdCfopSaidaTransfInterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaTransfExterna()) || replicarNulo) {
                    produto.setIdCfopSaidaTransfExterna(grupoProduto.getIdCfopSaidaTransfExterna());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaExternaNaoContrib()) || replicarNulo) {
                    produto.setIdCfopSaidaExternaNaoContrib(grupoProduto.getIdCfopSaidaExternaNaoContrib());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopControlePerda()) || replicarNulo) {
                    produto.setIdCfopControlePerda(grupoProduto.getIdCfopControlePerda());
                }
                if (!Util.longNullOuZero((Long)grupoProduto.getIdCfopSaidaNfce()) || replicarNulo) {
                    produto.setIdCfopSaidaNfce(grupoProduto.getIdCfopSaidaNfce());
                }
            }
            if (ClassificacaoTributariaIbsCbsRN.getInstance().habilitarIbsCbs(SessaoUtil.getSessao().getFilial())) {
                List listaClassificacaoTributariaIbsCbsGrupo = GrupoProdutoClassificacaoTributariaRN.getInstance().buscarPorIdGrupoProduto(grupoProduto.getId());
                if (!Util.listNullOrEmpty((List)listaClassificacaoTributariaIbsCbsGrupo)) {
                    produto.setListaClassificacaoTributariaIbsCbs(listaClassificacaoTributariaIbsCbsGrupo.stream().map(grupoClaFis -> new ProdutoClassificacaoTributaria(grupoClaFis.getIdClassificacaoTributaria(), grupoClaFis.getIdClassificacaoTributacaoReg(), grupoClaFis.getObjClassificacao(), grupoClaFis.getObjClassificacaoRegular())).collect(Collectors.toList()));
                } else if (replicarNulo) {
                    produto.setListaClassificacaoTributariaIbsCbs(new ArrayList());
                }
                produto.getListaClassificacaoTributariaIbsCbs().forEach(classTrib -> {
                    if (classTrib.getObjClassificacao() == null) {
                        classTrib.setObjClassificacao((ClassificacaoTributariaIbsCbs)ClassificacaoTributariaIbsCbsRN.getInstance().buscarPorId(classTrib.getIdClassificacaoTributaria()));
                    }
                });
            }
        }
        return produto;
    }

    @RequestMapping(value={"/validar-ippt-contribuinte/{idProduto}"})
    @DBAutoCommit
    public void validarIppt(@PathVariable Long idProduto) throws UnicoMensagemUsuarioException {
        ProdutoRN.getInstance().validarMercadoriaManufaturadaContribuinte(idProduto);
    }

    @RequestMapping(value={"/saldo-por-filial"}, method={RequestMethod.POST})
    @DBTransaction
    public SaldoPorFilialWrapper buscarSaldoPorFilial(@RequestBody SaldoPorFilialWrapper wrapper) throws UnicoMensagemUsuarioException {
        List variacoes = null;
        if (wrapper.isPossuiVariacao()) {
            variacoes = VariacaoRN.getInstance().buscarListaPorIdProdutoTipo(wrapper.getIdProduto(), TipoVariacao.TIPO_VARIACAO);
        }
        List locaisEstoque = null;
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            locaisEstoque = LocalEstoqueRN.getInstance().buscarLista(false);
        }
        List filiais = FilialRN.getInstance().getDadosResumidosFiliaisWeb();
        List dados = ProdutoRN.getInstance().buscarSaldoPorFilial(wrapper.getIdProduto(), wrapper.getIdsFiliais(), variacoes, filiais, locaisEstoque, wrapper.isPossuiVariacao(), this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE), wrapper.isSaldoPrevisto(), wrapper.isSaldoMaiorQueZero(), true);
        wrapper.setVariacoes(variacoes);
        wrapper.setFiliais(filiais);
        wrapper.setLocais(locaisEstoque);
        wrapper.setDados(dados);
        wrapper.setCasasDecimais(CacheSistema.getInstance().getUnidadeMedida(CacheSistema.getInstance().getProduto(wrapper.getIdProduto()).getIdUnidadeMedida()).getCasasdecimais().intValue());
        PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 569, Boolean.valueOf(wrapper.isSaldoPrevisto()));
        return wrapper;
    }

    protected void beforeRead(Produto produto, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        TributacaoProduto tributacaoProduto;
        if (modo == 7) {
            if (!Util.longNullOuZero((Long)produto.getId())) {
                produto.setListaClassificacaoTributariaIbsCbs(ProdutoClassificacaoTributariaRN.getInstance().buscarPorIdProduto(produto.getId()));
            }
            ProdutoRN.getInstance().limparCamposParaDuplicar((AbstractPojo)produto);
        } else {
            List idsTags = ProdutoTagRN.getInstance().getTagsId(produto.getId());
            if (!ListMapUtil.listNullOrEmpty((List)idsTags)) {
                produto.setTags(TagRN.getInstance().buscarListaPorIds(idsTags));
            }
            List opcionais = ProdutoOpcionalRN.getInstance().buscarPorIdProduto(produto.getId());
            produto.setOpcionais(opcionais);
            List rodizios = ProdutoRodizioRN.getInstance().buscarPorIdRodizio(produto.getId());
            produto.setRodizios(rodizios);
            BigDecimal valorSaldo = BigDecimal.ZERO;
            if (!produto.isKit()) {
                valorSaldo = ProdutoRN.getInstance().getSaldoEstoque(SessaoUtil.getSessao(), SessaoUtil.getSessao().getIdFilial(), produto.getId());
            }
            produto.setSaldo(valorSaldo);
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                if (PropriedadeRN.getInstance().isReplicarPrecoVendaFiliais(SessaoUtil.getSessao().getFilial())) {
                    BigDecimal preco = ProdutoRN.getInstance().getPrecoBaseCadastroProduto(SessaoUtil.getSessao(), produto);
                    if (PropriedadeRN.getInstance().isProgramacaoReajustePreco(SessaoUtil.getSessao().getFilial())) {
                        produto.setPrecoProgramado(preco);
                    }
                    produto.setPreco(preco);
                }
                FormacaoPreco formacaoPreco = FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(SessaoUtil.getSessao(), produto.getId());
                produto.setPrecoCusto(formacaoPreco.getCustoCompra());
                produto.setCustoAquisicao(formacaoPreco.getCustoAquisicao());
                produto.setPontoEquilibrio(formacaoPreco.getPontoEquilibrio());
                produto.setDataPrecoCusto(formacaoPreco.getDataUltimaCompra());
                produto.setCustoMedio(formacaoPreco.getCustoMedio());
                produto.setPrecoUltimaCompra(formacaoPreco.getPrecoUltimaCompra());
                produto.setLucroBruto(formacaoPreco.getPercentualLucroCalculado());
            } else if (PropriedadeRN.getInstance().isProgramacaoReajustePreco(SessaoUtil.getSessao().getFilial())) {
                produto.setPrecoProgramado(produto.getPreco());
            }
            produto.setCfops(ProdutoNaturezaOperacaoRN.getInstance().buscarListaPorIdProduto(produto.getId()));
            produto.setPossuiGradeAntiga(ProdutoRN.getInstance().isPossuiGradeAntiga(produto.getId()));
            produto.setOrigens(ProdutoOrigemCombustivelRN.getInstance().buscarListaPorProduto(produto.getId()));
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRODUTO_EMPRESA) && modo != 7) {
            List produtoEmpresas = ProdutoEmpresaRN.getInstance().buscaIdsEmpresa(produto.getId());
            produto.setIdsEmpresa(produtoEmpresas.stream().map(ProdutoEmpresa::getIdEmpresa).collect(Collectors.toList()));
        }
        if (!StringUtil.stringNullOrEmpty((String)produto.getTributacao()) && (tributacaoProduto = (TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)produto.getTributacao())) != null) {
            produto.setTributacao(tributacaoProduto.name());
        }
        if (modo != 7) {
            Map pautas;
            ProdutoImagem produtoImagem2;
            List<ProdutoImagem> imagens = ProdutoImagemRN.getInstance().buscarListaPorIdProduto(produto.getId());
            if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoImagem())) {
                produtoImagem2 = new ProdutoImagem();
                produtoImagem2.setTipoImagem(TipoProdutoImagem.PADRAO);
                produtoImagem2.setCaminhoImagem(produto.getCaminhoImagem());
                imagens.add(produtoImagem2);
            }
            if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoIcone())) {
                produtoImagem2 = new ProdutoImagem();
                produtoImagem2.setTipoImagem(TipoProdutoImagem.ICONE);
                produtoImagem2.setCaminhoImagem(produto.getCaminhoIcone());
                imagens.add(produtoImagem2);
            }
            imagens = imagens.stream().filter(imagem -> !StringUtil.stringNullOrEmpty((String)imagem.getCaminhoImagem()) && imagem.getTipoImagem().isWeb()).collect(Collectors.toList());
            imagens.forEach(produtoImagem -> {
                if (!StringUtil.stringNullOrEmpty((String)produtoImagem.getCaminhoImagem())) {
                    produtoImagem.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, TipoImagem.Thumbnail, produtoImagem.getCaminhoImagem()));
                }
            });
            produto.setImagensProduto(imagens);
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) && (pautas = ProdutoPautaPrecoRN.getInstance().buscarListaPorIdProduto(produto.getId())) != null) {
                pautas.forEach((chave, lista) -> lista.forEach(pauta -> {
                    pauta.setDecimaisPreco(produto.getCasasDecimais().intValue());
                    pauta.setDecimaisQuantidade(produto.getCasasDecimaisUN() != null ? produto.getCasasDecimaisUN() : 0);
                }));
                produto.setPautasPreco(pautas);
            }
        }
        produto.setCasasDecimaisUN(Integer.valueOf(UnidademedidaRN.getInstance().getCasasDecimais(produto.getIdUnidadeMedida())));
    }

    public void loadFile(MultipartFile[] files, Produto produto) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            Map<Object, Object> mapImagens = !ListMapUtil.listNullOrEmpty((List)produto.getImagensProduto()) ? produto.getImagensProduto().stream().collect(Collectors.groupingBy(ProdutoImagem::getCaminhoImagem)) : new HashMap();
            for (MultipartFile file : files) {
                Object[] split;
                String originalName = file.getOriginalFilename();
                if (StringUtil.stringNullOrEmpty((String)originalName) || ListMapUtil.arrayNullOrEmpty((Object[])(split = originalName.split("\\|")))) continue;
                try {
                    Object fieldName = split[0];
                    if (((String)fieldName).equalsIgnoreCase("imagens")) {
                        List imagensProduto = (List)mapImagens.get(split[1]);
                        if (ListMapUtil.listNullOrEmpty((List)imagensProduto)) continue;
                        String caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, file);
                        byte[] imagem = file.getBytes();
                        imagensProduto.forEach(i -> {
                            i.setCaminhoImagem(caminho);
                            if (this.saveFile.isTabela()) {
                                i.setImagem(imagem);
                            }
                        });
                        continue;
                    }
                    Field field = produto.getClass().getDeclaredField((String)fieldName);
                    if (field == null) continue;
                    FileWeb fileWeb = field.getAnnotation(FileWeb.class);
                    if (fileWeb == null) {
                        throw new UnicoMensagemUsuarioException("WWW456", "Atributo n\u00e3o definido para o caminho da imagem [" + (String)fieldName + "]");
                    }
                    String url = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, file);
                    BeanUtil.set((Object)produto, (String)fileWeb.ATRIBUTO(), (Object)url);
                    if (!this.saveFile.isTabela()) continue;
                    BeanUtil.set((Object)produto, (String)fieldName, (Object)file.getBytes());
                }
                catch (IOException | NoSuchFieldException e) {
                    throw new UnicoMensagemUsuarioException("WWW457", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
                }
            }
        }
    }

    protected void beforeUpdate(Produto produto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Object codigo = ProdutoRN.getInstance().buscarValorPorID(produto.getId(), "codigo");
        if (!codigo.equals(produto.getCodigo())) {
            throw new UnicoMensagemUsuarioException("WWW721", "N\u00e3o \u00e9 poss\u00edvel alterar o c\u00f3digo do produto");
        }
        Map caminhos = ProdutoRN.getInstance().buscarCaminhoImagemIconeWeb(produto.getId());
        if (!ListMapUtil.mapNullOrEmpty((Map)caminhos)) {
            String caminhoImagem;
            String caminhoIcone = (String)caminhos.get("icone");
            if (!StringUtil.stringNullOrEmpty((String)caminhoIcone)) {
                String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.Thumbnail, caminhoIcone);
                if (StringUtil.stringNullOrEmpty((String)produto.getCaminhoIcone()) || !produto.getCaminhoIcone().equals(arquivoRelativo)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, caminhoIcone);
                } else {
                    produto.setCaminhoIcone(caminhoIcone);
                }
            }
            if (!StringUtil.stringNullOrEmpty((String)(caminhoImagem = (String)caminhos.get("imagem")))) {
                String arquivoRelativoImagem = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.Thumbnail, caminhoImagem);
                if (StringUtil.stringNullOrEmpty((String)produto.getCaminhoImagem()) || !produto.getCaminhoImagem().equals(arquivoRelativoImagem)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, caminhoImagem);
                } else {
                    produto.setCaminhoImagem(caminhoImagem);
                }
            }
        }
        HashMap mapImagens = !ListMapUtil.listNullOrEmpty((List)produto.getImagensProduto()) ? produto.getImagensProduto().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId())).collect(Collectors.toMap(ProdutoImagem::getId, Function.identity())) : new HashMap();
        List imagens = ProdutoImagemRN.getInstance().buscarListaPorIdProduto(produto.getId());
        for (ProdutoImagem imagem : imagens) {
            if (StringUtil.stringNullOrEmpty((String)imagem.getCaminhoImagem())) continue;
            if (mapImagens.containsKey(imagem.getId())) {
                ProdutoImagem produtoImagem = (ProdutoImagem)mapImagens.get(imagem.getId());
                String arquivoRelativoImagem = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.Thumbnail, imagem.getCaminhoImagem());
                if (StringUtil.stringNullOrEmpty((String)produtoImagem.getCaminhoImagem()) || !produtoImagem.getCaminhoImagem().equals(arquivoRelativoImagem)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, imagem.getCaminhoImagem());
                    continue;
                }
                produtoImagem.setCaminhoImagem(imagem.getCaminhoImagem());
                continue;
            }
            ProdutoImagemRN.getInstance().excluir((AbstractPojo)imagem, sessao);
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, imagem.getCaminhoImagem());
        }
        produto.setConfiguracoesEstoqueFilial(ComplementoProdutoFilialRN.getInstance().buscarListaConfiguracaoEstoqueProduto(produto.getId()));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            HashMap pautas = produto.getPautasPreco();
            if (pautas == null) {
                pautas = new HashMap();
            }
            produto.setPautasPreco(ProdutoRN.getInstance().getPrecosPautaFiliais(sessao, pautas));
        }
    }

    protected void beforeSave(Produto produto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List<FormacaoPrecoProduto> precosFiliais;
        Unidademedida unidade;
        produto.setTipo(TipoRegistroProduto.PRODUTO);
        produto.setCstCofins(produto.getCstPis());
        produto.setCstCofinsEntrada(produto.getCstPisEntrada());
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CUSTOS_ADICIONAIS) && !NumberUtil.longNullOuZero((Long)produto.getId())) {
            produto.setCustoAdicionalAlterado(true);
            produto.setCustosAdicionais(CustoAdicionalRN.getInstance().buscarListaPorProduto(produto.getId()));
        }
        if (produto.getTributacao().equals(TributacaoProduto.TRIBUTADO.getId())) {
            if (produto.getAliquotaIcmsInterna().compareTo(BigDecimal.ZERO) == 0 && !CstICMS.OUTROS.equals((Object)produto.getTributacaoEspecialNfceSat()) && !LicencaManager.getInstance().isNfce(SessaoUtil.getSessao().getFilial())) {
                throw new UnicoMensagemUsuarioException("WPRD195", "Se o campo 'PAF-ECF' for 'Tributado', o campo '% ICMS' deve ser maior que zero");
            }
            if (!this.validarAliquota(produto.getAliquotaIcmsInterna(), SessaoUtil.getSessao().getFilial().getIdEstado())) {
                throw new UnicoMensagemUsuarioException("WPRD197", "Al\u00edquota de ICMS informada \u00e9 inv\u00e1lida. Por favor verifique o cadastro de Al\u00edquotas por estado.");
            }
        }
        MotivoDesoneracaoIcmsPafRN.getInstance().validarMotivoDesoneracaoIcms(produto.getTributacaoEspecialNfceSat(), (TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)produto.getTributacao()), produto.getMotivoDesoneracaoIcms());
        Produto produtoOriginal = null;
        if (!NumberUtil.longNullOuZero((Long)produto.getId())) {
            produtoOriginal = (Produto)ProdutoRN.getInstance().buscarPorId(produto.getId());
        }
        if (produto.getIdUnidadeMedida() != null && (unidade = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produto.getIdUnidadeMedida())) != null) {
            produto.setUnidadeMedida(unidade.getCodigo());
        }
        boolean isPrecoAlterado = false;
        if (produtoOriginal == null) {
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                precosFiliais = Collections.singletonList(new FormacaoPrecoProduto(SessaoUtil.getSessao().getFilial().getId(), PropriedadeRN.getInstance().isProgramacaoReajustePreco(SessaoUtil.getSessao().getFilial()) ? produto.getPrecoProgramado() : produto.getPreco()));
                produto.setFormacaoPrecosPorFilial(precosFiliais);
                isPrecoAlterado = true;
            } else {
                isPrecoAlterado = true;
                if (ProdutoRN.getInstance().isProgramarPreco(produto, SessaoUtil.getSessao())) {
                    produto.setPrecoProgramado(produto.getPreco());
                    produto.setPreco(BigDecimal.ZERO);
                }
            }
        } else {
            if (!this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                if (produtoOriginal.getPreco().compareTo(produto.getPreco()) != 0) {
                    if (ProdutoRN.getInstance().isProgramarPreco(produto, SessaoUtil.getSessao())) {
                        produto.setPrecoProgramado(produto.getPreco());
                        produto.setPreco(produtoOriginal.getPreco());
                    }
                    isPrecoAlterado = true;
                }
            } else {
                if (PropriedadeRN.getInstance().isReplicarPrecoVendaFiliais(SessaoUtil.getSessao().getFilial())) {
                    precosFiliais = Collections.singletonList(new FormacaoPrecoProduto(SessaoUtil.getSessao().getIdFilial(), produto.getPreco()));
                    isPrecoAlterado = ProgramacaoAlteracaoPrecoRN.getInstance().isAlterouPrecoFilial(precosFiliais, produto.getId(), produto.getPreco(), produto.getPautasPreco());
                    produto.setFormacaoPrecosPorFilial(precosFiliais);
                } else {
                    precosFiliais = FormacaoPrecoProdutoRN.getInstance().buscarPrecosProduto(produto.getId());
                    precosFiliais.removeIf(precoFilial -> InativoFilial.isFilialInativa((Filial)FilialRN.getInstance().buscarQualquerFilialPorId(precoFilial.getIdFilial())));
                    produto.setFormacaoPrecosPorFilial(precosFiliais);
                    isPrecoAlterado = ProgramacaoAlteracaoPrecoRN.getInstance().isAlterouPrecoFilial(produto.getFormacaoPrecosPorFilial(), produto.getId(), produto.getPreco(), produto.getPautasPreco());
                }
                produto.setPrecoCusto(produtoOriginal.getPrecoCusto());
                produto.setDataPrecoCusto(produtoOriginal.getDataPrecoCusto());
                produto.setCustoMedio(produtoOriginal.getCustoMedio());
                produto.setPrecoUltimaCompra(produtoOriginal.getPrecoUltimaCompra());
            }
            isPrecoAlterado = isPrecoAlterado || ProdutoRN.getInstance().isAlterouPrecoPauta(SessaoUtil.getSessao(), produto, produtoOriginal);
        }
        produto.setPrecoAlterado(isPrecoAlterado);
        this.verificaGravar(produtoOriginal, produto);
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRODUTO_EMPRESA) && Util.listNullOrEmpty((List)produto.getIdsEmpresa())) {
            produto.setIdsEmpresa(EmpresaRN.getInstance().getIdsEmpresas());
        }
        if (produto.getFeedGoogleObj() != null) {
            produto.setFeedGoogle(new JsonWrapped(JsonUtil.toJson((Object)produto.getFeedGoogleObj())));
        }
        if (isPrecoAlterado) {
            String produtoKit;
            if (ProdutoRN.getInstance().isProgramarPreco(produto, SessaoUtil.getSessao())) {
                String produtoKit2;
                String descProduto = produto.getCodigo() + " - " + produto.getNome();
                String mensagem = "O pre\u00e7o foi programado para o produto " + descProduto;
                if (!NumberUtil.longNullOuZero((Long)produto.getId()) && !Util.stringNullOrEmpty((String)(produtoKit2 = KitRN.getInstance().getDescricaoKitsPorIdComponente(produto.getId()))) && (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 243) || PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 244))) {
                    mensagem = "O produto " + produto.getNome() + " pertence ao(s) kit(s): " + Util.newLine() + produtoKit2 + Util.newLine() + "Como o pre\u00e7o/custo foi alterado tamb\u00e9m ser\u00e1 alterado o pre\u00e7o do(s) kit(s) \u00e0 que ele pertence.";
                }
                this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.SUCCESS, mensagem);
            } else if (!NumberUtil.longNullOuZero((Long)produto.getId()) && !Util.stringNullOrEmpty((String)(produtoKit = KitRN.getInstance().getDescricaoKitsPorIdComponente(produto.getId()))) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 243)) {
                this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.SUCCESS, "O produto " + produto.getNome() + " pertence ao(s) kit(s):<br>" + produtoKit + "<br>Como o pre\u00e7o foi alterado tamb\u00e9m ser\u00e1 alterado o pre\u00e7o do(s) kit(s) \u00e0 que ele pertence.");
            }
        }
    }

    protected void beforeDelete(Produto produto) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoIcone())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, produto.getCaminhoIcone());
        }
        if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoImagem())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, produto.getCaminhoImagem());
        }
        List imagens = ProdutoImagemRN.getInstance().buscarListaPorIdProduto(produto.getId());
        for (ProdutoImagem imagem : imagens) {
            if (StringUtil.stringNullOrEmpty((String)imagem.getCaminhoImagem())) continue;
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, imagem.getCaminhoImagem());
        }
    }

    protected void afterSave(Produto produto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (this.moduloService.isAtivo(Modulo.UNICHEF)) {
            ProdutoOpcionalRN.getInstance().gravarOpcionaisProduto(SessaoUtil.getSessao(), produto.getId(), produto.getOpcionais());
            ProdutoRodizioRN.getInstance().gravarRodiziosProduto(SessaoUtil.getSessao(), produto.getId(), produto.getRodizios());
        }
        this.verificarCodigoAlfaNumerico();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Produto entity, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create((AbstractPojo)entity, parentId);
    }

    @ResponseBody
    @RequestMapping(value={"/create-files"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long createWithFile(@RequestPart MultipartFile[] files, @RequestPart(value="entity") Produto entity) throws UnicoMensagemUsuarioException {
        return super.createWithFile(files, (AbstractPojo)entity);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Produto produto, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)produto);
        this.beforeUpdate(produto, parentId);
        this.beforeSave(produto, parentId);
        Long id = produto.getId();
        this.gravarAuditoriaRegistro(id, (AbstractPojo)produto, 1);
        ProdutoRN.getInstance().gravar(1, produto, true, SessaoUtil.getSessao());
        this.afterUpdate((AbstractPojo)produto, parentId);
        this.afterSave(produto, parentId);
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "pdv-web");
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return id;
    }

    @ResponseBody
    @RequestMapping(value={"/update-files"}, method={RequestMethod.PUT}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long updateWithFiles(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") Produto entity) throws UnicoMensagemUsuarioException {
        return super.updateWithFiles(files, (AbstractPojo)entity);
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(ProdutoRN.getInstance().getTabela())) {
            return ExtrasRN.getInstance().buscarPorNomeTabela("cad_produto");
        }
        return null;
    }

    protected String getCacheId() {
        String idsEmpresas = "";
        String idCache = "produtos";
        Sessao sessao = SessaoUtil.getSessao();
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRODUTO_EMPRESA)) {
            idsEmpresas = Stream.of(FilialRN.getInstance().buscaEmpresaPerfilUsuario(sessao)).map(Object::toString).collect(Collectors.joining(","));
        }
        if (!StringUtil.stringNullOrEmpty((String)idsEmpresas)) {
            idCache = idCache.concat("_EMPRESAS=(").concat(idsEmpresas).concat(")");
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE) && !NumberUtil.longNullOuZero((Long)sessao.getUsuario().getIdLocalEstoqueTrabalho())) {
            idCache = idCache.concat("_LOCALESTOQUE_").concat(sessao.getUsuario().getIdLocalEstoqueTrabalho().toString());
        }
        return idCache.concat("_ID_FILIAL_").concat(sessao.getIdFilial().toString());
    }

    @RequestMapping(value={"/gerar-codigo-variacao"})
    @DBTransaction
    public String gerarCodigoBarras(@RequestParam(defaultValue="0", required=false) int variacao, @RequestParam String codigo, @RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        String codigoBarras = "";
        if (!Util.intNullOuZero((Integer)variacao)) {
            codigoBarras = ProdutoRN.getInstance().gerarCodigoBarrasVariacao(sessao, codigo, idProduto, variacao);
        } else {
            codigoBarras = ProdutoRN.getInstance().gerarCodigoDeBarras(sessao, codigo);
            ProdutoRN.getInstance().validarCodigoEAN(sessao, codigoBarras, codigo, true, null);
        }
        return codigoBarras;
    }

    @RequestMapping(value={"/imagens"})
    @DBAutoCommit
    public List<ProdutoImagem> carregarImagens(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        ArrayList<ProdutoImagem> produtoImagem = new ArrayList<ProdutoImagem>();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        if (!StringUtil.stringNullOrEmpty((String)produto.getCaminhoImagem())) {
            ProdutoImagem pi2 = new ProdutoImagem();
            pi2.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, TipoImagem.Grande, produto.getCaminhoImagem()));
            pi2.setTipoImagem(TipoProdutoImagem.PADRAO);
            pi2.setDescricao("");
            produtoImagem.add(pi2);
        }
        List produtoImagems = ProdutoImagemCommonRN.getInstance().buscarListaPorIdProduto(idProduto);
        produtoImagems.forEach(pi -> {
            pi.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, TipoImagem.Grande, pi.getCaminhoImagem()));
            produtoImagem.add((ProdutoImagem)pi);
        });
        return produtoImagem;
    }

    private void verificaGravar(Produto produtoOriginal, Produto produto) throws UnicoMensagemUsuarioException {
        FormacaoPrecoProduto formacao;
        BigDecimal preco;
        Sessao sessao = SessaoUtil.getSessao();
        BigDecimal bigDecimal = preco = ProdutoRN.getInstance().isProgramarPreco(produto, SessaoUtil.getSessao()) ? produto.getPrecoProgramado() : produto.getPreco();
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL) && !NumberUtil.longNullOuZero((Long)produto.getId()) && (formacao = FormacaoPrecoProdutoRN.getInstance().buscarFormacaoPrecoPorProdutoFilial(produto.getId(), sessao.getIdFilial())) != null && !NumberUtil.bigDecimalNullOrZero((BigDecimal)formacao.getPreco())) {
            preco = formacao.getPreco();
        }
        if (!PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 1027) && Util.bigDecimalNullOrZero((BigDecimal)preco)) {
            throw new UnicoMensagemUsuarioException("WPRD243", "O pre\u00e7o de venda do produto deve ser maior que zero. Por favor verifique!");
        }
        if (produtoOriginal != null) {
            String str;
            if (!produtoOriginal.isPossuiLote() && produto.isPossuiLote() || produtoOriginal.isPossuiLote() && !produto.isPossuiLote()) {
                str = produtoOriginal.isPossuiLote() ? "deixar de" : "";
                BigDecimal saldo = ProdutoRN.getInstance().getSaldoEstoque(sessao, sessao.getIdFilial(), produtoOriginal.getId());
                if (saldo.compareTo(BigDecimal.ZERO) != 0) {
                    throw new UnicoMensagemUsuarioException("WPRD217", "O produto " + produtoOriginal.getNome() + " n\u00e3o pode " + str + " ter lote pois possui saldo em estoque. Por favor verifique!");
                }
            }
            if (!produtoOriginal.isNumeroSerie() && produto.isNumeroSerie() || produtoOriginal.isNumeroSerie() && !produto.isNumeroSerie()) {
                String string = str = produtoOriginal.isNumeroSerie() ? "deixar de" : "";
                if (this.produtoPossuiSaldo(produtoOriginal.getId())) {
                    throw new UnicoMensagemUsuarioException("WWW39", "O produto " + produtoOriginal.getNome() + " n\u00e3o pode " + str + " ter n\u00famero de s\u00e9rie pois possui saldo em estoque. Por favor verifique!");
                }
            }
        }
        this.validarProgramacao(produto, produtoOriginal, null);
        if (produto.getProdutoEspecifico() == TipoProdutoEspecifico.VEICULO) {
            boolean invalido;
            boolean bl = invalido = produto.getTipoOperacao() == null || StringUtil.stringNullOrEmpty((String)produto.getChassi()) || StringUtil.stringNullOrEmpty((String)produto.getNumeroMotor()) || StringUtil.stringNullOrEmpty((String)produto.getSerial()) || StringUtil.stringNullOrEmpty((String)produto.getCmkg()) || StringUtil.stringNullOrEmpty((String)produto.getPotenciaMotor()) || StringUtil.stringNullOrEmpty((String)produto.getCilindrada()) || StringUtil.stringNullOrEmpty((String)produto.getPesoLiquidoVeiculo()) || StringUtil.stringNullOrEmpty((String)produto.getPesoBrutoVeiculo()) || StringUtil.stringNullOrEmpty((String)produto.getDistanciaEixos()) || StringUtil.stringNullOrEmpty((String)produto.getChassi()) || StringUtil.stringNullOrEmpty((String)produto.getTipoPintura()) || StringUtil.stringNullOrEmpty((String)produto.getCor()) || StringUtil.stringNullOrEmpty((String)produto.getDescricaoCor());
            if (TipoOperacaoVeiculoNF.FATURAMENTO_DIRETO_CONSUMIDOR_FINAL.equals((Object)produto.getTipoOperacao())) {
                if (NumberUtil.longNullOuZero((Long)produto.getIdEstadoConcessionaria()) || StringUtil.stringNullOrEmpty((String)produto.getCnpjConcessionaria())) {
                    invalido = true;
                }
                Util.validaCPFCNPJ((int)1, (String)produto.getCnpjConcessionaria());
            }
            if (invalido) {
                throw new UnicoMensagemUsuarioException("WWW40", "Por favor preencher todos os campos do ve\u00edculo.");
            }
        }
    }

    private void validarProgramacao(Produto produto, Produto produtoOriginal, FormacaoPrecoProduto formacaoPrecoProduto) throws UnicoMensagemUsuarioException {
        if (ProdutoRN.getInstance().isProgramarPreco(produto, SessaoUtil.getSessao())) {
            boolean isPossuiPrecoProgramado = false;
            if (!this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                if (produtoOriginal != null && !this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL) && produtoOriginal.getPreco().compareTo(produto.getPreco()) != 0) {
                    isPossuiPrecoProgramado = ProgramacaoAlteracaoPrecoItemRN.getInstance().isProdutoExisteProgramacao(produto.getDataProgramacaoAlteracaoPreco(), produtoOriginal.getId(), SessaoUtil.getSessao().getFilial().getId());
                }
            } else if (formacaoPrecoProduto != null) {
                boolean isPrecoAlterado = ProgramacaoAlteracaoPrecoRN.getInstance().isAlterouPrecoFilial(Collections.singletonList(formacaoPrecoProduto), produto.getId(), produto.getPreco(), produto.getPautasPreco());
                boolean bl = isPossuiPrecoProgramado = isPrecoAlterado && ProgramacaoAlteracaoPrecoItemRN.getInstance().isProdutoExisteProgramacao(produto.getDataProgramacaoAlteracaoPreco(), produto.getId(), formacaoPrecoProduto.getIdFilial());
            }
            if (isPossuiPrecoProgramado) {
                throw new UnicoMensagemUsuarioException("WPRD145", "O produto j\u00e1 est\u00e1 em outra programa\u00e7\u00e3o com a mesma data.");
            }
        }
    }

    @RequestMapping(value={"/buscar-opcionais-dtos"})
    @DBAutoCommit
    public List<MapResultSet> buscarOpcionaisDTOs(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") int limit) {
        Long idHierarquia = 0L;
        Long idNcm = 0L;
        Boolean apenasOpcionais = true;
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(query, idHierarquia, idNcm, apenasOpcionais, limit, TipoRegistroProduto.PRODUTO);
    }

    @RequestMapping(value={"/buscar-rodizios-dtos"})
    @DBAutoCommit
    public List<MapResultSet> buscarRodiziosDTOs(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") int limit) {
        Long idHierarquia = 0L;
        Long idNcm = 0L;
        Boolean apenasOpcionais = false;
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(query, idHierarquia, idNcm, apenasOpcionais, limit, TipoRegistroProduto.PRODUTO, TipoProdutoRodizio.ITEM_RODIZIO);
    }

    @RequestMapping(value={"/consultar-tributacao"})
    @DBAutoCommit
    public List<Produto> buscarTributacaoPorEan(@RequestParam String ean, @RequestParam String nome, @RequestParam(required=false) Long idProduto) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<Produto> produtos = new ArrayList<Produto>();
        IntegracaoFiscalConsultaProdutoCadastro consulta = new UnicoIntegracaoFiscal(sessao).consultaProdutoCadastro(sessao, ean, nome);
        if (consulta.getRetornoCompletoFiscalProduto() != null) {
            produtos.add(this.carregarProduto(consulta.getRetornoCompletoFiscalProduto(), nome, ean, sessao, idProduto));
        } else if (!Util.listNullOrEmpty((List)consulta.getListaPossiveisProdutos())) {
            for (RetornoIntegracaoFiscalProduto retornoProdutoEncontrado : consulta.getListaPossiveisProdutos()) {
                Produto produto = new Produto();
                produto.setCarregarProdutoIntegracao(true);
                produto.setNome(retornoProdutoEncontrado.getNomeProdutoIntegrador());
                produto.setCodigo(retornoProdutoEncontrado.getCodigoProdutoIntegrador());
                produtos.add(produto);
            }
        }
        return produtos;
    }

    @RequestMapping(value={"/consultar-tributacao-descricao"})
    @DBAutoCommit
    public Produto consultarTributacaoDescricao(@RequestParam String codigo, @RequestParam Long idProduto, @RequestParam(required=false) String nome) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        RetornoIntegracaoFiscalProduto retornoIntegracaoFiscalProduto = new UnicoIntegracaoFiscal(sessao).consultarViaIdDescricao(sessao, codigo);
        return this.carregarProduto(retornoIntegracaoFiscalProduto, nome, retornoIntegracaoFiscalProduto.getEanProdutoIntegrador(), sessao, idProduto);
    }

    private Produto carregarProduto(RetornoIntegracaoFiscalProduto retornoConsulta, String nome, String ean, Sessao sessao, Long idProduto) {
        Ncm ncm;
        Produto produto = new Produto();
        produto.setCodigo(((ProdutoRN)this.rn).getCodigoUnico(sessao));
        if (!NumberUtil.longNullOuZero((Long)idProduto)) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        }
        if (Util.stringNullOrEmpty((String)nome)) {
            produto.setNome(retornoConsulta.getNomeProdutoIntegrador());
            produto.setNomeEcf(retornoConsulta.getNomeProdutoIntegrador());
        }
        produto.setEan(ean);
        if ((sessao.getFilial().getParametroIntegracaoFiscal().getTipoIntegracaoFiscal().isPossuiTributacaoNfe() || sessao.getFilial().getParametroIntegracaoFiscal().getTipoIntegracaoFiscal().isVerificaSeAtualizaTributacaoNfeComTributacaoNFCe()) && sessao.getFilial().getParametroIntegracaoFiscal().isAtualizaTributacaoNfe()) {
            produto.setAliquotaIcmsNf(retornoConsulta.getAliquotaNfe());
            produto.setAliquotaFcpNf(retornoConsulta.getAliquotaFcpNfe());
            produto.setPercentualReducaoICMS(retornoConsulta.getReducaoBaseNfe());
        }
        produto.setAliquotaIcmsInterna(retornoConsulta.getAliquotaIcmsInterna());
        produto.setAliquotaFcp(retornoConsulta.getAliquotaFcpPafNfce());
        produto.setAliquotaReducaoIcmsNfceSat(retornoConsulta.getReducaoBasePafNfce());
        if (retornoConsulta.getTributacaoPaf() != null) {
            produto.setTributacao(retornoConsulta.getTributacaoPaf().name());
        }
        if (retornoConsulta.getCstIcmsNfce() != null) {
            produto.setTributacaoEspecialNfceSat(retornoConsulta.getCstIcmsNfce());
        }
        if (retornoConsulta.getCsosnNfce() != null) {
            produto.setTributacaoSN(retornoConsulta.getCsosnNfce());
        }
        if ((sessao.getFilial().getParametroIntegracaoFiscal().getTipoIntegracaoFiscal().isPossuiTributacaoNfe() || sessao.getFilial().getParametroIntegracaoFiscal().getTipoIntegracaoFiscal().isVerificaSeAtualizaTributacaoNfeComTributacaoNFCe()) && sessao.getFilial().getParametroIntegracaoFiscal().isAtualizaTributacaoNfe()) {
            produto.setPercentualReducaoICMS(retornoConsulta.getReducaoBasePafNfce());
            produto.setPossuiAliquotaCombatePobreza(retornoConsulta.isPossuiFcpNfe());
            if (retornoConsulta.getCstIcmsNfe() != null) {
                produto.setSituacaoTributaria(retornoConsulta.getCstIcmsNfe());
            }
            produto.setIdBeneficioFiscalNf(retornoConsulta.getIdBeneficioFiscalNfe());
            if (retornoConsulta.getCsosnNfce() != null) {
                produto.setSituacaoTributariaSN(retornoConsulta.getCsosnNfce());
            }
        }
        if (!Util.stringNullOrEmpty((String)retornoConsulta.getNcm()) && (ncm = NcmRN.getInstance().buscarNcm(retornoConsulta.getNcm().replace(".", ""), retornoConsulta.getNcmExcecao())) != null) {
            produto.setIdNcm(ncm.getId());
        }
        Optional<OrigemProduto> filtro = Arrays.stream(OrigemProduto.values()).filter(o -> o.getDescricao().equalsIgnoreCase(retornoConsulta.getOrigem())).findFirst();
        filtro.ifPresent(arg_0 -> ((Produto)produto).setOrigem(arg_0));
        produto.setCstPis(retornoConsulta.getCstPisCofins());
        produto.setAliquotaPis(retornoConsulta.getAliquotaPis());
        produto.setAliquotaCofins(retornoConsulta.getAliquotaCofins());
        if (!retornoConsulta.isIgnoraInformacoesEntrada()) {
            if (retornoConsulta.getCstPisEntrada() != null) {
                produto.setCstPisEntrada(retornoConsulta.getCstPisEntrada());
            }
            produto.setAliquotaPisEntrada(retornoConsulta.getAliquotaPisEntrada());
            produto.setAliquotaCofinsEntrada(retornoConsulta.getAliquotaCofinsEntrada());
        }
        produto.setIdReceitaSemContribuicao(retornoConsulta.getIdReceitaSemContribuicao());
        produto.setIdBeneficioFiscalOperacao(retornoConsulta.getIdBeneficioFiscalNfce());
        produto.setIdBeneficioFiscalNf(retornoConsulta.getIdBeneficioFiscalNfe());
        if (sessao.getFilial().getParametroIntegracaoFiscal().getTipoIntegracaoFiscal().isRetornaMotivoDesoneracao()) {
            produto.setMotivoDesoneracaoIcms(retornoConsulta.getMotivoDesoneracaoIcmsNfce());
            produto.setMotivoDesoneracaoNf(retornoConsulta.getMotivoDesoneracaoIcmsNfe());
        }
        produto.setIdCest(retornoConsulta.getIdCest());
        return produto;
    }

    @RequestMapping(value={"/gerar-menor-codigo-disponivel"})
    @DBAutoCommit
    public String gerarMenorCodigoDisponivel(@RequestParam(required=false) List<String> codigosParaIgnorar) throws UnicoMensagemUsuarioException {
        return ((ProdutoRN)this.rn).gerarMenorCodigoDeProdutoDisponivel(codigosParaIgnorar);
    }

    @PostMapping(value={"/validar-preco-minimo"})
    @DBAutoCommit
    public Map<String, Object> validarPrecoMinimo(@RequestBody List<ValidarPrecoMinimoWrapper> listaWrapper) {
        Sessao sessao = SessaoUtil.getSessao();
        List itensInvalidos = listaWrapper.stream().peek(it -> {
            if (it.isBuscarPrecoMinimo()) {
                BigDecimal precoMinimo;
                if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                    Map map = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), it.getIdProduto());
                    precoMinimo = (BigDecimal)map.get("precoMinimoVenda");
                } else {
                    Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(it.getIdProduto());
                    precoMinimo = produto.getPrecoMinimoVenda();
                }
                it.setPrecoMinimo(precoMinimo);
            }
            Map mapDados = ProdutoRN.getInstance().buscarValoresPorID(it.getIdProduto(), new String[]{"codigo", "nome"});
            it.setCodigoProduto(mapDados.get("codigo") + "");
            it.setNomeProduto(mapDados.get("nome") + "");
        }).filter(it -> !((ProdutoRN)this.rn).isPrecoMinimoValido(sessao.getFilial().getId(), sessao.getUsuario(), it.getPrecoUnitario(), it.getPrecoMinimo(), it.getIdPauta(), it.getIdPromocao(), it.getIdEntidadeDesconto(), it.isBrinde(), it.getValorDesconto(), it.getQuantidade())).collect(Collectors.toList());
        String mensagemRetorno = "";
        if (!itensInvalidos.isEmpty()) {
            mensagemRetorno = itensInvalidos.size() > 1 ? "Existem produtos com o pre\u00e7o menor que o pre\u00e7o m\u00ednimo de venda permitido. Deseja realmente aplicar este pre\u00e7o?<br>" + itensInvalidos.stream().map(i -> i.getCodigoProduto() + " - " + i.getNomeProduto() + " - pre\u00e7o minimo: R$" + i.getPrecoMinimo()).collect(Collectors.joining("<br>")) : "O pre\u00e7o do produto [" + ((ValidarPrecoMinimoWrapper)itensInvalidos.get(0)).getNomeProduto() + "] \u00e9 menor que o pre\u00e7o m\u00ednimo de venda permitido [R$ " + ((ValidarPrecoMinimoWrapper)itensInvalidos.get(0)).getPrecoMinimo() + "]. Deseja realmente aplicar este pre\u00e7o?";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mensagem", mensagemRetorno);
        map.put("itens", itensInvalidos);
        return map;
    }

    @RequestMapping(value={"/buscar-detalhes-saldo"})
    @DBAutoCommit
    public String buscarDetalhesSaldo(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        String retorno = "";
        if (produto != null) {
            Sessao sessao = SessaoUtil.getSessao();
            int casasDecimaisQuantidade = UnidademedidaRN.getInstance().getCasasDecimais(produto.getIdUnidadeMedida());
            BigDecimal saldoAtual = BigDecimal.ZERO;
            BigDecimal saldoPrevisto = BigDecimal.ZERO;
            BigDecimal saldoPedidoCompra = BigDecimal.ZERO;
            if (!produto.isKit()) {
                saldoAtual = ProdutoRN.getInstance().getSaldoEstoque(sessao, sessao.getFilial().getId(), idProduto);
                saldoPrevisto = ProdutoRN.getInstance().getSaldoPrevistoEstoque(sessao, sessao.getFilial().getId(), idProduto);
                saldoPedidoCompra = ProdutoRN.getInstance().getSaldoPedidosCompra(sessao.getFilial().getId(), idProduto);
            }
            retorno = "Saldo em estoque: " + Util.bigDecimal2String((BigDecimal)saldoAtual, (String)Util.getMascaraQuantidade((int)casasDecimaisQuantidade));
            retorno = retorno + " - Saldo previsto em estoque: " + Util.bigDecimal2String((BigDecimal)saldoPrevisto, (String)Util.getMascaraQuantidade((int)casasDecimaisQuantidade));
            retorno = retorno + " - Pedidos de compra: " + Util.bigDecimal2String((BigDecimal)saldoPedidoCompra, (String)Util.getMascaraQuantidade((int)casasDecimaisQuantidade));
            ComplementoProdutoFilial configuracaoSaldo = ComplementoProdutoFilialRN.getInstance().buscarConfiguracaoEstoque(sessao.getFilial().getId(), produto);
            if (!Util.bigDecimalNullOrZero((BigDecimal)configuracaoSaldo.getQuantidadeMinima()) && saldoPrevisto.compareTo(configuracaoSaldo.getQuantidadeMinima()) < 0) {
                retorno = retorno + " - Saldo abaixo do estoque m\u00ednimo";
            }
            if (!Util.bigDecimalNullOrZero((BigDecimal)configuracaoSaldo.getQuantidadeMaxima()) && saldoPrevisto.compareTo(configuracaoSaldo.getQuantidadeMaxima()) > 0) {
                retorno = retorno + " - Saldo acima do estoque m\u00e1ximo";
            }
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO)) {
                retorno = retorno + " - " + NotaFiscalItemRN.getInstance().buscarInformacoesUltimaCompra(sessao.getFilial(), idProduto);
            }
        }
        return retorno;
    }

    public boolean validaEstoqueDavDaf(String resourceName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ordem-servico-estoque-saldo");
        list.add("dav-estoque-saldo");
        return list.contains(resourceName);
    }

    private boolean produtoPossuiPautaInformada(Long idProduto, Long idPauta, Long idFilial) {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            if (!Util.longNullOuZero((Long)idPauta)) {
                ProdutoPautaPreco produtoPauta = ProdutoPautaPrecoRN.getInstance().buscarPorIdProdutoPauta(idProduto, idFilial, idPauta);
                return produtoPauta != null && !Util.bigDecimalNullOrZero((BigDecimal)produtoPauta.getPreco());
            }
        } else if (idPauta != null && idPauta >= 1L && idPauta <= 4L) {
            BigDecimal pauta = (BigDecimal)ProdutoRN.getInstance().buscarValorPorID(idProduto, "precoPauta" + idPauta);
            return pauta.compareTo(BigDecimal.ZERO) > 0;
        }
        return false;
    }

    private void verificarCodigoAlfaNumerico() {
        ColunaSQL coluna = this.grid.getGridBuilder().getColunaSQL("codigo");
        if (coluna != null && Funcao.TO_NUMBER.equals((Object)coluna.getFuncao()) && ((ProdutoRN)this.rn).codigoProdutoContemAlfanumerico()) {
            this.limparCache();
        }
    }

    @RequestMapping(value={"/buscar-eans-referencias"})
    @DBAutoCommit
    public EanReferenciaWrapper buscarEansReferencias(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        List listaReferencias;
        EanReferenciaWrapper wrapper = new EanReferenciaWrapper();
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.MULTIPLOS_CODIGOS_BARRAS)) {
            List listaEan = ProdutoEanRN.getInstance().buscarListaPorProduto(idProduto);
            if (!Util.listNullOrEmpty((List)listaEan)) {
                listaEan.removeIf(ean -> Util.stringNullOrEmpty((String)ean.getEan()));
            }
            wrapper.setEans(listaEan);
        }
        if (!Util.listNullOrEmpty((List)(listaReferencias = ProdutoFornecedorRN.getInstance().buscarListaPorProduto(idProduto)))) {
            listaReferencias.removeIf(ref -> Util.stringNullOrEmpty((String)ref.getReferenciaFornecedor()));
        }
        wrapper.setReferencias(listaReferencias);
        return wrapper;
    }
}

