/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.complemento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ComplementoProdutoFilial;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ComplementoProdutoFilialRN;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/complementos-produto"})
public class ComplementoProdutoCrudController
extends CrudController<ComplementoProdutoFilial, ComplementoProdutoFilialRN> {
    public ComplementoProdutoCrudController() {
        super((AbstractRegraNegocio)ComplementoProdutoFilialRN.getInstance(), ComplementoProdutoFilial::new);
        this.dependsOn("idProduto");
    }

    protected GridBuilder<ComplementoProdutoFilialRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 10, false));
        colunas.add(new ColunaSQL("idProduto", "idproduto", 10, false));
        colunas.add(new ColunaSQL("idFilial", "idFilial", 10, false));
        colunas.add(new ColunaSQL("codigo", "cod_filial", "C\u00f3digo Filial", 100, false, new String[]{"fk_compl_produtofilial_fili"}));
        colunas.add(new ColunaSQL("razaosocial", "filial", "Filial", 100, true, new String[]{"fk_compl_produtofilial_fili"}));
        colunas.add(new ColunaSQL("endereco", "Endere\u00e7o", 100, true));
        colunas.add(new ColunaSQL("quantidadeMinima", "Quantidade m\u00ednima", 15, true));
        colunas.add(new ColunaSQL("quantidadeMaxima", "Quantidade m\u00ednima", 15, true));
        return new GridBuilder(ComplementoProdutoFilialRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ComplementoProdutoFilial complementoProdutoFilial, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)complementoProdutoFilial.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WWW37", "Produto n\u00e3o informado.");
        }
        if (NumberUtil.longNullOuZero((Long)complementoProdutoFilial.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WWW38", "Filial n\u00e3o informada.");
        }
        if (StringUtil.stringNullOrEmpty((String)complementoProdutoFilial.getEndereco()) && NumberUtil.bigDecimalNullOrZero((BigDecimal)complementoProdutoFilial.getQuantidadeMinima()) && NumberUtil.bigDecimalNullOrZero((BigDecimal)complementoProdutoFilial.getQuantidadeMaxima())) {
            throw new UnicoMensagemUsuarioException("WPRD245", "Por favor determine as configura\u00e7\u00f5es para estoque.");
        }
        ComplementoProdutoFilial existente = ComplementoProdutoFilialRN.getInstance().buscarConfiguracaoEstoque(complementoProdutoFilial.getIdFilial(), complementoProdutoFilial.getIdProduto());
        if (existente.getId() != null && (NumberUtil.longNullOuZero((Long)complementoProdutoFilial.getId()) || !existente.getId().equals(complementoProdutoFilial.getId()))) {
            throw new UnicoMensagemUsuarioException("WPRD246", "Configura\u00e7\u00e3o j\u00e1 existente para essa filial.");
        }
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(registro -> {
            String codFilial = (String)registro[this.getIndexColuna("cod_filial", colunas)];
            String nomeFilial = (String)registro[this.getIndexColuna("filial", colunas)];
            registro[this.getIndexColuna((String)"filial", (List)colunas)] = codFilial + " - " + nomeFilial;
        });
    }

    protected String getCacheId() {
        return "complementos-produto";
    }
}

