/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.fornecedor;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ProdutoFornecedor;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoFornecedorRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import java.time.LocalDate;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/fornecedores-produto"})
public class ProdutoFornecedorCrudController
extends SimpleController {
    @RequestMapping(value={"/buscar-fornecedores-produto"})
    @DBAutoCommit
    public List<ProdutoFornecedor> buscarFornecedoresProduto(@RequestParam Long idProduto, @RequestParam(required=false) LocalDate inicio, @RequestParam(required=false) LocalDate fim) throws UnicoMensagemUsuarioException {
        return ProdutoFornecedorRN.getInstance().buscarListaPorProduto(idProduto, null, inicio, fim);
    }

    @RequestMapping(value={"/desvincular-referencia"}, method={RequestMethod.PUT})
    @DBTransaction
    public void desvincularReferencia(@RequestBody ProdutoFornecedor produtoFornecedor) throws UnicoMensagemUsuarioException {
        if (!Util.stringNullOrEmpty((String)produtoFornecedor.getReferenciaFornecedor())) {
            ProdutoFornecedorRN.getInstance().desvinculaReferenciaProdutoFornecedor(produtoFornecedor.getIdFornecedor(), produtoFornecedor.getReferenciaFornecedor());
        }
    }
}

