/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.numeroserie;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ProdutoNumeroSerie;
import br.intelidata.commons.domain.pojo.enuns.StatusProdutoNumeroSerie;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoNumeroSerieRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/numeros-serie"})
public class ProdutoNumeroSerieCrudController
extends CrudController<ProdutoNumeroSerie, ProdutoNumeroSerieRN> {
    public ProdutoNumeroSerieCrudController() {
        super((AbstractRegraNegocio)ProdutoNumeroSerieRN.getInstance(), ProdutoNumeroSerie::new);
    }

    @RequestMapping(value={"/filtrar-por-produto"})
    @DBAutoCommit
    public List<ProdutoNumeroSerie> buscaNumeroSerie(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        return ProdutoNumeroSerieRN.getInstance().buscarListaPorProdutoFilialLocalEstoque(idProduto, SessaoUtil.getSessao().getFilial().getId(), FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOCAL_ESTOQUE) ? SessaoUtil.getSessao().getUsuario().getIdLocalEstoqueTrabalho() : null, null, null);
    }

    @RequestMapping(value={"/filtrar-por-produto-estoque"})
    @DBAutoCommit
    public List<ProdutoNumeroSerie> buscaNumeroSerieEmEstoque(@RequestParam Long idProduto, @RequestParam(required=false) Long idLocalEstoque) {
        if (Util.longNullOuZero((Long)idLocalEstoque) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            idLocalEstoque = SessaoUtil.getSessao().getUsuario().getIdLocalEstoqueTrabalho();
        }
        return ProdutoNumeroSerieRN.getInstance().buscarListaPorProdutoFilialLocalEstoque(idProduto, SessaoUtil.getSessao().getIdFilial(), idLocalEstoque, null, StatusProdutoNumeroSerie.EM_ESTOQUE);
    }

    protected GridBuilder<ProdutoNumeroSerieRN> getGridBuilder() {
        return new GridBuilder(ProdutoNumeroSerieRN.getInstance().getTabela(), Collections.emptyList());
    }

    protected String getCacheId() {
        return "numeros-serie";
    }
}

