/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.variacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Grade;
import br.intelidata.commons.domain.pojo.GradeValor;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.SaldoEstoque;
import br.intelidata.commons.domain.pojo.SaldoLocalEstoque;
import br.intelidata.commons.domain.pojo.Variacao;
import br.intelidata.commons.domain.pojo.VariacaoDistribuida;
import br.intelidata.commons.domain.pojo.enuns.TipoVariacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.VariacaoCommonRN;
import br.intelidata.commons.modulo.estoque.regranegocio.MovimentoEstoqueRN;
import br.intelidata.commons.modulo.estoque.regranegocio.SaldoEstoqueRN;
import br.intelidata.commons.modulo.estoque.regranegocio.SaldoLocalEstoqueRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.variacao.VariacaoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/variacoes"})
public class VariacaoProdutoCrudController
extends SimpleCrudController<Grade, GradeRN> {
    private ResponseEntityService responseEntityService;

    @Autowired
    public VariacaoProdutoCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)GradeRN.getInstance());
        this.responseEntityService = responseEntityService;
    }

    @DBTransaction
    public Long create(@RequestBody Grade grade) throws UnicoMensagemUsuarioException {
        List linhas = grade.getValores().stream().filter(GradeValor::isSelecionado).collect(Collectors.toList());
        List colunas = grade.getColunas().stream().filter(GradeValor::isSelecionado).collect(Collectors.toList());
        this.gravarVariacao(grade, linhas, colunas);
        return grade.getIdGradeColuna();
    }

    @DBAutoCommit
    public Grade get(@RequestParam(required=false) Long parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)parentId)) {
            throw new UnicoMensagemUsuarioException("WWW100", "Por favor informe o produto");
        }
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(parentId);
        if (!(produto == null || NumberUtil.longNullOuZero((Long)produto.getIdGradeColuna()) && NumberUtil.longNullOuZero((Long)produto.getIdGradeLinha()))) {
            Grade grade = new Grade();
            grade.setIdProduto(produto.getId());
            grade.setIdGradeColuna(produto.getIdGradeColuna());
            grade.setIdGradeLinha(produto.getIdGradeLinha());
            grade.setInativa(!VariacaoRN.getInstance().isVariacaoAtiva(parentId));
            grade.setPossuiMovimentacao(MovimentoEstoqueRN.getInstance().isExisteMovimento(produto.getId()));
            return grade;
        }
        return new Grade();
    }

    @RequestMapping(value={"/informacoes-grade"})
    @DBAutoCommit
    public ResponseEntity<String> getInformacoesVariacao(@RequestParam Long idProduto) {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        boolean gradeAntiga = ProdutoRN.getInstance().isPossuiGradeAntiga(idProduto);
        boolean exibirLinha = true;
        Grade linha = null;
        Grade coluna = null;
        if (!gradeAntiga) {
            exibirLinha = this.isExibirComponenteLinha(idProduto);
            coluna = (Grade)GradeRN.getInstance().buscarPorId(produto.getIdGradeColuna());
            if (exibirLinha) {
                linha = (Grade)GradeRN.getInstance().buscarPorId(produto.getIdGradeLinha());
            }
        }
        String stringJson = "{\"coluna\":".concat(JsonUtil.escapeQuote((String)(coluna != null ? StringUtil.capitalizarString((String)coluna.getDescricao().toLowerCase()) : "Coluna"))).concat(", \"linha\":").concat(JsonUtil.escapeQuote((String)(linha != null ? StringUtil.capitalizarString((String)linha.getDescricao().toLowerCase()) : "Linha"))).concat(", \"exibirLinha\":").concat(exibirLinha ? "true" : "false").concat("}");
        return this.responseEntityService.createJSONResponse(stringJson);
    }

    @RequestMapping(value={"/montar-variacao"})
    @DBAutoCommit
    public ResponseEntity<String> montarVariacao(@RequestParam Long idProduto) {
        List variacoes;
        String stringJson = "";
        if (idProduto != null && (variacoes = VariacaoRN.getInstance().buscarListaPorIdProdutoTipo(idProduto, TipoVariacao.TIPO_VARIACAO)) != null && !variacoes.isEmpty()) {
            stringJson = variacoes.stream().map(variacao -> new StringBuilder("{\"variacao\":").append(variacao.getOrdem()).append(", \"descricao\":").append(JsonUtil.escapeQuote((String)variacao.getDescricao())).append("}")).collect(Collectors.joining(","));
        }
        return this.responseEntityService.createJSONResponse("[" + stringJson + "]");
    }

    @RequestMapping(value={"/saldo"})
    @DBAutoCommit
    public List<HashMap<String, Object>> buscarSaldoVariacao(@RequestParam Long idProduto, @RequestParam(required=false) Long idFilial, @RequestParam(required=false) Long idLocalEstoque, @RequestParam(required=false) boolean somenteVariacaoComSaldo) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        int casasDecimaisQuantidade = UnidademedidaRN.getInstance().getCasasDecimais(produto.getIdUnidadeMedida());
        List variacoes = VariacaoCommonRN.getInstance().buscarListaPorIdProdutoTipo(idProduto, TipoVariacao.TIPO_VARIACAO);
        Map<Integer, BigDecimal> mapVariacoes = idLocalEstoque != null ? SaldoLocalEstoqueRN.getInstance().buscarListaSaldoLocalEstoque(idFilial, idLocalEstoque, idProduto).stream().collect(Collectors.groupingBy(SaldoLocalEstoque::getVariacao, Collectors.mapping(SaldoLocalEstoque::getQuantidade, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : SaldoEstoqueRN.getInstance().getSaldoPorProduto(idFilial, idProduto).stream().collect(Collectors.groupingBy(SaldoEstoque::getVariacao, Collectors.mapping(SaldoEstoque::getQuantidade, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        ArrayList<HashMap<String, Object>> listaSaldoOriginal = new ArrayList<HashMap<String, Object>>();
        for (Variacao variacao : variacoes) {
            BigDecimal saldo = mapVariacoes.get(variacao.getOrdem());
            if (NumberUtil.bigDecimalNullOrZero((BigDecimal)saldo) && somenteVariacaoComSaldo) continue;
            if (saldo == null) {
                saldo = BigDecimal.ZERO;
            }
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("variacao", variacao.getDescricao());
            map2.put("saldo", saldo.setScale(casasDecimaisQuantidade, RoundingMode.HALF_EVEN));
            map2.put("codigoVaricao", variacao.getOrdem());
            map2.put("idGradeValorLinha", variacao.getIdGradeValorLinha());
            map2.put("idGradeValorColuna", variacao.getIdGradeValorColuna());
            BigDecimal saldoPrevisto = ProdutoRN.getInstance().getSaldoPrevistoEstoque(idFilial, idLocalEstoque, idProduto, variacao.getOrdem().intValue(), (List)null, null);
            map2.put("saldoPrevisto", saldoPrevisto.setScale(casasDecimaisQuantidade, RoundingMode.HALF_EVEN));
            map2.put("casasDecimais", casasDecimaisQuantidade);
            listaSaldoOriginal.add(map2);
        }
        listaSaldoOriginal.sort(Comparator.comparing(map -> map.get("variacao").toString()));
        return listaSaldoOriginal;
    }

    @RequestMapping(value={"/validar-variacao"})
    @DBAutoCommit
    public VariacaoWrapper validarGrade(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        if (produto.isKit()) {
            throw new UnicoMensagemUsuarioException("WPRD170", "O produto selecionado \u00e9 um kit. A grade n\u00e3o pode ser cadastrada.");
        }
        if (produto.isNumeroSerie()) {
            throw new UnicoMensagemUsuarioException("WPRD171", "Este produto j\u00e1 est\u00e1 marcado para utilizar n\u00famero de s\u00e9rie, e com isso, n\u00e3o ser\u00e1 permitido fazer a configura\u00e7\u00e3o da grade.");
        }
        if (MovimentoEstoqueRN.getInstance().isExisteMovimento(produto.getId()) && !VariacaoRN.getInstance().isVariacao(produto.getId()) && !produto.isPossuiVariacao()) {
            throw new UnicoMensagemUsuarioException("WPRD172", "Produto j\u00e1 possui movimenta\u00e7\u00e3o no estoque e/ou vendas. Opera\u00e7\u00e3o n\u00e3o permitida.");
        }
        int saldo = ProdutoRN.getInstance().getSaldoEstoque(SessaoUtil.getSessao(), SessaoUtil.getSessao().getFilial().getId(), idProduto).intValue();
        if (saldo < 0) {
            throw new UnicoMensagemUsuarioException("WPRD173", "N\u00e3o \u00e9 poss\u00edvel editar grade de produto quando o saldo de estoque for negativo.");
        }
        return new VariacaoWrapper(ProdutoRN.getInstance().isPossuiGradeAntiga(idProduto), !VariacaoRN.getInstance().isVariacaoAtiva(idProduto));
    }

    @RequestMapping(value={"/filtrar-por-produto-tipo"})
    @DBAutoCommit
    public List<Variacao> filtrarPorProdutoTipo(@RequestParam Long idProduto, @RequestParam TipoVariacao tipoVariacao) {
        return VariacaoRN.getInstance().getValuesAsyncSelectWeb(idProduto, tipoVariacao);
    }

    @RequestMapping(value={"/exibir-linha"})
    @DBAutoCommit
    public boolean isExibirComponenteLinha(@RequestParam Long idProduto) {
        List variacoes = VariacaoRN.getInstance().buscarListaPorIdProdutoTipo(idProduto, TipoVariacao.TIPO_LINHA);
        Long size = variacoes.stream().filter(variacao -> variacao.getDescricao().equals(" ") && variacao.getOrdem() == 1).count();
        return variacoes.size() != size.intValue();
    }

    @RequestMapping(value={"/variacao-to-list"})
    @DBAutoCommit
    public List<VariacaoDistribuida> stringToListVariacao(@RequestParam Long idProduto, @RequestParam(value="variacoes") String variacoesString) {
        ArrayList<VariacaoDistribuida> variacoesDistribuidas = new ArrayList<VariacaoDistribuida>();
        Map variacoes = VariacaoRN.getInstance().stringToMap(variacoesString);
        if (variacoes != null && !variacoes.isEmpty()) {
            List<Variacao> linhas = VariacaoRN.getInstance().buscarListaPorIdProduto(idProduto, TipoVariacao.TIPO_LINHA, true);
            if (!this.isExibirComponenteLinha(idProduto)) {
                linhas = Collections.singletonList(VariacaoRN.getInstance().buscarObjectoPorIdProdutoTipoOrdem(idProduto, TipoVariacao.TIPO_LINHA.getId(), Integer.valueOf(1), null));
            }
            List<Variacao> linhasConfig = linhas;
            List colunas = VariacaoRN.getInstance().buscarListaPorIdProduto(idProduto, TipoVariacao.TIPO_COLUNA, true);
            variacoes.forEach((key, value) -> {
                Optional<Variacao> filtroLinha = linhasConfig.stream().filter(linha -> colunas.stream().anyMatch(coluna -> (linha.getOrdem() - 1) * 100 + coluna.getOrdem() == key)).findFirst();
                Optional<Variacao> filtroColuna = colunas.stream().filter(coluna -> linhasConfig.stream().anyMatch(linha -> (linha.getOrdem() - 1) * 100 + coluna.getOrdem() == key)).findFirst();
                if (filtroLinha.isPresent() && filtroColuna.isPresent()) {
                    Variacao linha2 = filtroLinha.get();
                    Variacao coluna2 = filtroColuna.get();
                    VariacaoDistribuida variacaoDistribuida = new VariacaoDistribuida();
                    variacaoDistribuida.setDescricao(!StringUtil.stringNullOrEmpty((String)linha2.toString()) ? linha2 + "/" + coluna2 : coluna2.toString());
                    variacaoDistribuida.setIdGradeLinha(linha2.getId());
                    variacaoDistribuida.setIdGradeColuna(coluna2.getId());
                    variacaoDistribuida.setVariacao(key);
                    variacaoDistribuida.setQuantidade(value);
                    variacoesDistribuidas.add(variacaoDistribuida);
                }
            });
        }
        variacoesDistribuidas.sort(Comparator.comparing(VariacaoDistribuida::getDescricao));
        return variacoesDistribuidas;
    }

    @RequestMapping(value={"/variacao-ativa"})
    @DBAutoCommit
    public boolean isVariacaoAtiva(@RequestParam Long idProduto) {
        return VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(idProduto);
    }

    @RequestMapping(value={"/grade-valor-imagem"})
    @DBAutoCommit
    public List<GradeValor> buscarGradeValorImagem(@RequestParam Long idProduto) {
        ArrayList<GradeValor> listGradeValor = new ArrayList<GradeValor>();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        if (produto != null) {
            Grade gradeLinha;
            Grade gradeColuna = (Grade)GradeRN.getInstance().buscarPorId(produto.getIdGradeColuna());
            if (gradeColuna != null && gradeColuna.isUsarImagem()) {
                listGradeValor.addAll(GradeValorRN.getInstance().buscaPorIdGrade(gradeColuna.getId()));
            }
            if ((gradeLinha = (Grade)GradeRN.getInstance().buscarPorId(produto.getIdGradeLinha())) != null && gradeLinha.isUsarImagem()) {
                listGradeValor.addAll(GradeValorRN.getInstance().buscaPorIdGrade(gradeLinha.getId()));
            }
        }
        return listGradeValor;
    }

    private void gravarVariacao(Grade grade, List<GradeValor> linhas, List<GradeValor> colunas) throws UnicoMensagemUsuarioException {
        int modo;
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(grade.getIdProduto());
        int n = modo = !NumberUtil.longNullOuZero((Long)produto.getIdGradeColuna()) || !NumberUtil.longNullOuZero((Long)produto.getIdGradeLinha()) ? 1 : 0;
        if (!NumberUtil.longNullOuZero((Long)produto.getIdGradeColuna()) && Long.valueOf(colunas.size()).equals(colunas.stream().filter(GradeValor::isInativo).count())) {
            throw new UnicoMensagemUsuarioException("WPRD225", "N\u00e3o \u00e9 poss\u00edvel bloquear a venda para todas as colunas da grade.");
        }
        GradeValorRN.getInstance().validar(produto, grade.getIdGradeLinha(), grade.getIdGradeColuna(), linhas, colunas);
        produto.setIdGradeLinha(grade.getIdGradeLinha());
        produto.setIdGradeColuna(grade.getIdGradeColuna());
        produto.setPossuiVariacao(!NumberUtil.longNullOuZero((Long)grade.getIdGradeColuna()));
        VariacaoRN.getInstance().gravaVariacaoGradePadrao(SessaoUtil.getSessao(), produto, linhas, colunas, modo, grade.isInativa());
    }

    @RequestMapping(value={"/gerar-descricao"})
    @DBAutoCommit
    public String gerarDescricao(@RequestParam Long idProduto, @RequestParam String strVariacoes) {
        return VariacaoRN.getInstance().getDescricaoPorVariacoesQuantidade(idProduto, strVariacoes);
    }
}

