/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produtointegracaofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Ncm;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoTributacaoEstado;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.OrigemProduto;
import br.intelidata.commons.domain.pojo.enuns.TributacaoProduto;
import br.intelidata.commons.domain.pojo.integracao.RetornoIntegracaoFiscal;
import br.intelidata.commons.domain.pojo.integracao.RetornoIntegracaoFiscalProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.integracao.regranegocio.RetornoIntegracaoFiscalProdutoRN;
import br.intelidata.commons.modulo.integracao.regranegocio.RetornoIntegracaoFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.NcmRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoTributacaoEstadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/produto-integracao-fiscal"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarIntegracaoFiscal", NOME="Produtos do lote de integra\u00e7\u00e3o fiscal", ROTA="/notas-fiscais/lotes-integracao-fiscal/:idRetornoIntegracaoFiscal/produto-integracao-fiscal", PROGRAMA=1411, CUSTOM_ACTION=true)
public class ProdutoIntegracaoFiscalCrudController
extends CrudController<RetornoIntegracaoFiscalProduto, RetornoIntegracaoFiscalProdutoRN> {
    public ProdutoIntegracaoFiscalCrudController() {
        super((AbstractRegraNegocio)RetornoIntegracaoFiscalProdutoRN.getInstance(), RetornoIntegracaoFiscalProduto::new, true, true, false);
    }

    protected GridBuilder<RetornoIntegracaoFiscalProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idRetornoIntegracaoFiscal", "idRetornoIntegracaoFiscal", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoProduto", "C\u00f3digo", 0, true, new String[]{"fk_retintfisc_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeProduto", "Produto", 0, true, new String[]{"fk_retintfisc_produto"}));
        colunas.add(new ColunaSQL("produtoCadastrado", "Produto foi cadastrado", 0, true));
        colunas.add(new ColunaSQL("origem", "Origem", 0, true));
        colunas.add(new ColunaSQL("ncm", "NCM", 0, true));
        ColunaSQL colunaPossuiCampoDiferente = new ColunaSQL("possuiCampoDiferente", "Possui diferen\u00e7as", 0, true);
        colunaPossuiCampoDiferente.setVirtual(true);
        colunaPossuiCampoDiferente.setEstatico(true);
        colunas.add(colunaPossuiCampoDiferente);
        return new GridBuilder(RetornoIntegracaoFiscalProdutoRN.getInstance().getTabela(), colunas);
    }

    public List<Coluna> getColunasCustomizaveis() {
        return ((RetornoIntegracaoFiscalProdutoRN)this.rn).getColunaGridCustomizavel();
    }

    protected void beforeRead(RetornoIntegracaoFiscalProduto retornoIntegracaoFiscalProduto, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        boolean exibirCodigoCfop;
        Sessao sessao = SessaoUtil.getSessao();
        boolean bl = exibirCodigoCfop = sessao.getFilial().getParametroIntegracaoFiscal().getTipoIntegracaoFiscal().isRetornaCFOP() && sessao.getFilial().getParametroIntegracaoFiscal().isAtualizaCfopIntegracaoFiscal();
        if (!Util.longNullOuZero((Long)retornoIntegracaoFiscalProduto.getIdProduto())) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(retornoIntegracaoFiscalProduto.getIdProduto());
            if (produto != null) {
                Ncm ncm;
                ProdutoTributacaoEstado produtoTributacaoEstado = ProdutoTributacaoEstadoRN.getInstance().buscarPorProdutoFilialEstado(produto.getId(), SessaoUtil.getSessao().getIdFilial(), sessao.getFilial().getIdEstado());
                if (produtoTributacaoEstado != null && !Util.stringNullOrEmpty((String)produtoTributacaoEstado.getTributacao())) {
                    retornoIntegracaoFiscalProduto.setTributacaoPafAtual((TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)produtoTributacaoEstado.getTributacao()));
                    retornoIntegracaoFiscalProduto.setCstIcmsNfceAtual((CstICMS)EnumUtils.getPorId(CstICMS.class, (Object)produtoTributacaoEstado.getTributacaoEspecialNfceSat()));
                    retornoIntegracaoFiscalProduto.setAliquotaPafNfceAtual(produtoTributacaoEstado.getAliquota());
                    retornoIntegracaoFiscalProduto.setReducaoBasePafNfceAtual(produtoTributacaoEstado.getAliquotaReducaoIcmsNfceSat());
                    retornoIntegracaoFiscalProduto.setAliquotaFcpPafNfceAtual(produtoTributacaoEstado.getAliquotaFcp());
                } else {
                    retornoIntegracaoFiscalProduto.setTributacaoPafAtual((TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)produto.getTributacao()));
                    retornoIntegracaoFiscalProduto.setCstIcmsNfceAtual(produto.getTributacaoEspecialNfceSat());
                    retornoIntegracaoFiscalProduto.setAliquotaPafNfceAtual(produto.getAliquotaIcmsInterna());
                    retornoIntegracaoFiscalProduto.setReducaoBasePafNfceAtual(produto.getAliquotaReducaoIcmsNfceSat());
                    retornoIntegracaoFiscalProduto.setCsosnNfceAtual(produto.getTributacaoSN());
                    retornoIntegracaoFiscalProduto.setAliquotaFcpPafNfceAtual(produto.getAliquotaFcp());
                }
                if (!Util.longNullOuZero((Long)produto.getIdNcm()) && (ncm = (Ncm)NcmRN.getInstance().buscarPorId(produto.getIdNcm())) != null) {
                    retornoIntegracaoFiscalProduto.setNcmAtual(ncm.getCodigo());
                }
                retornoIntegracaoFiscalProduto.setOrigemAtual(produto.getOrigem());
                retornoIntegracaoFiscalProduto.setIdCestAtual(produto.getIdCest());
                retornoIntegracaoFiscalProduto.setCstIcmsNfeAtual(produto.getSituacaoTributaria());
                retornoIntegracaoFiscalProduto.setCstIcmsSnNfeAtual(produto.getSituacaoTributariaSN());
                retornoIntegracaoFiscalProduto.setAliquotaNfeAtual(produto.getAliquotaIcmsNf());
                retornoIntegracaoFiscalProduto.setAliquotaFcpNfeAtual(produto.getAliquotaFcpNf());
                retornoIntegracaoFiscalProduto.setReducaoBaseNfeAtual(produto.getPercentualReducaoICMS());
                retornoIntegracaoFiscalProduto.setPossuiFcpNfeAtual(produto.isPossuiAliquotaCombatePobreza());
                retornoIntegracaoFiscalProduto.setIdBeneficioFiscalNfceAtual(produto.getIdBeneficioFiscalOperacao());
                retornoIntegracaoFiscalProduto.setIdBeneficioFiscalNfeAtual(produto.getIdBeneficioFiscalNf());
                retornoIntegracaoFiscalProduto.setMotivoDesoneracaoIcmsNfceAtual(produto.getMotivoDesoneracaoIcms());
                retornoIntegracaoFiscalProduto.setMotivoDesoneracaoIcmsNfeAtual(produto.getMotivoDesoneracaoNf());
                retornoIntegracaoFiscalProduto.setExibirCodigoCFOP(exibirCodigoCfop);
                if (exibirCodigoCfop && produto.getIdCfopSaidaNfce() != null) {
                    String cfop = (String)NaturezaOperacaoRN.getInstance().buscarValorPorID(produto.getIdCfopSaidaNfce(), "codigo");
                    retornoIntegracaoFiscalProduto.setCodigoCfopSaidaAtual(cfop);
                }
                retornoIntegracaoFiscalProduto.setCstPisCofinsAtual(produto.getCstPis());
                retornoIntegracaoFiscalProduto.setAliquotaPisAtual(produto.getAliquotaPis());
                retornoIntegracaoFiscalProduto.setAliquotaCofinsAtual(produto.getAliquotaCofins());
                retornoIntegracaoFiscalProduto.setCstPisEntradaAtual(produto.getCstPisEntrada());
                retornoIntegracaoFiscalProduto.setAliquotaPisEntradaAtual(produto.getAliquotaPisEntrada());
                retornoIntegracaoFiscalProduto.setAliquotaCofinsEntradaAtual(produto.getAliquotaCofinsEntrada());
                retornoIntegracaoFiscalProduto.setCodigoProdutoIntegrador(produto.getCodigo());
                retornoIntegracaoFiscalProduto.setNomeProdutoIntegrador(produto.getNome());
                retornoIntegracaoFiscalProduto.setEanProdutoIntegrador(produto.getEan());
                retornoIntegracaoFiscalProduto.setIdReceitaSemContribuicaoAtual(produto.getIdReceitaSemContribuicao());
            }
            Optional<OrigemProduto> filtro = Arrays.stream(OrigemProduto.values()).filter(o -> o.getDescricao().equalsIgnoreCase(retornoIntegracaoFiscalProduto.getOrigem())).findFirst();
            filtro.ifPresent(arg_0 -> ((RetornoIntegracaoFiscalProduto)retornoIntegracaoFiscalProduto).setOrigemIntegracaoFiscal(arg_0));
            retornoIntegracaoFiscalProduto.setReducaoBaseNfe(retornoIntegracaoFiscalProduto.getReducaoBasePafNfce());
        }
        if (!Util.stringNullOrEmpty((String)retornoIntegracaoFiscalProduto.getNcm())) {
            retornoIntegracaoFiscalProduto.setNcm(retornoIntegracaoFiscalProduto.getNcm().replace(".", ""));
        }
    }

    @RequestMapping(value={"/filtrar-por-lote"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarProdutos(@RequestParam Long idRetornoIntegracaoFiscal) {
        List produtos = RetornoIntegracaoFiscalProdutoRN.getInstance().buscarListaProdutosPorRetornoIntegracao(idRetornoIntegracaoFiscal);
        return this.responseEntityService.createJSONResponse(JsonUtil.toJson((Object)produtos));
    }

    protected String getCacheId() {
        return "produto-integracao-fiscal";
    }

    @RequestMapping(value={"/atualizar-produtos"})
    @DBAutoCommit
    public void atualizarProdutos(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        RetornoIntegracaoFiscalProduto retornoProduto = (RetornoIntegracaoFiscalProduto)RetornoIntegracaoFiscalProdutoRN.getInstance().buscarPorId(idProduto);
        if (retornoProduto != null) {
            RetornoIntegracaoFiscal retornoIntegracaoFiscal = (RetornoIntegracaoFiscal)RetornoIntegracaoFiscalRN.getInstance().buscarPorId(retornoProduto.getIdRetornoIntegracaoFiscal());
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(retornoProduto.getIdProduto());
            RetornoIntegracaoFiscalRN.getInstance().aplicaAlteracaoProduto(SessaoUtil.getSessao(), retornoIntegracaoFiscal, retornoProduto, produto, true);
        }
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        for (Object[] registro : dados) {
            Long id = (Long)registro[this.getIndexColuna("id", colunas)];
            int idxColuna = this.getIndexColuna("possuiCampoDiferente", colunas);
            if (idxColuna <= -1) continue;
            String retorno = RetornoIntegracaoFiscalProdutoRN.getInstance().isProdutoDivergenteIntegracaoFiscal(SessaoUtil.getSessao(), id) ? "Sim" : "N\u00e3o";
            registro[idxColuna] = retorno;
        }
    }
}

