/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao.familia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.PromocaoFamilia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoFamiliaCommonRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoFamiliaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.BuscarDadosWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoReturnWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/promocoes-familia"})
public class PromocaoFamiliaCrudController
extends CrudController<PromocaoFamilia, PromocaoFamiliaRN> {
    @Autowired
    public PromocaoFamiliaCrudController() {
        super((AbstractRegraNegocio)PromocaoFamiliaRN.getInstance(), PromocaoFamilia::new);
        this.dependsOn("idPromocao");
    }

    @RequestMapping(value={"/validar-promocao"})
    @DBAutoCommit
    public boolean validarFamiliaPromocao(@RequestParam(value="idPromocao") Long idPromocao, @RequestParam(required=false, value="id") Long idFamiliaPromocao, @RequestParam(value="value") Long idFamilia) {
        boolean isValidar = idFamiliaPromocao == null || !((PromocaoFamilia)PromocaoFamiliaRN.getInstance().buscarPorId(idFamiliaPromocao)).getIdFamilia().equals(idFamilia);
        return !isValidar || idPromocao == null || idFamilia == null || PromocaoFamiliaRN.getInstance().buscaPorPromocaoFamilia(idPromocao, idFamilia) == null;
    }

    @RequestMapping(value={"/incluir"}, method={RequestMethod.POST})
    @DBTransaction
    public PromocaoReturnWrapper gravarDados(@RequestBody PromocaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Promocao promocao = wrapper.getPromocao();
        PromocaoFamilia promocaoFamilia = wrapper.getPromocaoFamilia();
        Long idPai = PromocaoCommonRN.getInstance().incluir(promocao, SessaoUtil.getSessao());
        promocaoFamilia.setIdPromocao(idPai);
        Long idFilho = PromocaoFamiliaCommonRN.getInstance().incluir((AbstractPojo)promocaoFamilia, SessaoUtil.getSessao());
        return new PromocaoReturnWrapper(idPai, idFilho);
    }

    @RequestMapping(value={"/buscar-produtos"})
    @DBAutoCommit
    public List<BuscarDadosWrapper> buscarProdutos(@RequestParam Long id) {
        return ProdutoRN.getInstance().getlistaProdutosNaPromocaoFamilia(id).stream().map(map -> new BuscarDadosWrapper((String)map.get("nome"), (String)map.get("codigo"))).collect(Collectors.toList());
    }

    protected GridBuilder<PromocaoFamiliaRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("idPromocao", "idPromocao", 0, false), new ColunaSQL("idFamilia", "idFamilia", 0, false), new ColunaSQL("nome", "nomeFamilia", "Fam\u00edlia", 40, true, new String[]{"fk_promocaofamilia_hie"}), new ColunaSQL("valor", "Valor", 40, true), new ColunaSQL("percentual", "Percentual", 50, true));
        return new GridBuilder(PromocaoFamiliaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeCreate(PromocaoFamilia promocaoFamilia, Optional<Long> parentId) {
        promocaoFamilia.setCodigoPromocao(PromocaoRN.getInstance().buscarPorId(promocaoFamilia.getIdPromocao()).getCodigo());
        promocaoFamilia.setFamilia(((FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(promocaoFamilia.getIdFamilia())).getCodigo());
    }

    protected void beforeUpdate(PromocaoFamilia promocaoFamilia, Optional<Long> parentId) {
        promocaoFamilia.setFamilia(((FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(promocaoFamilia.getIdFamilia())).getCodigo());
    }

    protected String getCacheId() {
        return "promocoes-familia";
    }
}

