/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao.filial;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.PromocaoFilial;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoFilialRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/promocoes-filial"})
public class PromocaoFilialCrudController
extends CrudController<PromocaoFilial, PromocaoFilialRN> {
    @Autowired
    public PromocaoFilialCrudController() {
        super((AbstractRegraNegocio)PromocaoFilialRN.getInstance(), PromocaoFilial::new);
        this.dependsOn("idPromocao");
    }

    @RequestMapping(value={"/validar-promocao"})
    @DBAutoCommit
    public boolean validarFilialPromocao(@RequestParam(value="idPromocao") Long idPromocao, @RequestParam(required=false, value="id") Long idFilialPromocao, @RequestParam(value="value") Long idFilial) {
        boolean isValidar = idFilialPromocao == null || !((PromocaoFilial)PromocaoFilialRN.getInstance().buscarPorId(idFilialPromocao)).getIdFilial().equals(idFilial);
        return !isValidar || idPromocao == null || idFilial == null || PromocaoFilialRN.getInstance().buscaPorPromocaoFilial(idPromocao, idFilial) == null;
    }

    protected GridBuilder<PromocaoFilialRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("nome", "nomeFilial", "Filial", 100, true, new String[]{"fk_promocaofilial_filial"}));
        return new GridBuilder(PromocaoFilialRN.getInstance().getTabela(), colunas);
    }

    protected void beforeCreate(PromocaoFilial promocaoFilial, Optional<Long> parentId) {
        promocaoFilial.setCodigo(PromocaoRN.getInstance().buscarPorId(promocaoFilial.getIdPromocao()).getCodigo());
        promocaoFilial.setFilial(((Filial)FilialRN.getInstance().buscarPorId(promocaoFilial.getIdFilial())).getCodigo());
    }

    protected void beforeUpdate(PromocaoFilial promocaoFilial, Optional<Long> parentId) {
        promocaoFilial.setFilial(((Filial)FilialRN.getInstance().buscarPorId(promocaoFilial.getIdFilial())).getCodigo());
    }

    protected String getCacheId() {
        return "promocoes-filial";
    }
}

