/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao.produto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPautaPreco;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.PromocaoProduto;
import br.intelidata.commons.domain.pojo.PromocaoVariacao;
import br.intelidata.commons.domain.pojo.Variacao;
import br.intelidata.commons.domain.pojo.enuns.TipoVariacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ProdutoPautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoProdutoCommonRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoVariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoReturnWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Component(value="promocoes-produto")
@RequestMapping(value={"/api/promocoes-produto"})
public class PromocaoProdutoCrudController
extends CrudController<PromocaoProduto, PromocaoProdutoRN>
implements ProdutoItemInterface<PromocaoProduto> {
    private final ResponseEntityService responseEntityService;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public PromocaoProdutoCrudController(ResponseEntityService responseEntityService, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)PromocaoProdutoRN.getInstance(), PromocaoProduto::new, true, false);
        this.responseEntityService = responseEntityService;
        this.funcionalidadeService = funcionalidadeService;
        this.dependsOn("idPromocao");
        this.setValidarCurrentTimeMillis(false);
    }

    @RequestMapping(value={"/validar-promocao"})
    @DBAutoCommit
    public boolean validarProdutoPromocao(@RequestParam(value="idPromocao") Long idPromocao, @RequestParam(required=false, value="id") Long idPromocaoProduto, @RequestParam(value="value") Long idProduto) {
        boolean validar = idPromocaoProduto == null || !((PromocaoProduto)PromocaoProdutoRN.getInstance().buscarPorId(idPromocaoProduto)).getIdProduto().equals(idProduto);
        return !validar || idProduto == null || idPromocao == null || PromocaoProdutoRN.getInstance().buscaPorProdutoPromocao(idProduto, idPromocao, false) == null;
    }

    @RequestMapping(value={"/busca-preco-casas-decimais-produto"})
    @DBAutoCommit
    public ResponseEntity<String> buscarPrecoCasasDecimais(@RequestParam(value="id") Long idProduto, @RequestParam(value="idPromocao") Long idPromocao) {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        Promocao promocao = PromocaoRN.getInstance().buscarPorId(idPromocao);
        int casasDecimais = 2;
        BigDecimal preco = BigDecimal.ZERO;
        if (promocao == null || produto == null) {
            preco = BigDecimal.ZERO;
        } else {
            if (!Util.longNullOuZero((Long)promocao.getTabelaPreco())) {
                if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
                    ProdutoPautaPreco produtoPautaPreco = ProdutoPautaPrecoRN.getInstance().buscarPorIdProdutoPauta(idProduto, SessaoUtil.getSessao().getIdFilial(), promocao.getTabelaPreco());
                    if (produtoPautaPreco != null) {
                        preco = produtoPautaPreco.getPreco();
                    }
                } else {
                    preco = (BigDecimal)BeanUtil.get((Object)produto, (String)("precoPauta" + promocao.getTabelaPreco()), (Object[])new Object[0]);
                }
            } else {
                preco = this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(SessaoUtil.getSessao(), produto.getId()).getPrecoVendaAjustado() : produto.getPreco();
            }
            casasDecimais = produto.getCasasDecimais();
        }
        String Json = "{\"casasDecimais\":".concat(String.valueOf(casasDecimais)).concat(", \"preco\":").concat(preco.toString()).concat("}");
        return this.responseEntityService.createJSONResponse(Json);
    }

    @RequestMapping(value={"/incluir"}, method={RequestMethod.POST})
    @DBTransaction
    public PromocaoReturnWrapper gravarDado(@RequestBody PromocaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Promocao promocao = wrapper.getPromocao();
        PromocaoProduto promoProduto = wrapper.getPromocaoProduto();
        Long idPai = Util.longNullOuZero((Long)promocao.getId()) ? PromocaoCommonRN.getInstance().incluir(promocao, sessao) : promocao.getId();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(promoProduto.getIdProduto());
        ArrayList<Object> listaProdutoPorFamilia = new ArrayList<Object>();
        if (!NumberUtil.longNullOuZero((Long)produto.getIdFamilia()) && wrapper.isIncluirProdutosFamilia()) {
            for (Object itemPro : ProdutoRN.getInstance().buscaListaPorFamilia(produto.getIdFamilia())) {
                if (!listaProdutoPorFamilia.stream().noneMatch(arg_0 -> PromocaoProdutoCrudController.lambda$gravarDado$0((Produto)itemPro, arg_0))) continue;
                listaProdutoPorFamilia.add(itemPro);
            }
        }
        Promocao promocaoAtual = PromocaoProdutoRN.getInstance().validaProdutoParaAdicionar(sessao, promocao, promoProduto, listaProdutoPorFamilia, promoProduto.getVariacoes());
        if (!NumberUtil.longNullOuZero((Long)promoProduto.getId())) {
            PromocaoProdutoCommonRN.getInstance().excluir(promoProduto, sessao);
        }
        if (!ListMapUtil.listNullOrEmpty((List)promocaoAtual.getProdutosPromocao())) {
            for (PromocaoProduto promocaoProduto : promocaoAtual.getProdutosPromocao()) {
                promocaoProduto.setIdPromocao(idPai);
                Long idFamiliaItem = (Long)ProdutoRN.getInstance().buscarValorPorID(promocaoProduto.getIdProduto(), "idfamilia");
                if (!Util.longNullOuZero((Long)idFamiliaItem)) {
                    promocaoProduto.setIdFamilia(idFamiliaItem);
                    promocaoProduto.setNomeFamilia((String)FamiliaProdutoRN.getInstance().buscarValorPorID(idFamiliaItem, "nome"));
                }
                PromocaoProdutoCommonRN.getInstance().incluir(promocaoProduto, sessao);
            }
            return new PromocaoReturnWrapper(idPai, null, promocaoAtual.getProdutosPromocao());
        }
        promoProduto.setIdPromocao(idPai);
        if (!Util.longNullOuZero((Long)produto.getIdFamilia())) {
            promoProduto.setIdFamilia(produto.getIdFamilia());
            promoProduto.setNomeFamilia((String)FamiliaProdutoRN.getInstance().buscarValorPorID(produto.getIdFamilia(), "nome"));
        }
        Long idFilho = PromocaoProdutoCommonRN.getInstance().incluir(promoProduto, sessao);
        return new PromocaoReturnWrapper(idPai, idFilho, Arrays.asList(promoProduto));
    }

    @RequestMapping(value={"/excluir"}, method={RequestMethod.POST})
    @DBTransaction
    public void excluir(@RequestBody Long idPromocaoProduto, @RequestParam boolean excluirPorFamilia) throws UnicoMensagemUsuarioException {
        PromocaoProduto promocaoProduto = (PromocaoProduto)PromocaoProdutoRN.getInstance().buscarPorId(idPromocaoProduto);
        if (excluirPorFamilia) {
            List produtos = PromocaoProdutoRN.getInstance().buscarProdutosPorIdPromocao(promocaoProduto.getIdPromocao());
            for (PromocaoProduto produto : produtos) {
                Long idFamiliaItem = (Long)ProdutoRN.getInstance().buscarValorPorID(produto.getIdProduto(), "idfamilia");
                if (idFamiliaItem == null || !idFamiliaItem.equals(promocaoProduto.getIdFamilia())) continue;
                PromocaoProdutoCommonRN.getInstance().excluir(produto, SessaoUtil.getSessao());
            }
        } else {
            PromocaoProdutoCommonRN.getInstance().excluir(promocaoProduto, SessaoUtil.getSessao());
        }
    }

    @RequestMapping(value={"/buscar-variacoes"})
    @DBAutoCommit
    public List<PromocaoVariacao> buscarVariacaoProdutoPromocao(@RequestParam Long idProduto) {
        ArrayList<PromocaoVariacao> variacoes = new ArrayList<PromocaoVariacao>();
        for (Variacao variacao : VariacaoRN.getInstance().buscarListaPorIdProdutoTipo(idProduto, TipoVariacao.TIPO_VARIACAO)) {
            PromocaoVariacao promocaoVariacao = new PromocaoVariacao();
            promocaoVariacao.setDescricao(variacao.getDescricao());
            promocaoVariacao.setVariacao(variacao.getOrdem());
            variacoes.add(promocaoVariacao);
        }
        return variacoes;
    }

    protected GridBuilder<PromocaoProdutoRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("idpromocao", "idPromocao", "IdPromocao", 0, false, new String[0]), new ColunaSQL("idProduto", "idProduto", "idProduto", 0, false, new String[0]), new ColunaSQL("codigo", "codigoProduto", "C\u00f3digo", 0, true, new String[]{"fk_promocaoproduto_produto"}), new ColunaSQL("nome", "nomeProduto", "Produto", 0, true, new String[]{"fk_promocaoproduto_produto"}), new ColunaSQL("valor", "Valor", 0, true), new ColunaSQL("percentual", "Percentual", 0, true), new ColunaSQL("quota", "Quota", 0, true));
        return new GridBuilder(PromocaoProdutoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeRead(PromocaoProduto promocaoProduto, int modo, Optional<Long> parentId) {
        promocaoProduto.setVariacoes(PromocaoVariacaoRN.getInstance().buscarListPorPromocaoProduto(promocaoProduto.getIdPromocao(), promocaoProduto.getIdProduto()));
    }

    protected void beforeSave(PromocaoProduto promocaoProduto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        promocaoProduto.setProduto(((Produto)ProdutoRN.getInstance().buscarPorId(promocaoProduto.getIdProduto())).getCodigo());
    }

    protected String getCacheId() {
        return "promocoes-produto";
    }

    public ProdutoItemWeb<PromocaoProduto> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Long pauta = 0L;
        if (parametros.containsKey((Object)"pauta")) {
            pauta = StringUtil.convertFirstValueMapToLong(parametros, (String)"pauta");
        }
        PromocaoProduto promocaoProduto = new PromocaoProduto();
        ProdutoItemWeb p = new ProdutoItemWeb();
        p.setItem((ItemWeb)promocaoProduto);
        p.setProduto(produto);
        p.setProdutoPreco(ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(SessaoUtil.getSessao().getFilial(), produto.getId(), pauta)));
        promocaoProduto.setValor(p.getProdutoPreco().getPreco());
        return p;
    }

    private static /* synthetic */ boolean lambda$gravarDado$0(Produto itemPro, Produto p) {
        return p.getId().equals(itemPro.getId());
    }
}

