/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.recalculocomissao;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.recalculocomissao.JobRecalculoComissao;
import br.intelidata.uniplusweb.web.rest.app.crud.recalculocomissao.RecalculoComissaoWrapper;
import java.time.temporal.Temporal;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/recalculo-comissao"})
@SubMenuMapping(MENU="SubMenuFinanceiroComissao", NOME="Rec\u00e1lculo das comiss\u00f5es de vendedores", ICONE="icon-imprimir", ROTA="/financeiros/recalculo-comissao", PROGRAMA=428)
public class RecalculoComissaoSimpleCrudController
extends SimpleController
implements ICreateTask {
    private final TaskManager taskManager;

    public RecalculoComissaoSimpleCrudController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.RECALCULO_COMISSAO;
    }

    public Class<? extends AbstractJob> job() {
        return JobRecalculoComissao.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/recalcular-comissao"}, method={RequestMethod.POST})
    @DBTransaction
    public void recalcularComissao(@RequestBody RecalculoComissaoWrapper comissaoWrapper) throws UnicoMensagemUsuarioException {
        String detalhe = "Recalculo per\u00edodo " + DateUtil.formataDataHora((Temporal)comissaoWrapper.getPeriodoInicial(), (String)"dd-MM-yyyy") + " at\u00e9 " + DateUtil.formataDataHora((Temporal)comissaoWrapper.getPeriodoFinal(), (String)"dd-MM-yyyy");
        if (!NumberUtil.longNullOuZero((Long)comissaoWrapper.getIdVendedor())) {
            Entidade vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(comissaoWrapper.getIdVendedor());
            detalhe = detalhe + " - vendedor: " + vendedor.getNome();
        }
        this.createTask((Object)comissaoWrapper, detalhe);
    }
}

