/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.reducaoz;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ReducaoZCorrigirGTAux;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoArquivoBlocoX;
import br.intelidata.commons.domain.pojo.pafecf.ReducaoZ;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.ReducaoZRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.reducaoz.CorrecaoReducaoZWrapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reducoes-z"})
@SubMenuMapping(MENU="SubMenuPdvFiscal", NOME="Redu\u00e7\u00f5es Z", ROTA="/pdvs/reducoes-z", PROGRAMA=214, ICONE="icon icon-cupom-fiscal")
public class ReducaoZCrudController
extends CrudController<ReducaoZ, ReducaoZRN> {
    private final ResponseEntityService responseEntityService;

    @Autowired
    public ReducaoZCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)ReducaoZRN.getInstance(), ReducaoZ::new, true, true);
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/correcoes-reducao-z"})
    @DBAutoCommit
    public ReducaoZCorrigirGTAux buscaListaReducaoZCorrigirGT(@RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal, @RequestParam(required=false) Integer crzInicial, @RequestParam(required=false) Integer crzFinal, @RequestParam(required=false) String ecf) {
        return ReducaoZRN.getInstance().buscaListaReducaoZCorrigirGT(SessaoUtil.getSessao(), dataInicial, dataFinal, crzInicial, crzFinal, ecf);
    }

    @RequestMapping(value={"/imprimir-advertencias"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirAdvertencias(@RequestBody List<String> advertencias) throws UnicoMensagemUsuarioException {
        String titulo = "Relat\u00f3rio de Cr\u00edticas Bloco X - " + TipoArquivoBlocoX.REDUCAOZ;
        UViewer rel = new UViewer(SaidaRelatorio.TEXTO_FORMATADO, titulo, new int[]{100});
        rel.inicioRelatorio();
        rel.escreveTexto("Advert\u00eancias");
        for (String linha : advertencias) {
            rel.inicioLinha();
            rel.escreveColuna(linha);
            rel.fimLinha();
        }
        rel.saltaLinha();
        rel.saltaLinha();
        rel.fimRelatorio();
        byte[] arquivo = rel.getRemessa().getMalote().extrai("text");
        return this.responseEntityService.createTXTResponse(arquivo, "Relat\u00f3rio de Cr\u00edticas Bloco X");
    }

    @PostMapping(value={"/corrigir"})
    @DBTransaction
    public void corrigirGTCrz(@RequestBody CorrecaoReducaoZWrapper correcaoWrapper) throws UnicoMensagemUsuarioException {
        if (correcaoWrapper.isCrescente()) {
            ReducaoZRN.getInstance().corrigeGTCrzCrescente(SessaoUtil.getSessao(), correcaoWrapper.getCrzInicial(), correcaoWrapper.getCrzFinal(), correcaoWrapper.getEcf(), correcaoWrapper.getValorCalculo());
        } else {
            ReducaoZRN.getInstance().corrigeGTCrzDecrescente(SessaoUtil.getSessao(), correcaoWrapper.getCrzInicial(), correcaoWrapper.getCrzFinal(), correcaoWrapper.getEcf(), correcaoWrapper.getValorCalculo());
        }
    }

    protected GridBuilder<ReducaoZRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("filial", "filial", 0, false));
        colunas.add(new ColunaSQL("registroImportado", "registroImportado", 0, false));
        colunas.add(new ColunaSQL("versaoAtualSistemaEcf", "versaoAtualSistemaEcf", 0, false));
        colunas.add(new ColunaSQL("pdv", "PDV", 0, true));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("numeroSerie", "N\u00famero s\u00e9rie", 0, true));
        colunas.add(new ColunaSQL("cooInicial", "Coo inicial", 0, true));
        colunas.add(new ColunaSQL("cooFinal", "Coo final", 0, true));
        ColunaSQL colunaTotalBruto = new ColunaSQL("vendaBruta", "Venda bruta", 0, true);
        colunaTotalBruto.setTotalizar(true);
        colunas.add(colunaTotalBruto);
        colunas.add(new ColunaSQL("crz", "Crz", 0, true));
        colunas.add(new ColunaSQL("cro", "Cro", 0, true));
        GridBuilder grid = new GridBuilder(ReducaoZRN.getInstance().getTabela(), colunas);
        grid.setCondicaoDefault(new Condicao("filial", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        grid.setOrdemDefault(new Ordem("data", true));
        return new GridBuilder(ReducaoZRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ReducaoZ reducaoZ, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        reducaoZ.setFilial(SessaoUtil.getSessao().getFilial().getCodigo());
        reducaoZ.setEmpresa(SessaoUtil.getSessao().getFilial().getCodigo());
        super.beforeSave((AbstractPojo)reducaoZ, parentId);
    }

    protected String getCacheId() {
        return "reducoes-z".concat("_").concat("_FILIAL=(").concat(SessaoUtil.getSessao().getCodigoFilial()).concat(")");
    }
}

