/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.relatorio.relatorioireport;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.TipoRelatorioIReport;
import br.intelidata.commons.domain.pojo.enuns.LocalizacaoRelatorioWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.SubRelatorioConfiguradoWeb;
import br.intelidata.commons.modulo.ferramentas.regranegocio.RelatorioConfiguradoWebRN;
import br.intelidata.commons.modulo.ferramentas.regranegocio.SubRelatorioConfiguradoWebRN;
import br.intelidata.commons.modulo.geradorrelatorio.regranegocio.RelatorioParametroRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ValidarIReportInterface;
import br.intelidata.uniplusweb.web.rest.app.crud.relatorio.RelatorioCrudController;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/relatorios-ireport"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Gerador de relat\u00f3rios", ROTA="/relatorios-configurados-module/relatorios-ireport", PROGRAMA=515, ICONE="icon-ascii")
public class RelatorioIReportCrudController
extends RelatorioCrudController
implements ValidarIReportInterface {
    public RelatorioIReportCrudController() {
        super(false, false);
    }

    @RequestMapping(value={"/importar-relatorio"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarRelatorio(@RequestPart(value="file") MultipartFile arquivo) throws UnicoMensagemUsuarioException {
        try (ObjectInputStream objLeitura = new ObjectInputStream(arquivo.getInputStream());){
            RelatorioConfiguradoWeb relatorio = (RelatorioConfiguradoWeb)objLeitura.readObject();
            relatorio.setId(null);
            relatorio.setIreport(true);
            relatorio.setCodigo(RelatorioConfiguradoWebRN.getInstance().getCodigoUnicoLong(SessaoUtil.getSessao()).toString());
            this.create((AbstractPojo)relatorio, Optional.empty());
        }
        catch (ClassNotFoundException ex) {
            throw new UnicoMensagemUsuarioException("WWW314", "Classe do relat\u00f3rio n\u00e3o encontrada");
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("WWW315", "Arquivo de importa\u00e7\u00e3o n\u00e3o corresponde ao formato de relat\u00f3rio exportado pelo sistema.");
        }
    }

    @RequestMapping(value={"/importar-jrxml"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarJrxml(@RequestPart(value="files") MultipartFile[] jrxml, @RequestPart(value="localizacao") LocalizacaoRelatorioWeb localizacao) throws UnicoMensagemUsuarioException {
        List listaIReport = this.validarArquivoIReport(Arrays.asList(jrxml));
        try {
            String nome;
            RelatorioConfiguradoWeb relatorio = new RelatorioConfiguradoWeb();
            relatorio.setCodigo(RelatorioConfiguradoWebRN.getInstance().getCodigoUnicoLong(SessaoUtil.getSessao()).toString());
            MultipartFile principal = ((ValidarIReportInterface.ArquivoIReport)listaIReport.get(0)).getFile();
            String string = nome = !StringUtil.stringNullOrEmpty((String)principal.getOriginalFilename()) ? principal.getOriginalFilename() : principal.getName();
            if (StringUtil.stringNullOrEmpty((String)nome)) {
                nome = "Relat\u00f3rio sem nome";
            }
            relatorio.setDescricao(StringUtil.capitalizarString((String)nome.toLowerCase()).replace(".jrxml", ""));
            relatorio.setBytesRelatorio(principal.getBytes());
            relatorio.setIreport(true);
            relatorio.setLocalizacao(localizacao);
            List parametrosJR = JRXmlLoader.load((InputStream)principal.getInputStream()).getParametersList();
            parametrosJR.removeIf(p -> p.isSystemDefined() || p.getName().toLowerCase().startsWith("subreport_"));
            List parametros = RelatorioConfiguradoWebRN.getInstance().converterParametrosJRXML(RelatorioParametroRN.getInstance().getRelatorioParametroWeb(parametrosJR));
            String json = "{\"parametros\":".concat(JsonUtil.toJson((Object)parametros)).concat("}");
            relatorio.setRelatorioSerializado(json);
            if (listaIReport.size() > 1) {
                ArrayList<SubRelatorioConfiguradoWeb> subs = new ArrayList<SubRelatorioConfiguradoWeb>();
                for (ValidarIReportInterface.ArquivoIReport ir : listaIReport) {
                    if (!ir.getTipo().equals((Object)TipoRelatorioIReport.SUB_RELATORIO)) continue;
                    SubRelatorioConfiguradoWeb subRelatorioConfiguradoWeb = new SubRelatorioConfiguradoWeb();
                    subRelatorioConfiguradoWeb.setDescricao(ir.getFile().getOriginalFilename());
                    subRelatorioConfiguradoWeb.setParametro(ir.getParametro());
                    subRelatorioConfiguradoWeb.setBytesRelatorio(ir.getFile().getBytes());
                    subs.add(subRelatorioConfiguradoWeb);
                }
                relatorio.setListaSubRelatorio(subs);
            }
            this.create((AbstractPojo)relatorio, Optional.empty());
        }
        catch (IOException | JRException ex) {
            throw new UnicoMensagemUsuarioException("WWW316", "Arquivo de importa\u00e7\u00e3o n\u00e3o corresponde ao formato de relat\u00f3rio exportado pelo sistema.");
        }
    }

    protected void beforeUpdate(RelatorioConfiguradoWeb relatorio, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        relatorio.setListaSubRelatorio(SubRelatorioConfiguradoWebRN.getInstance().buscarPorIdRelatorio(relatorio.getId()));
    }

    @RequestMapping(value={"/exportar-relatorio"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> exportarRelatorio(@RequestBody Long idRelatorio) throws UnicoMensagemUsuarioException {
        RelatorioConfiguradoWeb relatorio = (RelatorioConfiguradoWeb)RelatorioConfiguradoWebRN.getInstance().buscarPorId(idRelatorio);
        if (relatorio == null) {
            throw new UnicoMensagemUsuarioException("WWW317", "Relat\u00f3rio n\u00e3o encontrado");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(relatorio);
            baos.close();
        }
        catch (IOException ex) {
            throw new UnicoException("WWW318", "N\u00e3o foi poss\u00edvel exportar o relat\u00f3rio.", (Throwable)ex);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + relatorio.getDescricao() + ".obj");
        return new ResponseEntity((Object)baos.toByteArray(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/exportar-jrxml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> exportarJrxml(@RequestBody Long idRelatorio) throws UnicoMensagemUsuarioException {
        RelatorioConfiguradoWeb relatorio = (RelatorioConfiguradoWeb)RelatorioConfiguradoWebRN.getInstance().buscarPorId(idRelatorio);
        if (relatorio == null) {
            throw new UnicoMensagemUsuarioException("WWW319", "Relat\u00f3rio n\u00e3o encontrado.");
        }
        if (relatorio.getBytesRelatorio() == null) {
            throw new UnicoMensagemUsuarioException("WWW320", "O relat\u00f3rio n\u00e3o possui JRXML anexado.");
        }
        HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
        mapArquivos.put(relatorio.getDescricao() + ".jrxml", relatorio.getBytesRelatorio());
        List subs = SubRelatorioConfiguradoWebRN.getInstance().buscarPorIdRelatorio(relatorio.getId());
        if (!ListMapUtil.listNullOrEmpty((List)subs)) {
            for (SubRelatorioConfiguradoWeb sub : subs) {
                mapArquivos.put(sub.getDescricao(), sub.getBytesRelatorio());
            }
        }
        if (mapArquivos.size() > 1) {
            File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Arquivos iReport");
            return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Arquivos iReport");
        }
        return this.responseEntityService.createFileResponse((byte[])mapArquivos.values().toArray()[0], MediaType.APPLICATION_OCTET_STREAM, mapArquivos.keySet().toArray()[0].toString());
    }

    protected GridBuilder<RelatorioConfiguradoWebRN> getGridBuilder() {
        GridBuilder grid = new GridBuilder(RelatorioConfiguradoWebRN.getInstance().getTabela(), this.getColunas(), "relatorio-irepo");
        grid.addReferenciaDefault(new Referencia("ireport"));
        grid.addCodicaoDefault(new Condicao("ireport", Operador.IGUAL, EnumSimNao.SIM.getId().intValue()));
        return grid;
    }

    protected void beforeSave(RelatorioConfiguradoWeb relatorioConfiguradoWeb, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)relatorioConfiguradoWeb, parentId);
        relatorioConfiguradoWeb.setIreport(true);
    }

    protected String getCacheId() {
        return "relatorios-ireport";
    }
}

