/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.scanntech.acaomanual;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoScanntechCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.download.BuscaPromocaoScanntech;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.download.RetornoProcessamentoPromocaoScanntech;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/acao-manual"})
@SubMenuMapping(MENU="SubMenuScanntech", ICONE="icon-gravar", NOME="A\u00e7\u00e3o manual", ROTA="/cadastros/acao-manual", PROGRAMA=6003)
public class ScanntechAcaoManualController {
    @RequestMapping(value={"/atualizar-promocoes"})
    @DBAutoCommit
    public ResponseEntity<byte[]> atualizarPromocoes(@RequestBody List<Long> idFiliais) throws UnicoMensagemUsuarioException {
        List filiais = FilialRN.getInstance().getFiliais(idFiliais);
        RetornoProcessamentoPromocaoScanntech retorno = new BuscaPromocaoScanntech(SessaoUtil.getSessaoSistema(), ConfiguracaoScanntechCommonRN.getInstance().buscarConfiguracaoValida()).acaoManual(filiais);
        if (retorno != null && retorno.getRelatorio() != null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Access-Control-Expose-Headers", "Content-Disposition");
            responseHeaders.add("Content-Disposition", "attachment;filename=promocoes.pdf");
            responseHeaders.add("Access-Control-Expose-Headers", "Status-Processamento");
            responseHeaders.add("Status-Processamento", String.valueOf(retorno.isProcessamentoOk()));
            responseHeaders.setContentType(MediaType.APPLICATION_PDF);
            Malote malote = retorno.getRelatorio().getRemessa().getMalote();
            return new ResponseEntity((Object)malote.extrai("pdf"), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        return null;
    }
}

