/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.scanntech.errosenvio;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.ProcessamentoScanntech;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.GridControleVisaoRN;
import br.intelidata.commons.domain.regranegocio.ProcessamentoScanntechRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processamento-scanntech"})
@SubMenuMapping(MENU="SubMenuScanntech", NOME="Processamentos", ROTA="/cadastros/processamento-scanntech", PROGRAMA=6002)
public class ScanntechProcessamentoCrudController
extends CrudController<ProcessamentoScanntech, ProcessamentoScanntechRN> {
    @Autowired
    public ScanntechProcessamentoCrudController() {
        super((AbstractRegraNegocio)ProcessamentoScanntechRN.getInstance(), ProcessamentoScanntech::new);
    }

    protected String getCacheId() {
        return "processamento-scanntech";
    }

    protected GridBuilder<GridControleVisaoRN> getGridBuilder() {
        GridBuilder grid = new GridBuilder("processamento_scanntech_view", ((ProcessamentoScanntechRN)this.rn).getColunasPadraoGrid(), "processamento_scanntechVW_web");
        grid.setCondicoes(((ProcessamentoScanntechRN)this.rn).getCondicoesPadraoGrid());
        grid.setOrdensDefault(((ProcessamentoScanntechRN)this.rn).getOrdenacoesPadraoGrid());
        return grid;
    }

    @RequestMapping(value={"reprocessar"})
    @DBAutoCommit
    public void reprocessar(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        for (Long id : ids) {
            ProcessamentoScanntechRN.getInstance().reprocessar(id, sessao);
        }
    }
}

