/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.seguranca.accesslog;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.AccessLog;
import br.intelidata.commons.domain.pojo.enuns.AccessLogStatus;
import br.intelidata.commons.domain.pojo.enuns.AccessLogType;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AccessLogRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/access-logs"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliarSeguranca", NOME="Logs de acesso", ICONE="icon-funcoes-auxiliares", ROTA="/cadastros/access-logs", PROGRAMA=1505)
public class AccessLogCrudController
extends CrudController<AccessLog, AccessLogRN> {
    public AccessLogCrudController() {
        super((AbstractRegraNegocio)AccessLogRN.getInstance(), AccessLog::new);
    }

    protected String getCacheId() {
        return "access-logs";
    }

    protected GridBuilder<AccessLogRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idusuario", "idusuario", 0, false));
        colunas.add(new ColunaSQL("usuario", "Usu\u00e1rio", 0, true));
        colunas.add(new ColunaSQL("datahora", "Data/hora", 0, true));
        colunas.add(new ColunaSQL("ip", "IP", 0, true));
        colunas.add(new ColunaSQL("navegador", "Navegador", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 100, true, AccessLogStatus.class));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 200, true));
        GridBuilder grid = new GridBuilder(AccessLogRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("tipo"));
        grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, AccessLogType.UNIPLUS_WEB.getId().intValue()));
        grid.addOrdem(new Ordem("datahora", true));
        return grid;
    }
}

