/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.seguranca.usuario;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.AccessLogStatus;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/usuarios-bloqueados"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarUsuario", NOME="Usu\u00e1rios bloqueados", ROTA="/cadastros/usuarios-bloqueados", PROGRAMA=1469)
public class UsuarioBloqueadoCrudController
extends CrudController<Usuario, UsuarioRN> {
    public UsuarioBloqueadoCrudController() {
        super((AbstractRegraNegocio)UsuarioRN.getInstance(), Usuario::new);
    }

    @RequestMapping(value={"/desbloquear"}, method={RequestMethod.POST})
    @DBTransaction
    public void desbloquear(@RequestBody Long idUsuario) throws UnicoMensagemUsuarioException {
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(idUsuario);
        if (usuario == null) {
            throw new UnicoMensagemUsuarioException("WWW467", "Usu\u00e1rio n\u00e3o encontrado.");
        }
        usuario.setBloqueado(EnumSimNao.NAO.getId().intValue());
        usuario.setTentativasAcesso(0);
        usuario.setDataHoraDesbloqueio(null);
        UsuarioRN.getInstance().alterar(usuario, SessaoUtil.getSessao());
    }

    protected String getCacheId() {
        return "usuarios-bloqueados";
    }

    protected GridBuilder<UsuarioRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("bloqueado", "Bloqueado", 0, false, EnumSimNao.class));
        ColunaSQL obs = new ColunaSQL("observacaobloqueio", "obsBloqueio", "obsBloqueio", 0, false, new String[0]);
        obs.setClasseEnum(AccessLogStatus.class);
        colunas.add(obs);
        colunas.add(new ColunaSQL("datahoradesbloqueio", "dataHora", "Data/hora desbloqueio", 0, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("nome", "nomePerfil", "Perfil", 0, true, new String[]{"fk_usuario_perfil"}));
        colunas.add(new ColunaSQL("supervisor", "Supervisor", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("inativo", "Inativo", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("email", "Email", 0, false));
        ColunaSQL colunaBloqueado = new ColunaSQL("bloqueado", "usuarioBloqueado", "Bloqueado", 0, true, new String[0]);
        colunaBloqueado.setClasseEnum(EnumSimNao.class);
        colunas.add(colunaBloqueado);
        colunas.add(new ColunaSQL("datahoradesbloqueio", "datahoradesbloqueio", "Data/hora desbloqueio tempor\u00e1rio", 0, true, new String[0]));
        colunas.add(new ColunaSQL("observacaobloqueio", "Motivo do bloqueio", 0, true, AccessLogStatus.class));
        GridBuilder grid = new GridBuilder(UsuarioRN.getInstance().getTabela(), colunas, "usuario_bloqueio");
        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        grid.addCodicaoDefault(new Condicao("bloqueado", Operador.IGUAL, 1));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        grid.addCodicaoDefault(new Condicao("dataHora", Operador.IS_NOT_NULL));
        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        return grid;
    }
}

