/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tributacaonacionaliss;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.TributacaoNacionalISS;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoPlanoContas;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.TributacaoNacionalISSRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tributacao-nacional-iss"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Tributa\u00e7\u00f5es nacionais de ISSQN", ROTA="/notas-fiscais/tributacao-nacional-iss", PROGRAMA=1000081)
public class TributacaoNacionalISSCrudController
extends CrudController<TributacaoNacionalISS, TributacaoNacionalISSRN> {
    public TributacaoNacionalISSCrudController() {
        super((AbstractRegraNegocio)TributacaoNacionalISSRN.getInstance(), TributacaoNacionalISS::new, true, false);
    }

    protected GridBuilder<TributacaoNacionalISSRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTributacaoPai", "idTributacaoPai", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigodefault", "ID", 0, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(TributacaoNacionalISSRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("codigodefault"));
        return grid;
    }

    @RequestMapping(value={"/dados-tree"})
    @DBAutoCommit
    public List<TributacaoNacionalISS> buscarDadosTree(@RequestParam(required=false) boolean apenasAtivos, @RequestParam(required=false) TipoMovimentoPlanoContas tipoMovimento) {
        return TributacaoNacionalISSRN.getInstance().buscarLista();
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<TributacaoNacionalISS> combo() {
        return TributacaoNacionalISSRN.getInstance().getComboWeb();
    }

    @RequestMapping(value={"/nome/{id}"})
    @DBAutoCommit
    public TributacaoNacionalISS getNome(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        return (TributacaoNacionalISS)TributacaoNacionalISSRN.getInstance().buscarPorId(id);
    }

    protected void beforeCreate(TributacaoNacionalISS tributacaoNacionalISS, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        TributacaoNacionalISS tributacaoPai = !NumberUtil.longNullOuZero((Long)tributacaoNacionalISS.getIdTributacaoPai()) ? (TributacaoNacionalISS)TributacaoNacionalISSRN.getInstance().buscarPorId(tributacaoNacionalISS.getIdTributacaoPai()) : null;
        TributacaoNacionalISSRN.getInstance().validarCodigo(tributacaoNacionalISS.getCodigo(), tributacaoPai);
    }

    protected String getCacheId() {
        return "tributacao-nacional-iss";
    }
}

