/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.unichef.grupo;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.GrupoProdutoUnichef;
import br.intelidata.commons.domain.pojo.Hierarquia;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.modulo.produto.regranegocio.GrupoProdutoUnichefRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupos-produto-unichef"})
@SubMenuMapping(MENU="SubMenuGourmetGeral", NOME="Grupos de produto do gourmet", ROTA="/unichefs/grupos-produto-unichef", ICONE="icon icon-trabalharcom", PROGRAMA=1000040)
public class GrupoProdutoUnichefCrudController
extends HierarquiaCrudController<GrupoProdutoUnichef, GrupoProdutoUnichefRN> {
    public GrupoProdutoUnichefCrudController() {
        super((HierarquiaRN)GrupoProdutoUnichefRN.getInstance(), GrupoProdutoUnichef::new, true, TipoArquivoArmazenado.GruposProdutoUnichef);
    }

    protected String getCacheId() {
        return "grupos-produto-unichef";
    }

    protected GridBuilder<GrupoProdutoUnichefRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        this.addColunaNivel(colunas);
        for (ColunaSQL colunaSQL : colunas) {
            Coluna coluna = GrupoProdutoUnichefRN.getInstance().buscarColuna(GrupoProdutoUnichefRN.getInstance().getTabela(), colunaSQL.getNome());
            if (coluna == null) continue;
            colunaSQL.setClasseValor(coluna.getClasseDado());
        }
        GridBuilder grid = new GridBuilder(GrupoProdutoUnichefRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected void beforeRead(GrupoProdutoUnichef grupo, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)grupo.getCaminhoIcone())) {
            grupo.setCaminhoIcone(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.GruposProdutoUnichef, TipoImagem.Icone, grupo.getCaminhoIcone()));
        }
    }

    protected void beforeUpdate(GrupoProdutoUnichef grupo, Optional<Long> parentId) {
        String caminhoIconeOriginal = ((GrupoProdutoUnichef)GrupoProdutoUnichefRN.getInstance().buscarPorId(grupo.getId())).getCaminhoIcone();
        if (!StringUtil.stringNullOrEmpty((String)caminhoIconeOriginal)) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.GruposProdutoUnichef, TipoImagem.Icone, caminhoIconeOriginal);
            if (StringUtil.stringNullOrEmpty((String)grupo.getCaminhoIcone()) || !grupo.getCaminhoIcone().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.GruposProdutoUnichef, caminhoIconeOriginal);
            } else {
                grupo.setCaminhoIcone(caminhoIconeOriginal);
            }
        }
    }

    protected void beforeDelete(GrupoProdutoUnichef grupo) {
        if (!StringUtil.stringNullOrEmpty((String)grupo.getCaminhoIcone())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.GruposProdutoUnichef, grupo.getCaminhoIcone());
        }
    }

    protected void beforeCreate(GrupoProdutoUnichef entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (entity.getCodigo().length() > 12) {
            throw new UnicoMensagemUsuarioException("UCF221", "N\u00e3o \u00e9 poss\u00edvel adicionar mais um subgrupo. S\u00e3o permitidos apenas dois n\u00edveis.");
        }
        super.beforeCreate((AbstractPojo)entity, parentId);
    }

    @RequestMapping(value={"/importar-grupo"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarGrupo(@RequestBody(required=true) Long idGrupoOrigem) throws UnicoMensagemUsuarioException {
        Hierarquia grupoOrigem = (Hierarquia)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(idGrupoOrigem);
        if (grupoOrigem == null) {
            throw new UnicoMensagemUsuarioException("UCF222", "Grupo de origem n\u00e3o encontrado para importar");
        }
        if (grupoOrigem.getCodigo().length() != 6) {
            throw new UnicoMensagemUsuarioException("UCF223", "S\u00f3 \u00e9 poss\u00edvel importar grupo pai.");
        }
        GrupoProdutoUnichefRN.getInstance().importarGrupoDoUnico(grupoOrigem, SessaoUtil.getSessao());
    }
}

