/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.unichef.parametrosintegracaoifood;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ParametroIntegracaoIfood;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.ifood.regranegocio.TokenIfoodRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.time.LocalDateTime;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import unichef.integracao.client.UnichefIntegracaoRequestException;
import unichef.integracao.ifood.IFoodLog;
import unichef.integracao.ifood.client.IfoodHttpsClient;
import unichef.integracao.ifood.jsonv2.Token;
import unichef.integracao.ifood.jsonv2.UserCode;

@RestController
@RequestMapping(value={"/api/parametros-integracao-ifood"})
@SubMenuMapping(MENU="SubMenuGourmetAuxiliar", NOME="Par\u00e2metros de integra\u00e7\u00e3o iFood", ROTA="/unichefs/parametros-integracao-ifood", ICONE="icon icon-trabalharcom", PROGRAMA=1124)
public class ParametrosIntegracaoIfoodCrudComponent
extends SimpleCrudController<ParametroIntegracaoIfood, FilialRN> {
    private IfoodHttpsClient ifoodClient = new IfoodHttpsClient(IFoodLog.INT_FIS);

    public ParametrosIntegracaoIfoodCrudComponent() {
        super((AbstractRegraNegocio)FilialRN.getInstance());
    }

    @DBAutoCommit
    public ParametroIntegracaoIfood get(Long parentId) {
        ParametroIntegracaoIfood param = SessaoUtil.getSessao().getFilial().getParametroIntegracaoIfood();
        return param;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroIntegracaoIfood entity) throws UnicoMensagemUsuarioException {
        int modo = 1;
        Filial filial = SessaoUtil.getSessao().getFilial();
        filial.setParametroIntegracaoIfood(entity);
        FilialRN.getInstance().gravar(modo, filial, SessaoUtil.getSessao());
        return filial.getId();
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/user-code"})
    @DBAutoCommit
    public UserCode userCode() {
        return this.ifoodClient.userCode();
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/conceder-acesso"})
    @DBAutoCommit
    public void concederAcesso(@RequestBody UserCode userCode) throws UnicoMensagemUsuarioException {
        try {
            Token novoToken = this.ifoodClient.token(userCode.authorizationCode, userCode.authorizationCodeVerifier);
            LocalDateTime dataGeracaoToken = DataHoraFactory.getDataHora();
            Sessao sessao = SessaoUtil.getSessao();
            TokenIfoodRN.getInstance().persistirToken(novoToken, dataGeracaoToken, sessao);
        }
        catch (UnichefIntegracaoRequestException ex) {
            throw new UnicoMensagemUsuarioException("IFOOD86", ex.getLocalizedMessage());
        }
    }
}

