/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao;

import br.intelidata.api.b2c.delivery.melhorenvio.MelhorEnvioConfiguracao;
import br.intelidata.api.b2c.delivery.melhorenvio.MelhorEnvioService;
import br.intelidata.api.b2c.delivery.melhorenvio.wrappers.Services;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.b2c.ConfiguracaoShop;
import br.intelidata.commons.domain.pojo.enuns.b2c.TipoPedido;
import br.intelidata.commons.domain.pojo.enuns.b2c.WebHookTipoIntegracao;
import br.intelidata.commons.domain.pojo.pafecf.AdministradoraCartao;
import br.intelidata.commons.domain.regranegocio.b2c.ConfiguracaoShopRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdministradoraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.Profile;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao.AbstractConfiguracaoUniplusShop;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao.ConfiguracaoArquivosShopRN;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracoes-uniplusshop"})
@SubMenuMapping(MENU="SubMenuUniplusShopAuxiliar", ICONE="icon-gear", NOME="Configura\u00e7\u00e3o", ROTA="/uniplusshop/configuracoes-uniplusshop", PROGRAMA=9002)
public class ConfiguracaoShopSimpleController
extends AbstractConfiguracaoUniplusShop {
    private final MelhorEnvioService melhorEnvioService;
    private final Profile profile;

    public ConfiguracaoShopSimpleController(MelhorEnvioService melhorEnvioService, Profile profile) {
        this.melhorEnvioService = melhorEnvioService;
        this.profile = profile;
    }

    public void beforeSave(ConfiguracaoShop configuracaoShop) throws UnicoMensagemUsuarioException {
        AdministradoraCartao administradoraCartao;
        if (configuracaoShop.getTipoIntegracaoEntrega() != null) {
            configuracaoShop.setTipoIntegracaoEntrega(null);
        }
        if (!WebHookTipoIntegracao.SEM_INTEGRACAO.equals((Object)configuracaoShop.getPayment_type()) && ((administradoraCartao = (AdministradoraCartao)AdministradoraCartaoRN.getInstance().buscarPorId(configuracaoShop.getIdAdministradora())) == null || NumberUtil.longNullOuZero((Long)administradoraCartao.getIdEntidade()))) {
            throw new UnicoMensagemUsuarioException("WWW585", "Por favor informe o cliente na administradora de cart\u00e3o.");
        }
        if (TipoPedido.PEDIDO_VENDA.equals((Object)configuracaoShop.getTipoPedido()) && !FinalizadorRN.getInstance().existeFinalizadorShop()) {
            throw new UnicoMensagemUsuarioException("WWW593", "Por favor configure os finalizadores para Uniplus Shop.");
        }
    }

    public void afterSave(ConfiguracaoShop configuracaoShop) throws UnicoMensagemUsuarioException {
        if (this.profile.isProd() || this.profile.isAWS()) {
            new ConfiguracaoArquivosShopRN().salvarConfiguracoes(configuracaoShop);
        }
    }

    @GetMapping(value={"/buscar-services"})
    @DBTransaction
    public List<Services> buscarListaServices() {
        ConfiguracaoShop configuracaoShop = ConfiguracaoShopRN.getInstance().buscarConfiguracao();
        MelhorEnvioConfiguracao configuracao = new MelhorEnvioConfiguracao(configuracaoShop.getTokenMelhorEnvio(), configuracaoShop.getEmail(), configuracaoShop.isHomologationMelhorEnvio(), configuracaoShop.getServicos(), configuracaoShop.isInformarValorSegurado());
        return this.melhorEnvioService.buscarTransportadoras(configuracao);
    }
}

