/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao.sincronizacao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.DadosLicencaUniplusShop;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.FeedGoogle;
import br.intelidata.commons.domain.pojo.b2c.ConfiguracaoShop;
import br.intelidata.commons.domain.pojo.b2c.ProdutoResumido;
import br.intelidata.commons.domain.regranegocio.b2c.ConfiguracaoShopRN;
import br.intelidata.commons.domain.regranegocio.b2c.ProdutoResumidoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.uniplusshop.googlemerchant.CabecalhoFeed;
import br.intelidata.commons.modulo.uniplusshop.googlemerchant.ItemFeed;
import br.intelidata.commons.modulo.uniplusshop.googlemerchant.RSSFeedWriter;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.core.service.ApiCacheService;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao.AbstractConfiguracaoUniplusShop;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao.sincronizacao.SincronizacaoShopSimpleController;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sincronizacao-shop"})
@SubMenuMapping(MENU="SubMenuUniplusShopGeral", ICONE="icon-existe-atualizacao", NOME="Sincroniza\u00e7\u00e3o", ROTA="/uniplusshop/sincronizacao-shop", PROGRAMA=9012)
public class SincronizacaoShopSimpleController
extends AbstractConfiguracaoUniplusShop {
    private final TaskManager taskManager;
    private final ApiCacheService apiCacheService;
    private final ResponseEntityService responseEntityService;

    @Autowired
    public SincronizacaoShopSimpleController(TaskManager taskManager, ApiCacheService apiCacheService, ResponseEntityService responseEntityService) {
        this.taskManager = taskManager;
        this.apiCacheService = apiCacheService;
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/sincronizar"}, method={RequestMethod.POST})
    @DBTransaction
    public void sincronizar() throws UnicoMensagemUsuarioException {
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        task.createTask((Object)"");
    }

    @RequestMapping(value={"/gerar_xml"})
    @DBTransaction
    public ResponseEntity<byte[]> getxml() throws UnicoMensagemUsuarioException {
        DadosLicencaUniplusShop dadosShop = this.apiCacheService.getDadosLicenca(ContextoHolder.getTenant()).getDadosLicencaUniplusShop();
        if (dadosShop == null) {
            return null;
        }
        Sessao sessao = SessaoUtil.getSessao();
        ConfiguracaoShop configuracaoShop = ConfiguracaoShopRN.getInstance().buscarConfiguracao();
        CabecalhoFeed cabecalhoFeed = new CabecalhoFeed();
        cabecalhoFeed.setFilial(sessao.getFilial().getNome());
        cabecalhoFeed.setLink(configuracaoShop.getDominio());
        cabecalhoFeed.setDescricao(configuracaoShop.getName());
        List produtosResumidos = ProdutoResumidoRN.getInstance().buscarListaPorIdFilial(sessao.getIdFilial(), dadosShop.getQuantidadeProdutos());
        int[] count = new int[]{0};
        List itens = produtosResumidos.stream().filter(ProdutoResumido::isEnviarFeed).map(produtoResumido -> {
            count[0] = count[0] + 1;
            FeedGoogle feedGoogle = ProdutoRN.getInstance().buscarFeedGooglePorIdProduto(produtoResumido.getIdProduto());
            ItemFeed item = new ItemFeed();
            item.setCodigo(produtoResumido.getCodigo());
            item.setTitulo(produtoResumido.getNome());
            if (!StringUtil.stringNullOrEmpty((String)produtoResumido.getDescricao())) {
                item.setDescricao(produtoResumido.getDescricao());
            } else {
                item.setDescricao(produtoResumido.getNome());
            }
            item.setLink(configuracaoShop.getDominio().replace("www.", "") + "/products/" + this.montarUrl(produtoResumido));
            String imagem = (String)ProdutoRN.getInstance().buscarCaminhoImagemIconeWeb(produtoResumido.getIdProduto()).get("imagem");
            if (StringUtil.stringNullOrEmpty((String)imagem) && !StringUtil.stringNullOrEmpty((String)produtoResumido.getEan())) {
                long code = Long.parseLong(produtoResumido.getEan(), 13);
                imagem = "https://uniplusshop-placeholder.s3.amazonaws.com/" + code + "_380.jpg";
            }
            item.setLinkImagem(imagem);
            item.setDisponibilidade("in stock");
            item.setPreco(produtoResumido.getPreco().setScale(2, RoundingMode.HALF_EVEN) + " BRL");
            item.setMarca("");
            item.setEan(produtoResumido.getEan());
            if (!NumberUtil.longNullOuZero((Long)produtoResumido.getIdGrupoGoogle())) {
                item.setCategoria(produtoResumido.getIdGrupoGoogle());
            }
            if (feedGoogle == null) {
                return item;
            }
            if (feedGoogle.isAdulto()) {
                item.setConteudoAdulto("yes");
            }
            if (feedGoogle.getGrupo() != null) {
                item.setGrupoIdade(feedGoogle.getGrupo().getValor_original());
            }
            if (feedGoogle.getGeneroFeed() != null) {
                item.setGenero(feedGoogle.getGeneroFeed().getValor_original());
            }
            item.setTamanho(feedGoogle.getTamanho());
            item.setCor(feedGoogle.getCor());
            return item;
        }).collect(Collectors.toList());
        cabecalhoFeed.setItem(itens);
        if (count[0] == 0) {
            throw new UnicoMensagemUsuarioException("WWW681", "Nenhum produto configurado para o google merchant, verifique o cadastro de produtos e fa\u00e7a a sincroniza\u00e7\u00e3o novamente");
        }
        RSSFeedWriter rssFeed = new RSSFeedWriter((Object)cabecalhoFeed);
        return this.responseEntityService.createXMLResponse(rssFeed.write(), "produtos");
    }

    private String montarUrl(ProdutoResumido produtoResumido) {
        try {
            long id = Long.parseLong(Long.toString(produtoResumido.getIdProduto()), 36);
            return URLEncoder.encode(Util.removerAcentos((String)produtoResumido.getNome()), "UTF-8").toLowerCase().replace("+", "-").concat("-").concat(Long.toString(id));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    static /* synthetic */ TaskManager access$000(SincronizacaoShopSimpleController x0) {
        return x0.taskManager;
    }
}

