/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.cupomdesconto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.b2c.CupomShop;
import br.intelidata.commons.domain.pojo.enuns.b2c.StatusCupomShop;
import br.intelidata.commons.domain.pojo.enuns.b2c.TipoDescontoCupom;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.b2c.CupomShopRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cupons"})
@SubMenuMapping(MENU="SubMenuUniplusShopGeral", ICONE="icon-orcamento", NOME="Cupons", ROTA="/uniplusshop/cupons", PROGRAMA=9015)
public class CupomShopCrudController
extends CrudController<CupomShop, CupomShopRN> {
    public CupomShopCrudController() {
        super((AbstractRegraNegocio)CupomShopRN.getInstance(), CupomShop::new);
    }

    protected void beforeRead(CupomShop cupomShop, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Dav dav;
        if (cupomShop.getStatus().equals((Object)StatusCupomShop.UTILIZADO) && (dav = DavRN.getInstance().buscarPorIdCupom(cupomShop.getId())) != null) {
            cupomShop.setDataUtilizacao(dav.getData());
            cupomShop.setPedido(dav.getCodigo().toString());
        }
    }

    protected String getCacheId() {
        return "cupons";
    }

    protected GridBuilder<CupomShopRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("cupom", "Cupom", 0, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true, TipoDescontoCupom.class));
        colunas.add(new ColunaSQL("desconto", "Desconto", 0, true));
        colunas.add(new ColunaSQL("validade", "Validade", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true, StatusCupomShop.class));
        return new GridBuilder(CupomShopRN.getInstance().getTabela(), colunas);
    }
}

