/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.entrega;

import br.intelidata.api.b2c.delivery.FreteService;
import br.intelidata.api.b2c.delivery.base.ConfiguracaoFrete;
import br.intelidata.api.b2c.delivery.base.Cotacao;
import br.intelidata.api.b2c.delivery.base.CotacaoItem;
import br.intelidata.api.b2c.delivery.base.FreteCarrinho;
import br.intelidata.api.b2c.delivery.melhorenvio.MelhorEnvioConfiguracao;
import br.intelidata.api.b2c.delivery.melhorenvio.MelhorEnvioCotacao;
import br.intelidata.api.b2c.delivery.melhorenvio.wrappers.Shipment;
import br.intelidata.api.b2c.delivery.melhorenvio.wrappers.ShipmentCart;
import br.intelidata.api.b2c.delivery.melhorenvio.wrappers.ShipmentCartReturn;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.b2c.ConfiguracaoShop;
import br.intelidata.commons.domain.pojo.b2c.PedidoEntrega;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.b2c.TipoEntrega;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalOrigem;
import br.intelidata.commons.domain.regranegocio.b2c.ConfiguracaoShopRN;
import br.intelidata.commons.domain.regranegocio.b2c.PedidoEntregaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.CidadeRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalOrigemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.uniplusshop.TextoEmailDefaultShop;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.entrega.DadosEnvio;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/melhor-envio"})
public class MelhorEnvioSimpleController {
    private final FreteService<Cotacao<MelhorEnvioCotacao, MelhorEnvioConfiguracao>> freteService;
    private final TaskManager taskManager;

    public MelhorEnvioSimpleController(FreteService<Cotacao<MelhorEnvioCotacao, MelhorEnvioConfiguracao>> freteService, TaskManager taskManager) {
        this.freteService = freteService;
        this.taskManager = taskManager;
    }

    @GetMapping(value={"{idPedido}"})
    @DBAutoCommit
    public DadosEnvio buscarDados(@PathVariable Long idPedido) throws UnicoMensagemUsuarioException {
        this.verificarNotaFiscal(idPedido);
        PedidoEntrega pedidoEntrega = this.getPedidoEntrega(idPedido);
        Shipment shipment = (Shipment)JsonUtil.fromJson((String)pedidoEntrega.getConsultaOriginal(), Shipment.class);
        return new DadosEnvio(shipment != null ? shipment.getPackages() : Collections.emptyList(), pedidoEntrega);
    }

    @PostMapping(value={"{idPedido}"})
    @DBAutoCommit
    public void despachar(@PathVariable Long idPedido) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(this.verificarNotaFiscal(idPedido));
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(idPedido);
        PedidoEntrega pedidoEntrega = this.getPedidoEntrega(idPedido);
        Shipment shipment = (Shipment)JsonUtil.fromJson((String)pedidoEntrega.getConsultaOriginal(), Shipment.class);
        if (shipment == null) {
            throw new UnicoMensagemUsuarioException("WWW653", "N\u00e3o foi poss\u00edvel determinar as configura\u00e7\u00f5es de entrega.");
        }
        Sessao sessao = SessaoUtil.getSessao();
        ConfiguracaoShop configuracao = ConfiguracaoShopRN.getInstance().buscarConfiguracao();
        MelhorEnvioConfiguracao melhorEnvioConfiguracao = new MelhorEnvioConfiguracao(configuracao.getTokenMelhorEnvio(), configuracao.getEmail(), configuracao.isHomologationMelhorEnvio(), configuracao.getServicos(), configuracao.isInformarValorSegurado());
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        Cidade cidade = (Cidade)CidadeRN.getInstance().buscarPorId(filial.getIdCidade());
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(filial.getIdEstado());
        ShipmentCart shipmentCart = new ShipmentCart();
        shipmentCart.setShipment(shipment);
        shipmentCart.setService(pedidoEntrega.getIdFrete());
        shipmentCart.setEmpresa(configuracao.getName());
        shipmentCart.setTelefoneEmpresa(configuracao.getPhone());
        shipmentCart.setEmailEmpresa(configuracao.getEmail());
        shipmentCart.setCnpjEmpresa(filial.getCnpj());
        shipmentCart.setInscricaoEstadualEmpresa(filial.getInscricaoEstadual());
        shipmentCart.setEnderecoEmpresa(filial.getEndereco());
        shipmentCart.setComplementoEndereceoEmpresa(filial.getComplemento());
        shipmentCart.setNumeroEnderecoEmpresa(filial.getNumero());
        shipmentCart.setBairroEmpresa(filial.getBairro());
        shipmentCart.setCidadeEmpresa(cidade.getNome());
        shipmentCart.setEstadoEmpresa(estado.getCodigo());
        shipmentCart.setCepEmpresa(filial.getCep());
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdEntidade());
        shipmentCart.setCliente(entidade.getNome());
        shipmentCart.setTelefoneCliente(notaFiscal.getCelularEntrega());
        shipmentCart.setEmailCliente(entidade.getEmail());
        String cpfCnpj = Util.apenasNumeros((String)notaFiscal.getCnpjCpfEntrega());
        if (Util.stringNullOrEmpty((String)cpfCnpj)) {
            cpfCnpj = Util.apenasNumeros((String)notaFiscal.getCnpjCpf());
        }
        shipmentCart.setCfpCnpjCliente(cpfCnpj);
        shipmentCart.setInscricaoEstadualCliente(notaFiscal.getInscricaoEstadual());
        shipmentCart.setEnderecoCliente(notaFiscal.getEnderecoEntrega());
        shipmentCart.setComplementoEnderecoCliente(notaFiscal.getComplementoEntrega());
        shipmentCart.setNumeroEnderecoCliente(notaFiscal.getNumeroEnderecoEntrega());
        shipmentCart.setBairroCliente(notaFiscal.getBairroEntrega());
        shipmentCart.setCidadeCliente(((Cidade)CidadeRN.getInstance().buscarPorId(notaFiscal.getIdCidadeEntrega())).getNome());
        shipmentCart.setEstadoCliente(((Estado)EstadoRN.getInstance().buscarPorId(notaFiscal.getIdEstado())).getCodigo());
        shipmentCart.setCepCliente(notaFiscal.getCepEntrega());
        shipmentCart.setItems(NotaFiscalItemRN.getInstance().buscarListaByIdNotaFiscal(notaFiscal.getId()).stream().map(i -> new CotacaoItem(i.getDescricao(), i.getQuantidade().multiply(i.getFatorConversao()), i.getPrecoUnitario())).collect(Collectors.toList()));
        shipmentCart.setValorAssegurado(notaFiscal.getTotalProduto());
        shipmentCart.setChaveNfe(notaFiscal.getChaveNfe());
        shipmentCart.setNumeroNfe(notaFiscal.getNumeroNotaFiscal());
        shipmentCart.setTag(pedido.getCodigo().toString());
        shipmentCart.setUrl(configuracao.getDominio() + "/account/orders/" + pedido.getId());
        ShipmentCartReturn retorno = (ShipmentCartReturn)this.freteService.confirmarFrete((ConfiguracaoFrete)melhorEnvioConfiguracao, (FreteCarrinho)shipmentCart);
        if (retorno != null) {
            pedidoEntrega.setCodigoEnvio(retorno.getProtocolo());
            pedidoEntrega.setPedidoCarrinho(retorno.getBody());
            PedidoEntregaRN.getInstance().alterar((AbstractPojo)pedidoEntrega, sessao);
        }
        pedido.setDespachoMelhorEnvio(true);
        pedido.setStatus(StatusDAV.PEDIDO_ENVIADO);
        pedido.setDataHoraDespacho(DataHoraFactory.getDataHora());
        PedidoRN.getInstance().alterar((AbstractPojo)pedido, sessao);
        if (!Util.stringNullOrEmpty((String)entidade.getEmail())) {
            TextoGenerico textoGenerico = TextoEmailDefaultShop.replaceEnvioPedido((Pedido)pedido);
            ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)SessaoUtil.getSessao(), (String)entidade.getEmail(), null, (String)textoGenerico.getAssunto(), (String)textoGenerico.getTexto());
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Envio de mercadoria");
            taskEmail.createTask((Object)parametrosEmailWeb, parametrosEmailWeb.getAssunto());
        }
    }

    private Long verificarNotaFiscal(Long idPedido) throws UnicoMensagemUsuarioException {
        List origens = NotaFiscalOrigemRN.getInstance().buscaNotasFiscaisOrigemPorIdOrigem(idPedido, 18);
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(idPedido);
        if (pedido != null) {
            this.getPedidoEntrega(idPedido);
            if (pedido.isDespachoMelhorEnvio()) {
                throw new UnicoMensagemUsuarioException("WWW654", "O pedido j\u00e1 enviado ao Melhor Envio.");
            }
            return ((NotaFiscalOrigem)origens.get(0)).getIdNotaFiscal();
        }
        throw new UnicoMensagemUsuarioException("WWW642", "Pedido n\u00e3o localizado.");
    }

    private PedidoEntrega getPedidoEntrega(Long idPedido) throws UnicoMensagemUsuarioException {
        PedidoEntrega pedidoEntrega = PedidoEntregaRN.getInstance().buscarPorIdPedido(idPedido);
        if (pedidoEntrega != null) {
            if (!pedidoEntrega.getTipo().equals((Object)TipoEntrega.MELHOR_ENVIO)) {
                throw new UnicoMensagemUsuarioException("WWW643", "N\u00e3o ser\u00e1 utilizado 'Melhor Envio' para essa entrega. Consulte o modo de entrega.");
            }
            return pedidoEntrega;
        }
        throw new UnicoMensagemUsuarioException("WWW644", "N\u00e3o foi localizado nenhuma informa\u00e7\u00e3o referente a entrega.");
    }
}

