/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.entrega;

import br.intelidata.api.b2c.service.FreteShopService;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.b2c.ConfiguracaoShop;
import br.intelidata.commons.domain.pojo.b2c.ItemFrete;
import br.intelidata.commons.domain.pojo.b2c.OpcaoEntrega;
import br.intelidata.commons.domain.regranegocio.b2c.ConfiguracaoShopRN;
import br.intelidata.commons.eventos.ProcessamentoFreteInterface;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/simular-frete"})
@SubMenuMapping(MENU="SubMenuUniplusShopAuxiliar", ICONE="icon-box", NOME="Simulador de frete", ROTA="/uniplusshop/simular-frete", PROGRAMA=9018)
public class SimuladorFreteSimpleController
implements ProcessamentoFreteInterface {
    private final NotificationService notificationService;
    private final FreteShopService freteShopService;

    public SimuladorFreteSimpleController(NotificationService notificationService, FreteShopService freteShopService) {
        this.notificationService = notificationService;
        this.freteShopService = freteShopService;
    }

    @GetMapping(value={"{idProduto}"})
    @DBAutoCommit
    public List<OpcaoEntrega> consultarFrete(@PathVariable Long idProduto, @RequestParam String cepEntrega, @RequestParam(required=false, defaultValue="1") BigDecimal quantidade) throws UnicoMensagemUsuarioException {
        ConfiguracaoShop configuracaoShop = ConfiguracaoShopRN.getInstance().buscarConfiguracao();
        if (!configuracaoShop.isIntegracaoCorreio()) {
            throw new UnicoMensagemUsuarioException("WWW655", "Habilite a integra\u00e7\u00e3o com os Correios para prosseguir com a simula\u00e7\u00e3o.");
        }
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        this.validarDadosProduto(produto);
        Sessao sessao = SessaoUtil.getSessao();
        ItemFrete itemFrete = new ItemFrete(produto.getId(), quantidade, ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(sessao.getFilial(), idProduto, Long.valueOf(0L))).getPreco(), produto.getAlturaShop(), produto.getLarguraShop(), produto.getComprimentoShop(), produto.getPesoShop(), produto.getTipoEmbalagemShop());
        List formasEntrega = this.freteShopService.calculaFrete(sessao, Collections.singletonList(itemFrete), sessao.getFilial(), configuracaoShop, cepEntrega, false, (ProcessamentoFreteInterface)this);
        this.addMensagem("Processo de consulta de frete finalizado.");
        return formasEntrega;
    }

    private void validarDadosProduto(Produto produto) throws UnicoMensagemUsuarioException {
        String msg = null;
        if (produto == null) {
            msg = "Produto n\u00e3o encontrado.";
        } else if (NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPesoShop())) {
            msg = "Configure o peso do produto.";
        } else if (NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getAlturaShop())) {
            msg = "Configure a altura do produto.";
        } else if (NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getLarguraShop())) {
            msg = "Configure a largura do produto.";
        } else if (NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getComprimentoShop())) {
            msg = "Configure o comprimento do produto.";
        }
        if (msg != null) {
            throw new UnicoMensagemUsuarioException("WWW640", msg);
        }
    }

    public void addMensagem(String mensagem) {
        this.notificationService.notifyUserNow(NotificationType.CONSULTA_FRETE, (Object)mensagem);
    }
}

