/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.faleconosco;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.b2c.FaleConosco;
import br.intelidata.commons.domain.pojo.enuns.b2c.StatusFaleConosco;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.b2c.FaleConoscoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/fale-conosco"})
@SubMenuMapping(MENU="SubMenuUniplusShopGeral", ICONE="icon-tecnico", NOME="Fale conosco", ROTA="/uniplusshop/fale-conosco", PROGRAMA=9005)
public class FaleConoscoCrudController
extends CrudController<FaleConosco, FaleConoscoRN> {
    public FaleConoscoCrudController() {
        super((AbstractRegraNegocio)FaleConoscoRN.getInstance(), FaleConosco::new);
    }

    @RequestMapping(value={"/respondido"})
    @DBTransaction
    public void marcarComoRespondido(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        FaleConosco faleConosco = (FaleConosco)FaleConoscoRN.getInstance().buscarPorId(id);
        if (faleConosco != null) {
            faleConosco.setStatus(StatusFaleConosco.RESPONDIDO);
            FaleConoscoRN.getInstance().alterar((AbstractPojo)faleConosco, SessaoUtil.getSessao());
        }
    }

    protected String getCacheId() {
        return "fale-conosco";
    }

    protected GridBuilder<FaleConoscoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("email", "E-mail", 0, true));
        colunas.add(new ColunaSQL("whatsapp", "WhatsApp", 0, true));
        colunas.add(new ColunaSQL("mensagem", "Mensagem", 0, true));
        colunas.add(new ColunaSQL("datahora", "Data e hora", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true, StatusFaleConosco.class));
        return new GridBuilder(FaleConoscoRN.getInstance().getTabela(), colunas);
    }
}

