/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.grupo;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.b2c.GrupoShop;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.domain.regranegocio.b2c.GrupoShopRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupos-shop"})
@SubMenuMapping(MENU="SubMenuUniplusShopAuxiliar", ICONE="icon-incluir-subgrupo", NOME="Categorias", ROTA="/uniplusshop/grupos-shop", PROGRAMA=9002)
public class GrupoShopController
extends HierarquiaCrudController<GrupoShop, GrupoShopRN> {
    public GrupoShopController() {
        super((HierarquiaRN)GrupoShopRN.getInstance(), GrupoShop::new, false);
    }

    protected String getCacheId() {
        return "grupos-shop";
    }

    protected GridBuilder<GrupoShopRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("ordem", "ordem", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        this.addColunaNivel(colunas);
        return new GridBuilder(GrupoShopRN.getInstance().getTabela(), colunas, Arrays.asList(new Ordem("ordem"), new Ordem("codigo")));
    }

    @DBAutoCommit
    public boolean validateSubgroup(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        GrupoShop grupoShop = (GrupoShop)GrupoShopRN.getInstance().buscarPorId(id);
        if (!GrupoShopRN.getInstance().isHierarquiaPossuiFilhos(grupoShop.getCodigo()) && ProdutoRN.getInstance().countRegistrosPorIdGrupoShop(id) > 0) {
            throw new UnicoMensagemUsuarioException("WWW611", "N\u00e3o \u00e9 poss\u00edvel inserir uma subcategoria em '" + grupoShop.getNome() + "', pois j\u00e1 existem produtos cadastrados para ele");
        }
        if (grupoShop.isTerceiroNivel()) {
            throw new UnicoMensagemUsuarioException("WWW612", "N\u00e3o \u00e9 poss\u00edvel adicionar uma subcategoria. S\u00e3o permitidos apenas tr\u00eas n\u00edveis.");
        }
        return true;
    }
}

