/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder;

import br.intelidata.api.b2c.service.placeholder.ParametrosPlaceHolder;
import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.service.ProdutoShopImagemService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder.ParamsJobWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder.PlaceHolderJob;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public class ProdutoShopImagemController
extends SimpleController
implements ICreateTask {
    private final ProdutoShopImagemService produtoImagemService;
    private final TaskManager taskManager;

    public ProdutoShopImagemController(ProdutoShopImagemService produtoImagemService, TaskManager taskManager) {
        this.produtoImagemService = produtoImagemService;
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.UPLOAD_IMAGENS;
    }

    public Class<? extends AbstractJob> job() {
        return PlaceHolderJob.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @GetMapping(value={"/diretorio-base"})
    public String getDiretorioConfigurado() {
        return this.produtoImagemService.getDiretorioBase();
    }

    @PostMapping(value={"/processar"})
    @DBTransaction
    public void processarArquivosCdn(@RequestPart(value="file") MultipartFile[] files, @RequestPart(value="parametros") ParametrosPlaceHolder parametro) throws UnicoMensagemUsuarioException {
        Path diretorioTemporario = Paths.get(this.produtoImagemService.getDiretorioBase() + File.separator + "imagens_" + ContextoHolder.getTenant() + "_" + System.currentTimeMillis(), new String[0]);
        try {
            if (!Files.exists(diretorioTemporario, new LinkOption[0])) {
                Files.createDirectory(diretorioTemporario, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW606", "N\u00e3o foi poss\u00edvel criar o diret\u00f3rio tempor\u00e1rio.");
        }
        for (MultipartFile file : files) {
            String nomeArquivo = file.getOriginalFilename() != null ? file.getOriginalFilename() : file.getName();
            try {
                Files.copy(file.getInputStream(), diretorioTemporario.resolve(nomeArquivo), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW607", "N\u00e3o foi poss\u00edvel processar o upload do arquivo.", (Throwable)e);
            }
        }
        ParamsJobWrapper paramsJobWrapper = new ParamsJobWrapper(diretorioTemporario.toString(), ParamsJobWrapper.Servico.ProdutoShopImagemService, parametro);
        this.createTask((Object)paramsJobWrapper, "Upload de imagens em lote");
    }
}

