/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.estoque.saldolicenca;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.SaldoLicenca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.SaldoLicencaRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/saldo-licencas"})
public class SaldoLicencaCrudController
extends CrudController<SaldoLicenca, SaldoLicencaRN> {
    public SaldoLicencaCrudController() {
        super((AbstractRegraNegocio)SaldoLicencaRN.getInstance(), SaldoLicenca::new);
        this.dependsOn("idCliente");
    }

    protected String getCacheId() {
        return "saldo-licencas";
    }

    protected GridBuilder<SaldoLicencaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 250, true, new String[]{"fk_saldolicenca_cliente"}));
        colunas.add(new ColunaSQL("nome", "produto", "Produto", 0, true, new String[]{"fk_saldolicenca_produto"}));
        colunas.add(new ColunaSQL("nomeecf", "produtoSite", "Produto site", 0, true, new String[]{"fk_saldolicenca_produto"}));
        colunas.add(new ColunaSQL("quantidade", "Saldo", 0, true));
        GridBuilder grid = new GridBuilder(((SaldoLicencaRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idCliente"));
        grid.addCodicaoDefault(new Condicao("quantidade", Operador.MAIOR_QUE, BigDecimal.ZERO));
        grid.setOrdemDefault(new Ordem("produto", true));
        return grid;
    }
}

