/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.pacotelicenca;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.logtracker.LogManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.PacoteLicenca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.PacoteLicencaRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pacotes-licencas"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Pacote licen\u00e7a", ROTA="/intelidata/pacotes-licencas", PROGRAMA=9000019)
public class PacoteLicencaCrudController
extends CrudController<PacoteLicenca, PacoteLicencaRN> {
    public PacoteLicencaCrudController() {
        super((AbstractRegraNegocio)PacoteLicencaRN.getInstance(), PacoteLicenca::new);
    }

    @RequestMapping(value={"/utilizar-pacote"})
    @DBTransaction
    public void utilizarCupom(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        PacoteLicenca pacoteLicenca = PacoteLicencaRN.getInstance().buscarPorId(id);
        if (pacoteLicenca != null) {
            LogManager.getInstance().utilizarPacoteLicenca(pacoteLicenca.getNumero(), pacoteLicenca.getIdCliente(), SessaoUtil.getSessao().getIdUsuario());
        }
    }

    protected void beforeUpdate(PacoteLicenca pacoteLicenca, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (pacoteLicenca.isUtilizado()) {
            throw new UnicoMensagemUsuarioException("WWW302", "Esse pacote j\u00e1 foi utilizado e por isso nao pode ser alterado");
        }
        super.beforeUpdate((AbstractPojo)pacoteLicenca, parentId);
    }

    protected void beforeRead(PacoteLicenca pacoteLicenca, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (7 == modo) {
            pacoteLicenca.setDataUtilizado(null);
            pacoteLicenca.setIdUsuarioSiteUtilizado(null);
            pacoteLicenca.setIdUsuarioUtilizado(null);
            pacoteLicenca.setUtilizado(false);
            pacoteLicenca.setNumero(null);
        }
    }

    protected String getCacheId() {
        return "pacotes-licencas";
    }

    protected GridBuilder<PacoteLicencaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("numero", "N\u00famero", 150, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("nome", "cliente", "Cliente", 0, true, new String[]{"fk_pacotelicenca_cliente"}));
        colunas.add(new ColunaSQL("validade", "Validade", 100, true));
        colunas.add(new ColunaSQL("total", "Valor", 100, true));
        colunas.add(new ColunaSQL("utilizado", "Utilizado", 100, true));
        GridBuilder grid = new GridBuilder(PacoteLicencaRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("validade", true));
        return grid;
    }
}

