/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.comunicacao.ecfautorizada;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.EcfAutorizada;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.VersaoPafEstado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.EcfAutorizadaRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.VersaoPafEstadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.comunicacao.ecfautorizada.PedidoAutorizacaoEcfResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.DadosAutorizacaoEcf;
import unipaf.ModeloEcf;

@RestController
@RequestMapping(value={"/api/ecf-autorizadas"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="ECFs autorizadas", ROTA="/intelidata/ecf-autorizadas", PROGRAMA=9000005)
public class EcfAutorizadaCrudController
extends CrudController<EcfAutorizada, EcfAutorizadaRN> {
    private ConnectionOAuth2Service oAuth2Service;

    public EcfAutorizadaCrudController(ConnectionOAuth2Service oAuth2Service) {
        super((AbstractRegraNegocio)EcfAutorizadaRN.getInstance(), EcfAutorizada::new);
        this.oAuth2Service = oAuth2Service;
    }

    @RequestMapping(value={"/autorizar"})
    @DBAutoCommit
    public String autorizarEcf(@RequestParam Long id, @RequestParam ModeloEcf modeloEcf) throws UnicoMensagemUsuarioException {
        EcfAutorizada ecfAutorizada = (EcfAutorizada)EcfAutorizadaRN.getInstance().buscarPorId(id);
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(ecfAutorizada.getIdEntidade());
        if (entidade == null) {
            throw new UnicoMensagemUsuarioException("COM236618", "Informe a revenda para esta ECF");
        }
        if (Util.stringNullOrEmpty((String)entidade.getEmailTecnico())) {
            throw new UnicoMensagemUsuarioException("COM236619", "Informe o email t\u00e9cnico da revenda " + entidade);
        }
        String versaoPaf = "";
        VersaoPafEstado versaoPafEstado = VersaoPafEstadoRN.getInstance().getVersaoMaisRecente(ecfAutorizada.getIdEstado());
        if (versaoPafEstado != null) {
            versaoPaf = versaoPafEstado.getVersaoPaf();
        }
        DadosAutorizacaoEcf dadosAutorizacao = new DadosAutorizacaoEcf();
        dadosAutorizacao.setNumeroSerie(ecfAutorizada.getNumeroSerie());
        dadosAutorizacao.setCnpj(ecfAutorizada.getCnpj());
        dadosAutorizacao.setVersaoPaf(versaoPaf);
        dadosAutorizacao.setGt(BigDecimal.ZERO);
        dadosAutorizacao.setModeloEcf(modeloEcf);
        dadosAutorizacao.setRazoSocial(ecfAutorizada.getRazaoSocial());
        dadosAutorizacao.setFabricante(ecfAutorizada.getMarca());
        dadosAutorizacao.setModelo(ecfAutorizada.getMarca());
        try {
            JSONObject jsonCredentials = new JSONObject().put("pedido", (Object)dadosAutorizacao.geraPedido());
            ResponseEntity responseEntity = this.oAuth2Service.post("pedidoautorizacaoecf", jsonCredentials, PedidoAutorizacaoEcfResponse.class);
            PedidoAutorizacaoEcfResponse pedido = null;
            if (responseEntity.getStatusCode().equals((Object)HttpStatus.OK)) {
                pedido = (PedidoAutorizacaoEcfResponse)responseEntity.getBody();
            }
            if (pedido != null) {
                return pedido.getMensagem();
            }
        }
        catch (Exception e) {
            throw new UnicoMensagemUsuarioException("WWW234", "N\u00e3o foi poss\u00edvel consultar o servidor.", (Throwable)e);
        }
        return "";
    }

    protected String getCacheId() {
        return "ecf-autorizadas";
    }

    protected GridBuilder<EcfAutorizadaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 0, true, new String[]{"fk_ecfautorizada_entidade"}));
        colunas.add(new ColunaSQL("numeroSerie", "N\u00famero de s\u00e9rie da ECF", 0, true));
        colunas.add(new ColunaSQL("cnpj", "CNPJ da ECF", 0, true));
        colunas.add(new ColunaSQL("razaoSocial", "Raz\u00e3o social da ECF", 0, true));
        colunas.add(new ColunaSQL("marca", "Marca da ECF", 0, true));
        colunas.add(new ColunaSQL("modelo", "Modelo da ECF", 0, true));
        return new GridBuilder(((EcfAutorizadaRN)this.rn).getTabela(), colunas);
    }
}

